/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Term;
import java.util.Vector;

public class StripsRule {
    protected Goal action;
    protected Vector preconditions;
    protected Vector addList;
    protected Vector deleteList;
    protected Predicate pred;
    private int varCounter;

    public StripsRule(Predicate p) {
        this.action = new Goal(p);
        this.preconditions = new Vector(5, 2);
        this.addList = new Vector(5, 2);
        this.deleteList = new Vector(5, 2);
        this.pred = p;
        this.varCounter = 0;
    }

    public StripsRule(Goal h, Vector pre, Vector add, Vector del) {
        this.varCounter = 0;
        this.action = h;
        this.preconditions = pre;
        this.addList = add;
        this.deleteList = del;
        this.pred = h.getPredicate();
        Vector terms = this.getVariables();
        int i = 0;
        while (i < terms.size()) {
            Term t = (Term)terms.elementAt(i);
            int j = 0;
            while (j < terms.size()) {
                Term t1 = (Term)terms.elementAt(j);
                if (t1 != t && t1.name.equals(t.name)) {
                    terms.setElementAt(t1, i);
                    if (t.isList) {
                        t1.isList = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.putVariables(terms);
    }

    public void reset() {
        this.varCounter = 0;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public Goal getAction() {
        return this.action;
    }

    public Vector getPreconditions() {
        return this.preconditions;
    }

    public Vector getAddList() {
        return this.addList;
    }

    public Vector getDeleteList() {
        return this.deleteList;
    }

    public Vector getVariables() {
        int j;
        Goal g;
        Vector<Term> vars = new Vector<Term>();
        int i = 0;
        while (i < this.action.getVariables().size()) {
            vars.addElement((Term)this.action.getVariables().elementAt(i));
            ++i;
        }
        i = 0;
        while (i < this.preconditions.size()) {
            g = (Goal)this.preconditions.elementAt(i);
            j = 0;
            while (j < g.getVariables().size()) {
                vars.addElement((Term)g.getVariables().elementAt(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            g = (Goal)this.addList.elementAt(i);
            j = 0;
            while (j < g.getVariables().size()) {
                vars.addElement((Term)g.getVariables().elementAt(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            g = (Goal)this.deleteList.elementAt(i);
            j = 0;
            while (j < g.getVariables().size()) {
                vars.addElement((Term)g.getVariables().elementAt(j));
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public void putVariables(Vector terms) {
        int index = this.action.putVariables(terms, 0);
        int i = 0;
        while (i < this.preconditions.size()) {
            index = ((Goal)this.preconditions.elementAt(i)).putVariables(terms, index);
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            index = ((Goal)this.preconditions.elementAt(i)).putVariables(terms, index);
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            index = ((Goal)this.preconditions.elementAt(i)).putVariables(terms, index);
            ++i;
        }
    }

    public Vector applyUnification() {
        Vector v = new Vector(3);
        Vector<Goal> precond = new Vector<Goal>(this.preconditions.size());
        int i = 0;
        while (i < this.preconditions.size()) {
            Goal g = (Goal)this.preconditions.elementAt(i);
            Goal g1 = g.fixTerms2();
            precond.addElement(g1);
            ++i;
        }
        v.addElement(precond);
        Vector<Goal> add = new Vector<Goal>(this.addList.size());
        int i2 = 0;
        while (i2 < this.addList.size()) {
            Goal g = (Goal)this.addList.elementAt(i2);
            Goal g1 = g.fixTerms2();
            add.addElement(g1);
            ++i2;
        }
        v.addElement(add);
        Vector<Goal> del = new Vector<Goal>(this.deleteList.size());
        int i3 = 0;
        while (i3 < this.deleteList.size()) {
            Goal g = (Goal)this.deleteList.elementAt(i3);
            Goal g1 = g.fixTerms2();
            del.addElement(g1);
            ++i3;
        }
        v.addElement(del);
        return v;
    }

    protected StripsRule rename(Vector v) {
        Vector theseTerms = this.getVariables();
        int i = 0;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.elementAt(i);
            t.clearUnified();
            if (t.type == 0) {
                String name = t.realName;
                Integer count = new Integer(this.varCounter);
                while (v.contains(name) || this.occursLater(i, name, t)) {
                    name = String.valueOf(t.realName) + count.toString();
                    count = new Integer(count + 1);
                }
                t.name = name;
            }
            ++i;
        }
        StripsRule r = new StripsRule(new Goal(this.action), (Vector)this.preconditions.clone(), (Vector)this.addList.clone(), (Vector)this.deleteList.clone());
        return r;
    }

    public StripsRule applySubs(Vector subs) {
        Goal newHead = this.action.applySubs(subs);
        Vector<Goal> newPreconds = new Vector<Goal>(this.preconditions.size());
        int i = 0;
        while (i < this.preconditions.size()) {
            newPreconds.addElement(((Goal)this.preconditions.elementAt(i)).applySubs(subs));
            ++i;
        }
        Vector<Goal> newAdds = new Vector<Goal>(this.addList.size());
        int i2 = 0;
        while (i2 < this.addList.size()) {
            newAdds.addElement(((Goal)this.addList.elementAt(i2)).applySubs(subs));
            ++i2;
        }
        Vector<Goal> newDels = new Vector<Goal>(this.preconditions.size());
        int i3 = 0;
        while (i3 < this.deleteList.size()) {
            newDels.addElement(((Goal)this.deleteList.elementAt(i3)).applySubs(subs));
            ++i3;
        }
        return new StripsRule(newHead, newPreconds, newAdds, newDels);
    }

    private boolean occursLater(int index, String name, Term term) {
        Vector theseTerms = this.getVariables();
        int i = index + 1;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.elementAt(i);
            if (t.realName.equals(name) && t != term) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void clearUnified() {
        Goal g;
        this.action.clearUnified();
        int i = 0;
        while (i < this.preconditions.size()) {
            g = (Goal)this.preconditions.elementAt(i);
            g.clearUnified();
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            g = (Goal)this.addList.elementAt(i);
            g.clearUnified();
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            g = (Goal)this.deleteList.elementAt(i);
            g.clearUnified();
            ++i;
        }
    }

    public String toString() {
        String str = new String(String.valueOf(this.action.toString()) + "\n");
        str = String.valueOf(str) + "preconditions: " + this.preconditions.toString() + "\n";
        str = String.valueOf(str) + "delete list: " + this.deleteList.toString() + "\n";
        str = String.valueOf(str) + "add list: " + this.addList.toString() + ".\n";
        return str;
    }
}

