/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Goal;
import CIspace.prolog.Predicate;
import CIspace.prolog.Term;
import java.util.Vector;

public class Rule {
    public Goal head;
    protected Vector body;
    protected Predicate pred;
    public int varCounter;

    public Rule(Predicate p) {
        this.head = this.makeGoal(p);
        this.body = new Vector(5, 2);
        this.pred = p;
        this.varCounter = 0;
    }

    public Rule(Goal h, Vector b) {
        this.head = h;
        this.body = b;
        this.pred = h.getPredicate();
        this.varCounter = 0;
        Vector terms = this.getVariables();
        int i = 0;
        while (i < terms.size()) {
            Term t = (Term)terms.elementAt(i);
            int j = 0;
            while (j < terms.size()) {
                Term t1 = (Term)terms.elementAt(j);
                if (t1 != t && t1.name.equals(t.name)) {
                    terms.setElementAt(t1, i);
                    if (t.isList) {
                        t1.isList = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.putVariables(terms);
    }

    protected Rule makeRule(Predicate p) {
        return new Rule(p);
    }

    protected Rule makeRule(Goal h, Vector b) {
        return new Rule(h, b);
    }

    protected Goal makeGoal(Predicate p) {
        return new Goal(p);
    }

    protected Goal makeGoal(Goal g) {
        return new Goal(g);
    }

    public void reset() {
        this.varCounter = 0;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public Goal ruleHead() {
        return this.head;
    }

    public Vector ruleBody() {
        return this.body;
    }

    public Vector getVariables() {
        Vector<Term> vars = new Vector<Term>();
        Vector headvars = this.head.getVariables();
        int i = 0;
        while (i < headvars.size()) {
            vars.addElement((Term)headvars.elementAt(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.body.size()) {
            Goal g = (Goal)this.body.elementAt(i2);
            Vector bodyvars = g.getVariables();
            int j = 0;
            while (j < bodyvars.size()) {
                vars.addElement((Term)bodyvars.elementAt(j));
                ++j;
            }
            ++i2;
        }
        return vars;
    }

    public void putVariables(Vector terms) {
        int index = this.head.putVariables(terms, 0);
        int i = 0;
        while (i < this.body.size()) {
            index = ((Goal)this.body.elementAt(i)).putVariables(terms, index);
            ++i;
        }
    }

    public Vector applyUnification() {
        Vector<Goal> newBody = new Vector<Goal>(this.body.size());
        int i = 0;
        while (i < this.body.size()) {
            Goal g = (Goal)this.body.elementAt(i);
            Goal g1 = g.fixTerms2();
            newBody.addElement(g1);
            ++i;
        }
        Goal newHead = this.head.fixTerms2();
        int i2 = 0;
        while (i2 < newBody.size()) {
            ((Goal)newBody.elementAt((int)i2)).derivedFrom = this;
            ++i2;
        }
        return newBody;
    }

    public Rule rename(Vector v) {
        Vector theseTerms = this.getVariables();
        int i = 0;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.elementAt(i);
            t.clearUnified();
            if (t.type == 0) {
                String name = t.realName;
                Integer count = new Integer(this.varCounter);
                while (v.contains(name) || this.occursLater(i, name, t)) {
                    name = String.valueOf(t.realName) + "_" + count.toString();
                    count = new Integer(count + 1);
                }
                t.name = name;
            }
            ++i;
        }
        Goal newHead = this.makeGoal(this.head);
        Vector<Goal> newBody = new Vector<Goal>(this.body.size());
        int i2 = 0;
        while (i2 < this.body.size()) {
            newBody.addElement(this.makeGoal((Goal)this.body.elementAt(i2)));
            ++i2;
        }
        Rule r = this.makeRule(newHead, newBody);
        r.varCounter = this.varCounter;
        return r;
    }

    public Rule applySubs(Vector subs) {
        Goal newHead = this.head.applySubs(subs);
        Vector<Goal> newBody = new Vector<Goal>(this.body.size());
        int i = 0;
        while (i < this.body.size()) {
            newBody.addElement(((Goal)this.body.elementAt(i)).applySubs(subs));
            ++i;
        }
        return this.makeRule(newHead, newBody);
    }

    private boolean occursLater(int index, String name, Term term) {
        Vector theseTerms = this.getVariables();
        int i = index + 1;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.elementAt(i);
            if (t.realName.equals(name) && t != term) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clearUnified() {
        this.head.clearUnified();
        int i = 0;
        while (i < this.body.size()) {
            Goal g = (Goal)this.body.elementAt(i);
            g.clearUnified();
            ++i;
        }
    }

    public String toString() {
        String str = new String(this.head.toString());
        if (this.body.size() > 0) {
            str = String.valueOf(str) + " <- " + ((Goal)this.body.elementAt(0)).toString();
        }
        int i = 1;
        while (i < this.body.size()) {
            str = String.valueOf(str) + " & " + ((Goal)this.body.elementAt(i)).toString();
            ++i;
        }
        str = String.valueOf(str) + ".";
        return str;
    }
}

