/*
 * Decompiled with CFR 0.152.
 */
package CIspace.prolog;

import CIspace.prolog.Rule;
import java.util.Vector;

public class Predicate {
    public static final int LESS_OR_EQUAL = 550;
    public static final int GREATER_OR_EQUAL = 551;
    public static final int LESS_THAN = 552;
    public static final int GREATER_THAN = 553;
    public static final int NOT_EQUAL = 554;
    public static final int DENOTE_DIFFERENT = 555;
    public static final int IS = 556;
    public static final int EQUALS = 557;
    public String name;
    public int type;
    public int arity;
    public Vector rules;
    protected boolean builtIn;

    public Predicate(String newName, int newArity) {
        this.builtIn = false;
        this.name = newName;
        this.arity = newArity;
        this.rules = new Vector(5, 2);
    }

    public Predicate() {
    }

    public Predicate makePredicate(String newName, int newArity) {
        return new Predicate(newName, newArity);
    }

    protected Predicate getPred(int type) {
        Predicate p = this.makePredicate(String.valueOf(type), 2);
        p.builtIn = true;
        p.type = type;
        return p;
    }

    protected Predicate getPred(int type, int arity) {
        Predicate p = this.makePredicate(String.valueOf(type), arity);
        p.builtIn = true;
        p.type = type;
        return p;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean builtIn() {
        return this.builtIn;
    }

    public int getType() {
        return this.type;
    }

    public Vector getRules() {
        return this.rules;
    }

    public int getNumRules() {
        return this.rules.size();
    }

    public void resetRules() {
        int i = 0;
        while (i < this.rules.size()) {
            ((Rule)this.rules.elementAt(i)).reset();
            ++i;
        }
    }

    public boolean addRule(Rule newRule) {
        if (newRule.getPredicate() != this) {
            return false;
        }
        if (!this.rules.contains(newRule)) {
            this.rules.addElement(newRule);
        }
        return true;
    }

    public boolean equals(Predicate p) {
        if (this.builtIn()) {
            return p.type == this.type;
        }
        return this.arity == p.arity && this.name.equals(p.name);
    }

    public String toString() {
        return String.valueOf(this.name) + "/" + this.arity;
    }
}

