/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.Vector;

public class HistogramNode
extends Node {
    protected char[] data;
    protected int numdecimalplaces;
    protected boolean showHistogram;
    protected String caption;
    protected Vector labels;
    protected Vector values;
    protected int totalValue;
    protected FontMetrics fontMetrics;
    protected DecimalFormat numFormat;
    protected int maxLabelWidth;
    protected Point nw;
    protected int lineHeight;
    protected int histogramNodeShape;
    protected final int LINE_PADDING = 3;
    protected final int HORIZ_PAD = 3;
    protected final int VERT_PAD = 3;
    protected final int MAX_BAR_WIDTH = 50;
    protected final int NUM_DASHED_LINES = 2;
    protected final int DASH_SIZE = 4;
    protected final int MINIMUM_LABEL_VAL_SPACE = 4;

    public HistogramNode(Graph graph) {
        super(graph);
        this.construct();
    }

    public HistogramNode(Graph graph, String label, Point pos, Color color, int shape) {
        super(graph);
        this.label[0] = label;
        this.pos = pos;
        this.color = color;
        this.shape = shape;
        this.construct();
    }

    protected void construct() {
        this.showHistogram = false;
        this.caption = new String("");
        this.totalValue = 0;
        this.fontMetrics = this.graph.canvas.getFontMetrics();
        this.maxLabelWidth = 0;
        this.numFormat = new DecimalFormat("0.0####;0.0####");
        this.data = new char[7];
        this.data[0] = 48;
        this.data[1] = 46;
        int i = 2;
        while (i < 7) {
            this.data[i] = 48;
            ++i;
        }
        this.numdecimalplaces = 2;
        this.histogramNodeShape = 1111;
    }

    public void addHistogramLabel(String newLabel) {
        int newLabelWidth = this.fontMetrics.stringWidth(newLabel) + 4;
        if (newLabelWidth > this.maxLabelWidth) {
            this.maxLabelWidth = newLabelWidth;
        }
        this.labels.addElement(newLabel);
    }

    public void addHistogramValue(int newValue) {
        this.values.addElement(new Integer(newValue));
        this.totalValue += newValue;
    }

    public void clearHistogram() {
        this.totalValue = 0;
        this.labels = new Vector();
        this.values = new Vector();
    }

    public void setHistogramCaption(String caption) {
        this.caption = caption;
    }

    public void showHistogramView(boolean showHistogram) {
        this.showHistogram = showHistogram;
        if (!showHistogram) {
            this.updateSize();
        }
    }

    public void toggleHistogramView() {
        boolean bl = this.showHistogram = !this.showHistogram;
        if (!this.showHistogram) {
            this.updateSize();
        }
    }

    public boolean isHistogramViewOn() {
        return this.showHistogram;
    }

    protected void resetMaxLabelWidth() {
        this.maxLabelWidth = 0;
        if (this.labels != null) {
            int i = 0;
            while (i < this.labels.size()) {
                int newLabelWidth = this.fontMetrics.stringWidth((String)this.labels.elementAt(i)) + 4;
                if (newLabelWidth > this.maxLabelWidth) {
                    this.maxLabelWidth = newLabelWidth;
                }
                ++i;
            }
        }
    }

    public void draw(Graphics offscreen, boolean moving) {
        if (this.fontMetrics != this.graph.canvas.getFontMetrics()) {
            this.fontMetrics = this.graph.canvas.getFontMetrics();
            this.resetMaxLabelWidth();
        }
        if (this.showHistogram && this.values.size() > 0 && (double)this.totalValue > 0.1) {
            this.drawNode(offscreen, moving);
        } else {
            super.draw(offscreen, moving);
        }
    }

    private void drawNode(Graphics offscreen, boolean moving) {
        this.lineHeight = this.fontMetrics.getHeight();
        this.height = (this.lineHeight + 3) * (this.labels.size() + 1) + 6;
        this.width = this.maxLabelWidth + 50 + this.fontMetrics.charsWidth(this.data, 0, this.numdecimalplaces + 2) + 12;
        if (this.histogramNodeShape == 1113) {
            this.height += this.lineHeight / 2;
        }
        if (this.width < this.fontMetrics.stringWidth(this.caption)) {
            this.width = this.fontMetrics.stringWidth(this.caption) + 6;
            if (this.histogramNodeShape == 1113) {
                this.width += 30;
            }
        }
        this.nw = new Point(this.pos);
        this.nw.translate(-this.width / 2, -this.height / 2);
        this.drawOutline(offscreen);
        if (!moving) {
            this.drawHistogramNode(offscreen);
        }
    }

    private void drawHistogramNode(Graphics g) {
        this.drawOutline(g);
        this.drawCaption(g);
        this.drawRows(g);
    }

    protected void drawRows(Graphics g) {
        int currentRowY = (int)this.nw.y + 2 * this.lineHeight + 6;
        int valueX = (int)this.nw.x + this.width - 3 - 50 - 3 - this.fontMetrics.charsWidth(this.data, 0, this.numdecimalplaces + 2);
        int barX = (int)this.nw.x + this.width - 50;
        g.drawLine(barX - 1, (int)this.nw.y + this.lineHeight + 3, barX - 1, (int)this.nw.y + this.height);
        this.drawDashedLines(g, barX, (int)this.nw.y + this.lineHeight + 3, (int)this.nw.x + this.width, (int)this.nw.y + this.height);
        int i = 0;
        while (i < this.labels.size()) {
            int currentValue = (Integer)this.values.elementAt(i);
            g.setColor(Color.black);
            if (this.histogramNodeShape == 1113) {
                g.drawString((String)this.labels.elementAt(i), (int)(this.nw.x + 3.0f) + 6, currentRowY);
            } else if (this.histogramNodeShape == 1111) {
                g.drawString((String)this.labels.elementAt(i), (int)(this.nw.x + 3.0f), currentRowY);
            }
            g.drawString(this.numFormat.format((double)currentValue / Math.pow(10.0, this.numdecimalplaces)), valueX, currentRowY);
            int barWidth = (int)(50.0 * ((double)currentValue / (double)this.totalValue));
            g.fillRect(barX, currentRowY - this.lineHeight + 5, barWidth, this.lineHeight - 3);
            currentRowY += this.lineHeight + 3;
            ++i;
        }
    }

    protected void drawDashedLines(Graphics g, int startX, int startY, int endX, int endY) {
        int currentX = startX;
        int increment = (endX - startX) / 3;
        currentX += increment;
        int i = 0;
        while (i < 2) {
            int currentY = startY;
            while (currentY < endY - 4) {
                g.drawLine(currentX, currentY, currentX, currentY + 4);
                currentY += 8;
            }
            if (currentY < endY) {
                g.drawLine(currentX, currentY, currentX, endY);
            }
            currentX += increment;
            ++i;
        }
    }

    private void drawCaption(Graphics g) {
        int captionWidth = this.fontMetrics.stringWidth(this.caption);
        int captionHeight = this.fontMetrics.getHeight();
        g.setColor(Color.black);
        g.drawString(this.caption, (int)this.pos.x - captionWidth / 2, (int)this.nw.y + captionHeight);
        g.setColor(this.color);
        g.drawLine((int)this.nw.x, (int)this.nw.y + captionHeight + 3, (int)this.nw.x + this.width, (int)this.nw.y + captionHeight + 3);
    }

    private void drawOutline(Graphics offscreen) {
        float lineWidth = this.graph.getLineWidth() + (float)this.xw;
        offscreen.setColor(this.color);
        if (lineWidth == 1.0f) {
            if (this.isBold) {
                offscreen.setColor(this.color);
            } else {
                offscreen.setColor(Color.white);
            }
            if (this.histogramNodeShape == 1113) {
                offscreen.fillRoundRect((int)this.nw.x, (int)this.nw.y, this.width, this.height, this.height / 2, this.height / 2);
                offscreen.setColor(this.color);
                offscreen.drawRoundRect((int)this.nw.x, (int)this.nw.y, this.width, this.height, this.height / 2, this.height / 2);
            } else if (this.histogramNodeShape == 1111) {
                offscreen.fillRect((int)this.nw.x, (int)this.nw.y, this.width, this.height);
                offscreen.setColor(this.color);
                offscreen.drawRect((int)this.nw.x, (int)this.nw.y, this.width, this.height);
            }
        } else {
            if (this.histogramNodeShape == 1113) {
                offscreen.fillRoundRect((int)(this.nw.x - lineWidth), (int)(this.nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)this.height + lineWidth * 2.0f), this.height / 2, this.height / 2);
            } else if (this.histogramNodeShape == 1111) {
                offscreen.fillRect((int)(this.nw.x - lineWidth), (int)(this.nw.y - lineWidth), (int)((float)this.width + lineWidth * 2.0f), (int)((float)this.height + lineWidth * 2.0f));
            }
            if (!this.isBold) {
                offscreen.setColor(Color.white);
            }
            if (this.histogramNodeShape == 1113) {
                offscreen.fillRoundRect((int)this.nw.x, (int)this.nw.y, this.width, this.height, this.height / 2, this.height / 2);
            } else if (this.histogramNodeShape == 1111) {
                offscreen.fillRect((int)this.nw.x, (int)this.nw.y, this.width, this.height);
            }
        }
    }

    public void setHistogramNodeShape(int newShape) {
        this.histogramNodeShape = newShape;
    }
}

