/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.Edge;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EdgeDialog
extends JDialog
implements ActionListener {
    private JButton ok;
    private JButton cancel;
    private JComboBox colors;
    private JComboBox types;
    private GraphCanvas parent;
    private Node start;
    private Node end;
    private JTextField label;
    private boolean creating;
    private Edge edge;

    public EdgeDialog(GraphCanvas parent) {
        super((JFrame)parent.parent, "Edge Options", true);
        this.parent = parent;
        this.creating = true;
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.colors = new JComboBox();
        this.colors.addItem("Black");
        this.colors.addItem("Red");
        this.colors.addItem("Blue");
        this.colors.addItem("Green");
        this.types = new JComboBox();
        this.types.addItem("Directional");
        this.types.addItem("Bi-directional");
        this.types.addItem("Non-directional");
        this.label = new JTextField("", 10);
        this.label.addActionListener(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(3, 1));
        JPanel p1 = new JPanel();
        p1.add(new JLabel("Label"));
        p1.add(this.label);
        contentPane.add(p1);
        JPanel p2 = new JPanel();
        p2.add(this.colors);
        p2.add(this.types);
        contentPane.add(p2);
        JPanel p4 = new JPanel();
        p4.add(this.ok);
        p4.add(this.cancel);
        contentPane.add(p4);
    }

    public void open(Node start, Node end) {
        this.creating = true;
        this.centerWindow();
        this.start = start;
        this.end = end;
        ((Component)this).setSize(265, 150);
        ((Component)this).setVisible(true);
    }

    public void open(Edge e) {
        this.creating = false;
        this.edge = e;
        this.start = e.start;
        this.end = e.end;
        this.label.setText(e.label[0]);
        if (e.color == Color.black) {
            this.colors.setSelectedItem("Black");
        } else if (e.color == Color.red) {
            this.colors.setSelectedItem("Red");
        } else if (e.color == Color.blue) {
            this.colors.setSelectedItem("Blue");
        } else {
            this.colors.setSelectedItem("Green");
        }
        if (e.type == 5551) {
            this.types.setSelectedItem("Directional");
        } else if (e.type == 5552) {
            this.types.setSelectedItem("Bi-directional");
        } else {
            this.types.setSelectedItem("Non-directional");
        }
        this.centerWindow();
        ((Component)this).setVisible(true);
    }

    private void centerWindow() {
        Container parent = this.getParent();
        int midX = parent.getLocationOnScreen().x + parent.getSize().width / 2;
        int midY = parent.getLocationOnScreen().y + parent.getSize().height / 2;
        ((Component)this).setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (!arg.equals("Cancel")) {
            this.parseDialog();
        }
        ((Component)this).setVisible(false);
    }

    private void parseDialog() {
        Color color = this.colors.getSelectedItem() == "Black" ? Color.black : (this.colors.getSelectedItem() == "Red" ? Color.red : (this.colors.getSelectedItem() == "Blue" ? Color.blue : Color.green));
        int type = this.types.getSelectedItem().equals("Directional") ? 5551 : (this.types.getSelectedItem().equals("Bi-directional") ? 5552 : 5550);
        if (this.creating) {
            Edge e = new Edge(this.parent.graph, this.label.getText(), this.start, this.end, color, type);
            this.parent.graph.addEdge(e);
        } else {
            this.parent.graph.modifyEdge(this.edge, this.label.getText(), this.start, this.end, color, type);
        }
    }
}

