/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.EdgeLabel;
import CIspace.graphToolKit.Entity;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.Node;
import CIspace.graphToolKit.Point;
import java.awt.Color;
import java.awt.Graphics;

public class Edge
extends Entity {
    public Node start;
    public Node end;
    protected float length;
    public int edgeType;
    protected Point[] b;
    protected Point[] p;
    public EdgeLabel eLabel;

    public Edge(Graph graph) {
        super(graph);
        this.label[0] = "";
        this.start = null;
        this.end = null;
        this.isSelected = false;
        this.isBold = false;
        this.color = Color.black;
        this.length = 0.0f;
        this.edgeType = 5550;
        this.type = 7771;
        this.b = new Point[2];
        this.p = new Point[2];
        this.p[0] = new Point(0.0f, 0.0f);
        this.p[1] = new Point(0.0f, 0.0f);
        this.b[0] = new Point(0.0f, 0.0f);
        this.b[1] = new Point(0.0f, 0.0f);
        this.eLabel = new EdgeLabel(graph, this);
    }

    public Edge(Graph graph, String label, Node start, Node end, Color color, int edgeType) {
        super(graph);
        this.label[0] = label;
        this.start = start;
        this.end = end;
        this.isSelected = false;
        this.isBold = false;
        this.color = color;
        start.addEdgesOut(this);
        end.addEdgesIn(this);
        this.type = 7771;
        this.edgeType = edgeType;
        this.b = new Point[2];
        this.p = new Point[2];
        this.updateLength();
        this.eLabel = new EdgeLabel(graph, this);
    }

    public Edge(Graph graph, Node n1, Node n2) {
        super(graph);
        this.start = n1;
        this.end = n2;
        this.start.addEdgesOut(this);
        this.end.addEdgesIn(this);
        this.type = 7771;
        this.b = new Point[2];
        this.p = new Point[2];
        this.updateLength();
        this.eLabel = new EdgeLabel(graph, this);
    }

    public void setLabel(String str) {
        this.label[0] = str;
    }

    public void set(String l, Node s, Node e, Color c, int t) {
        this.label[0] = l;
        this.start = s;
        this.end = e;
        this.color = c;
        this.edgeType = t;
    }

    public void draw(Graphics g, boolean moving) {
        this.drawLine(g);
        if (this.edgeType != 5550) {
            this.drawArrow(g, false, this.b[0], this.b[1]);
            if (this.edgeType == 5552) {
                this.drawArrow(g, false, this.b[1], this.b[0]);
            }
        }
        if (!moving && this.isSelected && this.graph.canvas.getMode() != 2221) {
            this.drawHandle(g);
        }
    }

    public void drawPrint(Graphics g, boolean moving) {
        this.drawLine(g);
        if (this.edgeType != 5550) {
            this.drawArrow(g, false, this.b[0], this.b[1]);
            if (this.edgeType == 5552) {
                this.drawArrow(g, false, this.b[1], this.b[0]);
            }
        }
        if (!moving && this.isSelected && this.graph.canvas.getMode() != 2221) {
            this.drawHandle(g);
        }
    }

    public void drawStructure(Graphics g, boolean moving) {
        this.xw /= 2;
        this.drawLineStructure(g);
        if (this.edgeType != 5550) {
            this.drawArrowStructure(g, false, this.b[0], this.b[1]);
            if (this.edgeType == 5552) {
                this.drawArrowStructure(g, false, this.b[1], this.b[0]);
            }
        }
    }

    protected void drawLineStructure(Graphics g) {
        this.xw = 0;
        if (this.start.equals(this.end)) {
            this.drawLine2(g);
            return;
        }
        g.setColor(this.color);
        g.drawLine((int)this.start.pos.x, (int)this.start.pos.y, (int)this.end.pos.x, (int)this.end.pos.y);
    }

    protected void drawArrowStructure(Graphics g, boolean drawAnyways, Point tail, Point head) {
        if (this.length < 10.0f) {
            return;
        }
        float dx = head.x - tail.x;
        float dy = head.y - tail.y;
        dx /= 2.0f;
        dy /= 2.0f;
        float lineWidth = this.graph.getLineWidth() / 2.0f + (float)this.xw;
        float arrowWidth = this.graph.getArrowWidth() / 2.0f + (float)this.xw;
        float arrowHeight = this.graph.getArrowHeight() / 2.0f + (float)this.xw;
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4) / 2.0f;
            arrowWidth = (float)Math.ceil((double)arrowWidth * 1.4) / 2.0f;
            arrowHeight = (float)Math.ceil((double)arrowHeight * 1.4) / 2.0f;
        }
        if (arrowHeight > this.length) {
            return;
        }
        Point p1 = new Point(head);
        p1.translate(-arrowHeight / this.length * dx, -arrowHeight / this.length * dy);
        Point p2 = new Point(p1);
        Point c1 = new Point(p1);
        p1.translate(-arrowWidth / this.length * dy, arrowWidth / this.length * dx);
        p2.translate(arrowWidth / this.length * dy, -arrowWidth / this.length * dx);
        Point c2 = new Point(c1);
        c1.translate(-lineWidth / this.length * dy, lineWidth / this.length * dx);
        c2.translate(lineWidth / this.length * dy, -lineWidth / this.length * dx);
        Point c3 = new Point(head);
        Point c4 = new Point(c3);
        c3.translate(lineWidth / this.length * dy, -lineWidth / this.length * dx);
        c4.translate(-lineWidth / this.length * dy, lineWidth / this.length * dx);
        int[] x = new int[]{(int)head.x, (int)p1.x, (int)p2.x};
        int[] y = new int[]{(int)head.y, (int)p1.y, (int)p2.y};
        int[] x2 = new int[]{(int)c1.x, (int)c2.x, (int)c3.x, (int)c4.x};
        int[] y2 = new int[]{(int)c1.y, (int)c2.y, (int)c3.y, (int)c4.y};
        g.setColor(Color.white);
        g.fillPolygon(x2, y2, 4);
        if (this.isBold) {
            g.setColor(this.color);
        } else {
            g.setColor(Color.white);
        }
        g.fillPolygon(x, y, 3);
        g.setColor(this.color);
        g.drawPolygon(x, y, 3);
    }

    protected void drawLine(Graphics g) {
        if (this.start.equals(this.end)) {
            this.drawLine2(g);
            return;
        }
        g.setColor(this.color);
        g.drawLine((int)this.start.pos.x, (int)this.start.pos.y, (int)this.end.pos.x, (int)this.end.pos.y);
        float lineWidth = this.graph.getLineWidth() + (float)this.xw;
        if (lineWidth == 1.0f && !this.isBold) {
            return;
        }
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
        }
        float dx = this.b[1].x - this.b[0].x;
        float dy = this.b[1].y - this.b[0].y;
        Point p1 = new Point(this.b[0]);
        Point p2 = new Point(p1);
        p1.translate(-lineWidth / this.length * dy, lineWidth / this.length * dx);
        p2.translate(lineWidth / this.length * dy, -lineWidth / this.length * dx);
        Point p3 = new Point(this.b[1]);
        Point p4 = new Point(p3);
        p3.translate(lineWidth / this.length * dy, -lineWidth / this.length * dx);
        p4.translate(-lineWidth / this.length * dy, lineWidth / this.length * dx);
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)p1.x;
        x[1] = (int)p2.x;
        x[2] = (int)p3.x;
        x[3] = (int)p4.x;
        y[0] = (int)p1.y;
        y[1] = (int)p2.y;
        y[2] = (int)p3.y;
        y[3] = (int)p4.y;
        g.setColor(this.color);
        g.fillPolygon(x, y, 4);
    }

    protected void drawLine2(Graphics g) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point ne = new Point(this.start.pos.x + dx, this.start.pos.y - dy);
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)this.start.pos.x;
        y[0] = (int)this.start.pos.y;
        x[1] = (int)ne.x;
        y[1] = (int)ne.y;
        x[2] = (int)nw.x;
        y[2] = (int)nw.y;
        x[3] = x[0];
        y[3] = y[0];
        g.setColor(this.color);
        g.drawPolyline(x, y, 4);
        float lineWidth = this.graph.getLineWidth() + (float)this.xw;
        if (lineWidth == 1.0f && !this.isBold) {
            return;
        }
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
        }
        x = new int[8];
        y = new int[8];
        x[0] = (int)(this.start.pos.x + lineWidth);
        y[0] = (int)(this.start.pos.y + lineWidth);
        x[1] = (int)((double)ne.x + (double)lineWidth * 1.5);
        y[1] = (int)(ne.y - lineWidth);
        x[2] = (int)((double)nw.x - (double)lineWidth * 1.5);
        y[2] = (int)(nw.y - lineWidth);
        x[3] = (int)(this.start.pos.x - lineWidth);
        y[3] = y[0];
        x[4] = x[0];
        y[4] = y[0];
        x[5] = (int)nw.x;
        y[5] = (int)nw.y;
        x[6] = (int)ne.x;
        y[6] = (int)ne.y;
        x[7] = x[3];
        y[7] = y[3];
        g.fillPolygon(x, y, 8);
    }

    protected void drawArrow(Graphics g, boolean drawAnyways, Point tail, Point head) {
        if (this.start.equals(this.end) && !drawAnyways) {
            this.drawArrow2(g);
            return;
        }
        this.arrow(g, tail, head);
    }

    public void arrow(Graphics g, Point tail, Point head) {
        if (this.length < 10.0f) {
            return;
        }
        float dx = head.x - tail.x;
        float dy = head.y - tail.y;
        float lineWidth = this.graph.getLineWidth() + (float)this.xw;
        float arrowWidth = this.graph.getArrowWidth() + (float)this.xw;
        float arrowHeight = this.graph.getArrowHeight() + (float)this.xw;
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
            arrowWidth = (float)Math.ceil((double)arrowWidth * 1.4);
            arrowHeight = (float)Math.ceil((double)arrowHeight * 1.4);
        }
        if (arrowHeight > this.length) {
            return;
        }
        Point p1 = new Point(head);
        p1.translate(-arrowHeight / this.length * dx, -arrowHeight / this.length * dy);
        Point p2 = new Point(p1);
        Point c1 = new Point(p1);
        p1.translate(-arrowWidth / this.length * dy, arrowWidth / this.length * dx);
        p2.translate(arrowWidth / this.length * dy, -arrowWidth / this.length * dx);
        Point c2 = new Point(c1);
        c1.translate(-lineWidth / this.length * dy, lineWidth / this.length * dx);
        c2.translate(lineWidth / this.length * dy, -lineWidth / this.length * dx);
        Point c3 = new Point(head);
        Point c4 = new Point(c3);
        c3.translate(lineWidth / this.length * dy, -lineWidth / this.length * dx);
        c4.translate(-lineWidth / this.length * dy, lineWidth / this.length * dx);
        int[] x = new int[]{(int)head.x, (int)p1.x, (int)p2.x};
        int[] y = new int[]{(int)head.y, (int)p1.y, (int)p2.y};
        int[] x2 = new int[]{(int)c1.x, (int)c2.x, (int)c3.x, (int)c4.x};
        int[] y2 = new int[]{(int)c1.y, (int)c2.y, (int)c3.y, (int)c4.y};
        g.setColor(Color.white);
        g.fillPolygon(x2, y2, 4);
        if (this.isBold) {
            g.setColor(this.color);
        } else {
            g.setColor(Color.white);
        }
        g.fillPolygon(x, y, 3);
        g.setColor(this.color);
        g.drawPolygon(x, y, 3);
    }

    protected void drawArrow2(Graphics g) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        Node tmp = new Node(this.graph, "", nw, this.color, 1110);
        Point b = this.start.findBorder(tmp);
        this.length = this.distance(nw, b);
        this.drawArrow(g, true, nw, b);
    }

    public void drawHandle(Graphics g) {
        if (this.start.equals(this.end)) {
            this.drawHandle2(g);
            return;
        }
        Point mid = this.middle();
        g.setColor(Color.magenta);
        g.fillRect((int)this.b[0].x - 3, (int)this.b[0].y - 3, 6, 6);
        g.fillRect((int)this.b[1].x - 3, (int)this.b[1].y - 3, 6, 6);
        g.fillRect((int)mid.x - 3, (int)mid.y - 3, 6, 6);
    }

    public void drawHandle2(Graphics g) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point ne = new Point(this.start.pos.x + dx, this.start.pos.y - dy);
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        Point n = new Point(this.start.pos.x, this.start.pos.y - dy);
        g.setColor(Color.magenta);
        g.fillRect((int)n.x - 2, (int)n.y - 7, 4, 14);
        g.fillRect((int)n.x - 7, (int)n.y - 2, 14, 4);
        g.fillRect((int)ne.x - 3, (int)ne.y - 3, 6, 6);
        g.fillRect((int)nw.x - 3, (int)nw.y - 3, 6, 6);
    }

    public float distance(Point a, Point b) {
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public void updateLength() {
        this.b[0] = this.start.findBorder(this.end);
        this.b[1] = this.end.findBorder(this.start);
        this.length = this.distance(this.b[0], this.b[1]);
    }

    public void updateLengthStructure() {
        this.b[0] = this.start.findBorder(this.end);
        this.b[1] = this.end.findBorder(this.start);
        this.length = this.distance(this.b[0], this.b[1]) / 2.0f;
    }

    public boolean contains(Point p) {
        return this.contains1(p, false, this.start.pos, this.end.pos);
    }

    protected boolean contains1(Point p, boolean checkAnyways, Point a, Point b) {
        if (this.start.equals(this.end) && !checkAnyways) {
            return this.contains2(p);
        }
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        Point c = new Point(a.x - dy, a.y + dx);
        Point d = new Point(b.x + dy, b.y - dx);
        Point x = new Point(p.x - a.x, p.y - a.y);
        Point y = new Point(b.x - a.x, b.y - a.y);
        float projX = x.x - (x.x * y.x + x.y * y.y) / (y.x * y.x + y.y * y.y) * y.x;
        float projY = x.y - (x.x * y.x + x.y * y.y) / (y.x * y.x + y.y * y.y) * y.y;
        float distSqrd = projX * projX + projY * projY;
        return p.checkSide(a, c) < 0.0f && p.checkSide(b, d) < 0.0f && distSqrd < 100.0f;
    }

    protected boolean contains2(Point p) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point ne = new Point(this.start.pos.x + dx, this.start.pos.y - dy);
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        return this.contains1(p, true, this.end.pos, ne) || this.contains1(p, true, this.end.pos, nw) || this.contains1(p, true, ne, nw);
    }

    public boolean isInRect(Point a, Point b) {
        Point c = this.start.pos;
        Point d = this.end.pos;
        return c.x > a.x && c.x < b.x && c.y > a.y && c.y < b.y && d.x > a.x && d.x < b.x && d.y > a.y && d.y < b.y;
    }

    public void translate(float dx, float dy) {
    }

    public void move(Point p) {
    }

    public void removeFromNodes() {
        this.start.removeEdgesOut(this);
        this.end.removeEdgesIn(this);
    }

    public boolean equals(Entity ent) {
        if (ent.type == 7771) {
            Edge edge = (Edge)ent;
            return this.start.equals(edge.start) && this.end.equals(edge.end);
        }
        return false;
    }

    public Point middle() {
        float mx = (this.b[0].x + this.b[1].x) / 2.0f;
        float my = (this.b[0].y + this.b[1].y) / 2.0f;
        return new Point(mx, my);
    }

    public float getDx() {
        return this.b[1].x - this.b[0].x;
    }

    public float getDy() {
        return this.b[1].y - this.b[0].y;
    }

    public float getPx() {
        return this.p[1].y - this.p[0].y;
    }

    public float getPy() {
        return this.p[1].y - this.p[0].y;
    }

    public Point[] getB() {
        return this.b;
    }

    public Point[] getP() {
        return this.p;
    }

    public float getLength() {
        return this.length;
    }

    public Node otherNode(Node n1) {
        if (this.start.equals(n1)) {
            return this.end;
        }
        return this.start;
    }

    public String toString() {
        return this.start + " -> " + this.end;
    }
}

