/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.VE;

import AIspace.cspTools.VE.EltsIterator;
import AIspace.cspTools.VE.VE_Variable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Factor {
    public static boolean printVarIds = false;
    private static boolean savingForTracing = false;
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId;
    protected boolean hasBeenReordered = false;
    protected Factor reorderedFactor = null;
    protected int[] newToOldIndex = null;
    private VE_Variable[] variables;
    private int thesize;

    public int getReorderedIndex(int newIndex) {
        if (this.newToOldIndex == null) {
            throw new UnsupportedOperationException("Information was not saved for tracing.");
        }
        if (newIndex < 0 || newIndex >= this.newToOldIndex.length) {
            throw new IllegalArgumentException("Given index " + newIndex + " is invalid.");
        }
        return this.newToOldIndex[newIndex];
    }

    public boolean getSavingForTracing() {
        return savingForTracing;
    }

    public void setSavingForTracing(boolean val) {
        savingForTracing = val;
    }

    public Factor(VE_Variable[] vars) {
        this.variables = vars;
        this.thesize = 1;
        this.uniqueId = nextId.getAndIncrement();
        int i = 0;
        while (i < this.variables.length) {
            this.thesize *= this.variables[i].getDomainSize();
            ++i;
        }
    }

    public Factor(VE_Variable[] variables, boolean copyVariables) {
        if (copyVariables) {
            this.variables = new VE_Variable[variables.length];
            System.arraycopy(variables, 0, this.variables, 0, variables.length);
        } else {
            this.variables = variables;
        }
        int tSize = 1;
        VE_Variable[] vE_VariableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            VE_Variable variable = vE_VariableArray[n2];
            if (Long.MAX_VALUE / (long)variable.getDomain().length < (long)this.size()) {
                throw new OutOfMemoryError("New factor size is too large (greater than Long.Max_VALUE).");
            }
            tSize *= variable.getDomain().length;
            ++n2;
        }
        this.thesize = tSize;
        this.uniqueId = nextId.getAndIncrement();
    }

    public String getName() {
        String nameString = new String("[");
        if (this.variables.length > 0) {
            nameString = String.valueOf(nameString) + this.variables[0].getName();
        }
        int i = 1;
        while (i < this.variables.length) {
            nameString = String.valueOf(nameString) + ", " + this.variables[i].getName();
            ++i;
        }
        return String.valueOf(nameString) + "]";
    }

    public VE_Variable[] getVariables() {
        return this.variables;
    }

    public abstract EltsIterator iterator();

    public int size() {
        return this.thesize;
    }

    public boolean contains(VE_Variable v) {
        return Arrays.binarySearch(this.variables, v) >= 0;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < this.variables.length) {
            output.append(this.variables[i].getName()).append("\t");
            ++i;
        }
        output.append("Value\n");
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            int i2 = 0;
            while (i2 < this.variables.length) {
                output.append(this.variables[i2].getDomain()[index[i2]]).append("\t");
                ++i2;
            }
            output.append(iter.next()).append("\n");
            if (!iter.hasNext()) continue;
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomainSize() - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < this.variables.length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        return output.toString();
    }

    public void printVariables() {
        if (this.variables.length > 0) {
            System.out.print(this.variables[0].getName());
            if (printVarIds) {
                System.out.print("(#" + this.variables[0].getId() + ")");
            }
            int i = 1;
            while (i < this.variables.length) {
                System.out.print(", " + this.variables[i].getName());
                if (printVarIds) {
                    System.out.print("(#" + this.variables[i].getId() + ")");
                }
                ++i;
            }
        }
    }

    public void print() {
        this.print("");
    }

    public void print(String indent) {
        System.out.print(indent);
        int i = 0;
        while (i < this.variables.length) {
            System.out.print(this.variables[i].getName());
            System.out.print("\t");
            ++i;
        }
        System.out.print("Value\n");
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            System.out.print(indent);
            int i2 = 0;
            while (i2 < this.variables.length) {
                System.out.print(this.variables[i2].getDomain()[index[i2]]);
                System.out.print("\t");
                ++i2;
            }
            System.out.println(iter.next());
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomainSize() - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    allMax = false;
                } else {
                    index[i3] = 0;
                }
                --i3;
            }
        }
    }

    public boolean allOnes() {
        EltsIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() == 1.0) continue;
            return false;
        }
        return true;
    }

    public boolean isRedundant(VE_Variable var) {
        int before = 1;
        int dom = var.getDomainSize();
        int after = 1;
        int pos = 0;
        while (this.variables[pos] != var) {
            before *= this.variables[pos++].getDomainSize();
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomainSize();
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double val = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    if (val != its[i3].next()) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }

    public boolean isRedundant(VE_Variable var, double threshold) {
        int before = 1;
        int dom = var.getDomainSize();
        int after = 1;
        int pos = 0;
        while (this.variables[pos] != var) {
            before *= this.variables[pos++].getDomainSize();
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomainSize();
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double min;
                double max = min = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    double nextval = its[i3].next();
                    if (max < nextval) {
                        max = nextval;
                    } else if (min > nextval) {
                        min = nextval;
                    }
                    if (max - min > threshold) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }

    protected static final double[] reorderValues(Factor originalFactor, VE_Variable[] newOrder, int[] newToOldIndex) {
        if (originalFactor.variables.length != newOrder.length) {
            throw new IllegalArgumentException("Original factor and new order have different number of variables.");
        }
        boolean[] found = new boolean[originalFactor.variables.length];
        int[] newBase = new int[newOrder.length];
        int base = 1;
        int i = newOrder.length - 1;
        while (i >= 0) {
            boolean notFound = true;
            int j = 0;
            while (notFound && j < newOrder.length) {
                if (originalFactor.variables[j].equals(newOrder[i])) {
                    if (found[j]) {
                        throw new IllegalArgumentException("New order contains the same variable multiple times.");
                    }
                    found[j] = true;
                    newBase[j] = base;
                    base *= newOrder[i].getDomain().length;
                    notFound = false;
                }
                ++j;
            }
            if (notFound) {
                throw new IllegalArgumentException("New order contains a variable not present in the original factor.");
            }
            --i;
        }
        if (Integer.MAX_VALUE < originalFactor.size()) {
            throw new OutOfMemoryError("Original factor is too large (size greater than Integer.Max_VALUE).");
        }
        double[] values = new double[originalFactor.size()];
        int[] oldIndex = new int[newOrder.length];
        int newIndex = 0;
        EltsIterator originalFactorIterator = originalFactor.iterator();
        int index = 0;
        while (originalFactorIterator.hasNext()) {
            values[newIndex] = originalFactorIterator.next();
            if (newToOldIndex != null) {
                newToOldIndex[newIndex] = index++;
            }
            boolean incj = true;
            int j = newOrder.length - 1;
            while (incj && j >= 0) {
                int n = j;
                oldIndex[n] = oldIndex[n] + 1;
                if (oldIndex[n] == originalFactor.variables[j].getDomain().length) {
                    oldIndex[j] = 0;
                    newIndex -= (originalFactor.variables[j].getDomain().length - 1) * newBase[j];
                } else {
                    newIndex += newBase[j];
                    incj = false;
                }
                --j;
            }
        }
        return values;
    }
}

