/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LabelCanvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Font font = new Font("SansSerif", 0, 12);
    private FontMetrics fm = this.getFontMetrics(this.font);
    private JTextPane textArea;
    private StyledDocument doc;
    private MutableAttributeSet standard;

    public LabelCanvas() {
        this.setSize(100, this.fm.getHeight() * 2 + 5);
        this.setBackground(Color.white);
        this.textArea = new JTextPane();
        this.textArea.setEditable(false);
        this.doc = this.textArea.getStyledDocument();
        this.standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(this.standard, 1);
        StyleConstants.setFontFamily(this.standard, "SansSerif");
        StyleConstants.setFontSize(this.standard, 12);
        StyleConstants.setForeground(this.standard, Color.blue);
        this.doc.setParagraphAttributes(0, 0, this.standard, true);
        JScrollPane pane = new JScrollPane(this.textArea);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
    }

    public synchronized void setText(String text) {
        this.textArea.setText(text);
    }

    public void setTextColor(Color col) {
        StyleConstants.setForeground(this.standard, col);
        this.doc.setParagraphAttributes(0, 0, this.standard, true);
    }

    public void appendColoredText(String text, Color col) {
        StyleConstants.setForeground(this.standard, col);
        try {
            this.doc.insertString(this.doc.getLength(), text, this.standard);
            StyleConstants.setForeground(this.standard, Color.blue);
            this.doc.insertString(this.doc.getLength(), " ", this.standard);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setFontSize(int size) {
        this.font = new Font("SansSerif", 0, size);
        this.fm = this.getFontMetrics(this.font);
        StyleConstants.setFontSize(this.standard, size);
        this.doc.setParagraphAttributes(0, 0, this.standard, true);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String getExactText() {
        return this.getText();
    }

    public void revalidate() {
        super.revalidate();
        if (this.fm != null) {
            this.setSize(100, this.fm.getHeight() * 2 + 5);
        }
    }
}

