/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit.elements;

import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.elements.EdgeLabel;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Graphics;

public class Edge
extends Entity {
    public Node start;
    public Node end;
    protected float length;
    public int edgeType;
    protected Point[] b;
    protected Point[] p;
    public EdgeLabel eLabel;

    public Edge(Graph graph) {
        super(graph);
        this.label[0] = "";
        this.end = null;
        this.start = null;
        this.length = 0.0f;
        this.edgeType = 5550;
        this.type = 7771;
        this.b = new Point[2];
        this.b[0] = new Point(0.0f, 0.0f);
        this.b[1] = new Point(0.0f, 0.0f);
        this.p = new Point[2];
        this.p[0] = new Point(0.0f, 0.0f);
        this.p[1] = new Point(0.0f, 0.0f);
        this.eLabel = new EdgeLabel(graph, this);
    }

    public Edge(Graph graph, String label, Node start, Node end, Color color, int edgeType) {
        super(graph);
        this.label[0] = label;
        this.start = start;
        this.end = end;
        this.color = color;
        start.addEdgesOut(this);
        end.addEdgesIn(this);
        this.type = 7771;
        this.edgeType = edgeType;
        this.b = new Point[2];
        this.p = new Point[2];
        this.updateLength();
        this.eLabel = new EdgeLabel(graph, this);
    }

    public Edge(Graph graph, Node start, Node end) {
        super(graph);
        this.start = start;
        this.end = end;
        start.addEdgesOut(this);
        end.addEdgesIn(this);
        this.type = 7771;
        this.edgeType = 5550;
        this.b = new Point[2];
        this.p = new Point[2];
        this.updateLength();
        this.eLabel = new EdgeLabel(graph, this);
    }

    public void setLabel(String str) {
        this.label[0] = str;
    }

    public void set(String edgeLabel, Node start, Node end, Color color, int edgeType) {
        this.label[0] = edgeLabel;
        this.start = start;
        this.end = end;
        this.color = color;
        this.edgeType = edgeType;
    }

    public void draw(Graphics g, boolean moving) {
        this.drawLine(g);
        this.drawLine(g);
        if (this.edgeType != 5550) {
            this.drawArrow(g, false, this.b[0], this.b[1]);
            if (this.edgeType == 5552) {
                this.drawArrow(g, false, this.b[1], this.b[0]);
            }
        }
        if (!moving && this.isSelected && this.graph.canvas.getMode() != 2221) {
            this.drawHandle(g);
        }
    }

    public void drawPrint(Graphics g, boolean moving) {
        this.draw(g, moving);
    }

    public void drawStructure(Graphics g, boolean moving) {
        if (this.start.equals(this.end)) {
            this.drawLine2(g);
            return;
        }
        g.setColor(this.color);
        g.drawLine((int)this.start.pos.x, (int)this.start.pos.y, (int)this.end.pos.x, (int)this.end.pos.y);
        if (this.edgeType != 5550) {
            this.drawArrowStructure(g, this.b[0], this.b[1]);
            if (this.edgeType == 5552) {
                this.drawArrowStructure(g, this.b[1], this.b[0]);
            }
        }
    }

    protected void drawArrowStructure(Graphics g, Point tail, Point head) {
        float dx = (head.x - tail.x) / 2.0f;
        float dy = (head.y - tail.y) / 2.0f;
        float lineWidth = this.graph.getLineWidth() / 2 + this.xw;
        float arrowWidth = this.graph.getArrowWidth() / 2.0f + (float)this.xw;
        float arrowHeight = this.graph.getArrowHeight() / 2.0f + (float)this.xw;
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
            arrowWidth = (float)Math.ceil((double)arrowWidth * 1.4);
            arrowHeight = (float)Math.ceil((double)arrowHeight * 1.4);
        }
        if (arrowHeight > this.length) {
            return;
        }
        Point p1 = new Point(head);
        if (this.length != 0.0f && !Double.isNaN(this.length)) {
            p1.translate(-arrowHeight / this.length * dx, -arrowHeight / this.length * dy);
        }
        Point p2 = new Point(p1);
        if (this.length != 0.0f && !Double.isNaN(this.length)) {
            p1.translate(-arrowWidth / this.length * dy, arrowWidth / this.length * dx);
            p2.translate(arrowWidth / this.length * dy, -arrowWidth / this.length * dx);
        }
        int[] x = new int[]{(int)head.x, (int)p1.x, (int)p2.x};
        int[] y = new int[]{(int)head.y, (int)p1.y, (int)p2.y};
        if (this.isBold) {
            g.setColor(this.color);
        } else {
            g.setColor(Color.white);
        }
        g.fillPolygon(x, y, 3);
        g.setColor(this.color);
        g.drawPolygon(x, y, 3);
    }

    protected void drawLine(Graphics g) {
        int[] y;
        int[] x;
        Point p4;
        Point p3;
        Point p2;
        Point p1;
        float moveY;
        float moveX;
        float lineWidth;
        if (this.start.equals(this.end)) {
            this.drawLine2(g);
            return;
        }
        if (this.isHighlighted) {
            lineWidth = this.graph.getLineWidth() + this.xw + 2;
            if (this.isBold) {
                lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
            }
            moveX = lineWidth / this.length * (this.b[1].x - this.b[0].x);
            moveY = lineWidth / this.length * (this.b[1].y - this.b[0].y);
            p1 = new Point(this.b[0]);
            p2 = new Point(p1);
            p3 = new Point(this.b[1]);
            p4 = new Point(p3);
            p1.translate(-moveY, moveX);
            p2.translate(moveY, -moveX);
            p3.translate(moveY, -moveX);
            p4.translate(-moveY, moveX);
            if (this.edgeType == 5551) {
                p3.translate(-3.0f * moveX, -3.0f * moveY);
                p4.translate(-3.0f * moveX, -3.0f * moveY);
            } else if (this.edgeType == 5552) {
                p1.translate(3.0f * moveX, 3.0f * moveY);
                p2.translate(3.0f * moveX, 3.0f * moveY);
                p3.translate(-3.0f * moveX, -3.0f * moveY);
                p4.translate(-3.0f * moveX, -3.0f * moveY);
            }
            x = new int[]{(int)p1.x, (int)p2.x, (int)p3.x, (int)p4.x};
            y = new int[]{(int)p1.y, (int)p2.y, (int)p3.y, (int)p4.y};
            g.setColor(this.bkColor);
            g.fillPolygon(x, y, 4);
        }
        g.setColor(this.color);
        lineWidth = this.graph.getLineWidth() + this.xw;
        if (lineWidth == 1.0f && !this.isBold) {
            g.drawLine((int)this.start.pos.x, (int)this.start.pos.y, (int)this.end.pos.x, (int)this.end.pos.y);
            return;
        }
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
        }
        moveX = lineWidth / this.length * (this.b[1].x - this.b[0].x);
        moveY = lineWidth / this.length * (this.b[1].y - this.b[0].y);
        p1 = new Point(this.b[0]);
        p2 = new Point(p1);
        p3 = new Point(this.b[1]);
        p4 = new Point(p3);
        p1.translate(-moveY, moveX);
        p2.translate(moveY, -moveX);
        p3.translate(moveY, -moveX);
        p4.translate(-moveY, moveX);
        if (this.edgeType == 5551) {
            p3.translate(-3.0f * moveX, -3.0f * moveY);
            p4.translate(-3.0f * moveX, -3.0f * moveY);
        } else if (this.edgeType == 5552) {
            p1.translate(3.0f * moveX, 3.0f * moveY);
            p2.translate(3.0f * moveX, 3.0f * moveY);
            p3.translate(-3.0f * moveX, -3.0f * moveY);
            p4.translate(-3.0f * moveX, -3.0f * moveY);
        }
        x = new int[]{(int)p1.x, (int)p2.x, (int)p3.x, (int)p4.x};
        y = new int[]{(int)p1.y, (int)p2.y, (int)p3.y, (int)p4.y};
        g.setColor(this.color);
        g.fillPolygon(x, y, 4);
    }

    protected void drawLine2(Graphics g) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point ne = new Point(this.start.pos.x + dx, this.start.pos.y - dy);
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        int[] x = new int[4];
        int[] y = new int[4];
        x[0] = (int)this.start.pos.x;
        y[0] = (int)this.start.pos.y;
        x[1] = (int)ne.x;
        y[1] = (int)ne.y;
        x[2] = (int)nw.x;
        y[2] = (int)nw.y;
        x[3] = x[0];
        y[3] = y[0];
        g.setColor(this.color);
        g.drawPolyline(x, y, 4);
        float lineWidth = this.graph.getLineWidth() + this.xw;
        if (lineWidth == 1.0f && !this.isBold) {
            return;
        }
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
        }
        x = new int[8];
        y = new int[8];
        x[0] = (int)(this.start.pos.x + lineWidth);
        y[0] = (int)(this.start.pos.y + lineWidth);
        x[1] = (int)((double)ne.x + (double)lineWidth * 1.5);
        y[1] = (int)(ne.y - lineWidth);
        x[2] = (int)((double)nw.x - (double)lineWidth * 1.5);
        y[2] = (int)(nw.y - lineWidth);
        x[3] = (int)(this.start.pos.x - lineWidth);
        y[3] = y[0];
        x[4] = x[0];
        y[4] = y[0];
        x[5] = (int)nw.x;
        y[5] = (int)nw.y;
        x[6] = (int)ne.x;
        y[6] = (int)ne.y;
        x[7] = x[3];
        y[7] = y[3];
        g.fillPolygon(x, y, 8);
    }

    protected void drawArrow(Graphics g, boolean drawAnyways, Point tail, Point head) {
        if (this.start.equals(this.end) && !drawAnyways) {
            this.drawArrow2(g);
            return;
        }
        this.arrow(g, tail, head);
    }

    public void arrow(Graphics g, Point tail, Point head) {
        float dx = head.x - tail.x;
        float dy = head.y - tail.y;
        float lineWidth = this.graph.getLineWidth() + this.xw;
        float arrowWidth = this.graph.getArrowWidth() + (float)this.xw;
        float arrowHeight = this.graph.getArrowHeight() + (float)this.xw;
        if (this.isBold) {
            lineWidth = (float)Math.ceil((double)lineWidth * 1.4);
            arrowWidth = (float)Math.ceil((double)arrowWidth * 1.4);
            arrowHeight = (float)Math.ceil((double)arrowHeight * 1.4);
        }
        Point p1 = new Point(head);
        if (this.length != 0.0f && !Double.isNaN(this.length)) {
            p1.translate(-arrowHeight / this.length * dx, -arrowHeight / this.length * dy);
        }
        Point p2 = new Point(p1);
        if (this.length != 0.0f && !Double.isNaN(this.length)) {
            p1.translate(-arrowWidth / this.length * dy, arrowWidth / this.length * dx);
            p2.translate(arrowWidth / this.length * dy, -arrowWidth / this.length * dx);
        }
        int[] x = new int[]{(int)head.x, (int)p1.x, (int)p2.x};
        int[] y = new int[]{(int)head.y, (int)p1.y, (int)p2.y};
        if (this.isBold) {
            g.setColor(this.color);
        } else {
            g.setColor(Color.white);
        }
        g.fillPolygon(x, y, 3);
        g.setColor(this.color);
        g.drawPolygon(x, y, 3);
    }

    protected void drawArrow2(Graphics g) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        Node tmp = new Node(this.graph, "", nw, this.color, 1110);
        Point b = this.start.findBorder(tmp);
        this.length = this.distance(nw, b);
        this.drawArrow(g, true, nw, b);
    }

    public void drawHandle(Graphics g) {
        if (this.start.equals(this.end)) {
            this.drawHandle2(g);
            return;
        }
        Point first = new Point((5.0f * this.b[0].x + this.b[1].x) / 6.0f, (5.0f * this.b[0].y + this.b[1].y) / 6.0f);
        Point mid = this.middle();
        Point last = new Point((this.b[0].x + 5.0f * this.b[1].x) / 6.0f, (this.b[0].y + 5.0f * this.b[1].y) / 6.0f);
        g.setColor(Color.magenta);
        g.fillRect((int)first.x - 2, (int)first.y - 2, 5, 5);
        g.fillRect((int)last.x - 2, (int)last.y - 2, 5, 5);
        g.fillRect((int)mid.x - 2, (int)mid.y - 2, 5, 5);
    }

    public void drawHandle2(Graphics g) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point ne = new Point(this.start.pos.x + dx, this.start.pos.y - dy);
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        Point n = new Point(this.start.pos.x, this.start.pos.y - dy);
        g.setColor(Color.magenta);
        g.fillRect((int)n.x - 2, (int)n.y - 2, 5, 5);
        g.fillRect((int)ne.x - 2, (int)ne.y - 2, 5, 5);
        g.fillRect((int)nw.x - 2, (int)nw.y - 2, 5, 5);
    }

    public float distance(Point a, Point b) {
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public void updateLength() {
        this.b[0] = this.start.findBorder(this.end);
        this.b[1] = this.end.findBorder(this.start);
        this.length = this.distance(this.b[0], this.b[1]);
    }

    public void updateLengthStructure() {
        this.updateLength();
        this.length /= 2.0f;
    }

    public boolean contains(Point p) {
        return this.contains1(p, false, this.start.pos, this.end.pos);
    }

    protected boolean contains1(Point p, boolean checkAnyways, Point a, Point b) {
        if (this.start.equals(this.end) && !checkAnyways) {
            return this.contains2(p);
        }
        float dx = b.x - a.x;
        float dy = b.y - a.y;
        Point c = new Point(a.x - dy, a.y + dx);
        Point d = new Point(b.x + dy, b.y - dx);
        Point x = new Point(p.x - a.x, p.y - a.y);
        Point y = new Point(b.x - a.x, b.y - a.y);
        float projX = x.x - (x.x * y.x + x.y * y.y) / (y.x * y.x + y.y * y.y) * y.x;
        float projY = x.y - (x.x * y.x + x.y * y.y) / (y.x * y.x + y.y * y.y) * y.y;
        float distSqrd = projX * projX + projY * projY;
        return p.leftOf(a, c) < 0.0f && p.leftOf(b, d) < 0.0f && distSqrd < 100.0f;
    }

    protected boolean contains2(Point p) {
        float dx = GraphConsts.selfDx;
        float dy = this.start.height + GraphConsts.selfDy;
        Point ne = new Point(this.start.pos.x + dx, this.start.pos.y - dy);
        Point nw = new Point(this.start.pos.x - dx, this.start.pos.y - dy);
        return this.contains1(p, true, this.end.pos, ne) || this.contains1(p, true, this.end.pos, nw) || this.contains1(p, true, ne, nw);
    }

    public boolean isInRect(Point a, Point b) {
        Point c = this.start.pos;
        Point d = this.end.pos;
        return c.x > a.x && c.x < b.x && c.y > a.y && c.y < b.y && d.x > a.x && d.x < b.x && d.y > a.y && d.y < b.y;
    }

    public void translate(float dx, float dy) {
    }

    public void move(Point p) {
    }

    public void removeFromNodes() {
        this.start.removeEdgesOut(this);
        this.end.removeEdgesIn(this);
    }

    public boolean equals(Entity ent) {
        if (ent.type == 7771) {
            Edge edge = (Edge)ent;
            return this.start.equals(edge.start) && this.end.equals(edge.end);
        }
        return false;
    }

    public Point middle() {
        float mx = (this.b[0].x + this.b[1].x) / 2.0f;
        float my = (this.b[0].y + this.b[1].y) / 2.0f;
        return new Point(mx, my);
    }

    public float getDx() {
        return this.b[1].x - this.b[0].x;
    }

    public float getDy() {
        return this.b[1].y - this.b[0].y;
    }

    public float getPx() {
        return this.p[1].y - this.p[0].y;
    }

    public float getPy() {
        return this.p[1].y - this.p[0].y;
    }

    public Point[] getB() {
        return this.b;
    }

    public Point[] getP() {
        return this.p;
    }

    public float getLength() {
        return this.length;
    }

    public Node otherNode(Node n1) {
        if (this.start.equals(n1)) {
            return this.end;
        }
        return this.start;
    }

    public Node getStartNode() {
        return this.start;
    }

    public Node getEndNode() {
        return this.end;
    }

    public int getEdgeType() {
        return this.edgeType;
    }

    public String getDescription() {
        return String.valueOf(this.start.getLabel()) + "->" + this.end.getLabel();
    }

    public String toString() {
        return this.start + " -> " + this.end;
    }
}

