/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit.dialogs;

import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class DescriptionDialog
extends BasicDialog {
    private static final long serialVersionUID = 1L;
    protected GraphWindow window;
    private boolean editable;

    public DescriptionDialog(GraphWindow window, String title, boolean editable) {
        super((JFrame)window, title, true);
        super.setOKString("Save");
        this.window = window;
        this.editable = editable;
        this.setPreferredSize(new Dimension(350, 300));
        this.pack();
        this.centerWindow();
    }

    public void open() {
        this.setVisible(true);
    }

    public JPanel constructTopPanel(String sd, JEditorPane sEditorPane) {
        JPanel top = new JPanel();
        JLabel label = new JLabel("Short Description");
        label.setToolTipText("This is an short description of the problem to be included in xml under <SHORT> tag.");
        sEditorPane.setPreferredSize(new Dimension(250, 100));
        sEditorPane.setText(sd);
        if (!this.editable) {
            sEditorPane.setEnabled(false);
            sEditorPane.setDisabledTextColor(Color.BLACK);
            sEditorPane.setBackground(Color.LIGHT_GRAY);
        }
        JScrollPane scrollPane = new JScrollPane(sEditorPane);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(300, 70));
        top.add((Component)label, "North");
        top.add((Component)scrollPane, "Center");
        top.setPreferredSize(new Dimension(350, 100));
        return top;
    }

    public JPanel constructCenterPanel(String ld, JEditorPane lEditorPane) {
        JPanel center = new JPanel();
        JLabel label = new JLabel("Detailed Description");
        label.setToolTipText("This is a detailed description of the problem to be included in xml under <DETAILED> tag.");
        lEditorPane.setPreferredSize(new Dimension(250, 100));
        lEditorPane.setText(ld);
        if (!this.editable) {
            lEditorPane.setEnabled(false);
            lEditorPane.setDisabledTextColor(Color.BLACK);
            lEditorPane.setBackground(Color.LIGHT_GRAY);
        }
        JScrollPane scrollPane = new JScrollPane(lEditorPane);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        center.add((Component)label, "North");
        center.add((Component)scrollPane, "Center");
        return center;
    }

    public JPanel constructBottomPanel() {
        JPanel bottom = new JPanel();
        JButton okButton = new JButton("Save");
        okButton.setActionCommand(okButton.getText());
        okButton.addActionListener(this);
        bottom.add(okButton);
        JButton cButton = new JButton("Cancel");
        cButton.setActionCommand(cButton.getText());
        cButton.addActionListener(this);
        bottom.add(cButton);
        if (!this.editable) {
            okButton.setEnabled(false);
            okButton.setVisible(false);
        }
        return bottom;
    }

    protected String formatString(String s) {
        String formatedDesc = new String();
        int size = 44;
        if (s.length() >= size) {
            String tmp = s;
            int num = s.length() / size;
            int p2 = 0;
            while (num >= 0 && tmp.length() != 0) {
                p2 = tmp.indexOf(" ", size);
                if (tmp.length() <= size || p2 < 0) {
                    p2 = tmp.length() - 1;
                }
                formatedDesc = formatedDesc.concat(tmp.substring(0, p2).trim().concat("\n"));
                tmp = tmp.substring(p2 + 1, tmp.length()).trim();
                --num;
            }
        }
        return formatedDesc;
    }

    protected abstract boolean saveDescription();

    protected boolean actionCancel() {
        return true;
    }

    protected boolean actionOK() {
        return this.saveDescription();
    }
}

