/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.relations;

import AIspace.cspTools.dialogs.RelationDialog;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.graphToolKit.elements.Point;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ReorderDialog
extends JDialog
implements WindowListener,
ActionListener {
    private JButton upButton;
    private JButton downButton;
    private JButton okButton;
    private JList factorList;
    private DefaultListModel factorListModel;
    private RelationDialog rDialog;
    private ArrayList<CSPVariable> variables;
    private Constraint cns;

    public ReorderDialog(RelationDialog parent, Constraint cns) {
        super(parent, "Reordering Factors", true);
        this.rDialog = parent;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(4, 1));
        this.upButton = new JButton("Shift Variable Up");
        this.upButton.addActionListener(this);
        this.downButton = new JButton("Shift Variable Down");
        this.downButton.addActionListener(this);
        buttonPanel.add(new JLabel(""));
        buttonPanel.add("North", this.upButton);
        buttonPanel.add("South", this.downButton);
        buttonPanel.add(new JLabel(""));
        JPanel okButtonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        okButtonPanel.add(this.okButton);
        okButtonPanel.add(cancelButton);
        this.factorListModel = new DefaultListModel();
        this.cns = cns;
        this.variables = cns == null ? new ArrayList() : cns.getVariables();
        int i = 0;
        while (i < this.variables.size()) {
            this.factorListModel.addElement(this.variables.get(i).getName());
            ++i;
        }
        this.factorList = new JList(this.factorListModel);
        this.factorList.setSelectionMode(0);
        this.factorList.setSelectedIndex(0);
        this.getContentPane().add("East", buttonPanel);
        this.getContentPane().add("Center", this.factorList);
        this.getContentPane().add("South", okButtonPanel);
        this.getContentPane().add("North", new JLabel("      Reordering will reset relation       "));
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        int widthOffset = windowSize.width / 2;
        int heightOffset = windowSize.height / 2;
        this.setLocation((int)centerPosition.x - widthOffset, (int)centerPosition.y - heightOffset);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Shift Variable Up")) {
            this.moveListSelectUp();
        } else if (e.getActionCommand().equals("Shift Variable Down")) {
            this.moveListSelectDown();
        } else if (e.getActionCommand().equals("OK")) {
            if (this.cns != null) {
                this.cns.setVariables(this.variables);
            }
            this.rDialog.reorder();
            this.setVisible(false);
        } else if (e.getActionCommand().equals("Cancel")) {
            this.setVisible(false);
        }
    }

    public void moveListSelectUp() {
        int index = this.factorList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        String oldItem = this.factorListModel.getElementAt(index - 1).toString();
        this.factorListModel.set(index - 1, this.factorList.getSelectedValue());
        this.factorListModel.set(index, oldItem);
        this.factorList.setSelectedIndex(index - 1);
        CSPVariable v = this.variables.get(index);
        this.variables.remove(index);
        this.variables.add(index - 1, v);
    }

    public void moveListSelectDown() {
        int index = this.factorList.getSelectedIndex();
        if (index == this.factorListModel.size() - 1 || index < 0) {
            return;
        }
        String oldItem = this.factorListModel.getElementAt(index + 1).toString();
        this.factorListModel.set(index + 1, this.factorList.getSelectedValue());
        this.factorListModel.set(index, oldItem);
        this.factorList.setSelectedIndex(index + 1);
        CSPVariable v = this.variables.get(index);
        this.variables.remove(index);
        this.variables.add(index + 1, v);
    }

    public void reorderVariables() {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

