/*
 * Decompiled with CFR 0.152.
 */
package AIspace.XMLReader;

import AIspace.XMLReader.Pair;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBlock {
    private String text;
    private String tagName;
    private ArrayList<Pair> properties;
    public ArrayList<XMLBlock> childBlocks;

    public XMLBlock() {
        this.text = "";
        this.tagName = "";
        this.properties = new ArrayList();
        this.childBlocks = new ArrayList();
    }

    public XMLBlock(String t, String name, ArrayList<Pair> prop, ArrayList<XMLBlock> children) {
        this.text = t;
        this.tagName = name;
        this.properties = new ArrayList<Pair>(prop);
        this.childBlocks = new ArrayList<XMLBlock>(children);
    }

    public XMLBlock(XMLBlock original) {
        this.text = original.text;
        this.tagName = original.text;
        this.properties = new ArrayList<Pair>(original.properties);
        this.childBlocks = new ArrayList<XMLBlock>(original.childBlocks);
    }

    public String getText() {
        return this.text;
    }

    public String getTag() {
        return this.tagName;
    }

    public ArrayList<Pair> getProperties() {
        return this.properties;
    }

    public void setText(String t) {
        this.text = t;
    }

    public void setTag(String tag) {
        this.tagName = tag;
    }

    public void addProperty(String propertyName, String propertyValue) {
        Pair pair = new Pair();
        pair.name = propertyName;
        pair.value = propertyValue;
        this.properties.add(pair);
    }

    public void addChild(XMLBlock child) {
        this.childBlocks.add(child);
    }

    public boolean removeChild(String name) {
        int i = 0;
        while (i < this.childBlocks.size()) {
            if (name.equals(this.childBlocks.get((int)i).tagName)) {
                this.childBlocks.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<XMLBlock> searchChildTag(String tag) {
        ArrayList<XMLBlock> searchResults = new ArrayList<XMLBlock>();
        int i = 0;
        while (i < this.childBlocks.size()) {
            XMLBlock currBlock = this.childBlocks.get(i);
            if (currBlock.tagName.equalsIgnoreCase(tag)) {
                searchResults.add(currBlock);
            }
            ++i;
        }
        if (searchResults.size() > 0) {
            return searchResults;
        }
        return null;
    }
}

