/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint.dialogs;

import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintWindow;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class AutoSolveOptionsDialog
extends BasicDialog {
    private JScrollPane smallOrderPanel;
    private JScrollPane defaultOrderPanel;
    private JPanel customOrderPanel;
    private JPanel topPanel;
    private JPanel okCancelPanel;
    private JList customList;
    private ArrayList<CSPVariable> customVars;
    private ArrayList<CSPVariable> defaultVars;
    private JButton downButton;
    private JButton upButton;
    private JRadioButton randomSplitButton;
    private JRadioButton halfSplitButton;
    private JRadioButton customTypeButton;
    private JRadioButton defaultTypeButton;
    private JRadioButton smallestTypeButton;
    private ConstraintWindow window;
    private ConstraintCSP csp;

    public AutoSolveOptionsDialog(ConstraintWindow window, ConstraintCSP csp) {
        super((JFrame)window, "AutoSolve Options", true);
        this.window = window;
        this.csp = csp;
        this.setSize(550, 200);
        ButtonGroup varTypeGroup = new ButtonGroup();
        this.defaultTypeButton = new JRadioButton("default order");
        this.defaultTypeButton.addActionListener(this);
        this.smallestTypeButton = new JRadioButton("smallest domain");
        this.smallestTypeButton.addActionListener(this);
        this.customTypeButton = new JRadioButton("custom order");
        this.customTypeButton.addActionListener(this);
        varTypeGroup.add(this.smallestTypeButton);
        varTypeGroup.add(this.defaultTypeButton);
        varTypeGroup.add(this.customTypeButton);
        ButtonGroup domainGroup = new ButtonGroup();
        this.halfSplitButton = new JRadioButton("in half");
        this.halfSplitButton.addActionListener(this);
        this.randomSplitButton = new JRadioButton("randomly");
        this.randomSplitButton.addActionListener(this);
        domainGroup.add(this.halfSplitButton);
        domainGroup.add(this.randomSplitButton);
        this.topPanel = new JPanel(new GridLayout(2, 4));
        this.topPanel.add(new JLabel("Select Variable by:   "));
        this.topPanel.add(this.smallestTypeButton);
        this.topPanel.add(this.defaultTypeButton);
        this.topPanel.add(this.customTypeButton);
        this.topPanel.add(new JLabel("Split Domain:          "));
        this.topPanel.add(this.halfSplitButton);
        this.topPanel.add(this.randomSplitButton);
        this.topPanel.add(new JLabel());
        this.constructSmallestPanel();
        this.makeDefaultPanel();
        this.makeCustomPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.okCancelPanel = new JPanel();
        this.okCancelPanel.setLayout(new GridLayout(1, 2));
        this.okCancelPanel.add(ok);
        this.okCancelPanel.add(cancel);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.addComponent(this.topPanel, this, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.okCancelPanel, this, 5, 0, 1, 1, 1.0, 0.0);
        if (window.getSplitBy() == 1431) {
            this.smallestTypeButton.setSelected(true);
            this.addComponent(this.smallOrderPanel, this, 3, 0, 1, 2, 1.0, 1.0);
        } else if (window.getSplitBy() == 1432) {
            this.defaultTypeButton.setSelected(true);
            this.addComponent(this.okCancelPanel, this, 5, 0, 1, 1, 1.0, 0.0);
        } else {
            this.customTypeButton.setSelected(true);
            this.addComponent(this.customOrderPanel, this, 3, 0, 1, 2, 1.0, 1.0);
        }
        if (window.getSplitInHalf()) {
            this.halfSplitButton.setSelected(true);
        } else {
            this.randomSplitButton.setSelected(true);
        }
        this.centerWindow();
        this.setVisible(true);
    }

    private void constructSmallestPanel() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        ArrayList<CSPVariable> vars = this.csp.getVariables();
        int index = -1;
        int varSize = vars.size();
        int i = 0;
        while (i < varSize) {
            int dSize = 999999999;
            int j = 0;
            while (j < vars.size()) {
                CSPVariable v = vars.get(j);
                if (v.getDomain().getSize() < dSize) {
                    dSize = v.getDomain().getSize();
                    index = j;
                }
                ++j;
            }
            model.addElement(vars.get(index).getName());
            vars.remove(index);
            ++i;
        }
        JList smallList = new JList(model);
        this.smallOrderPanel = new JScrollPane(smallList, 20, 31);
    }

    private void makeDefaultPanel() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.defaultVars = this.csp.getVariables();
        CSPVariable v = null;
        int i = 0;
        while (i < this.defaultVars.size()) {
            v = this.defaultVars.get(i);
            model.addElement(v.getName());
            ++i;
        }
        JList defaultList = new JList(model);
        this.defaultOrderPanel = new JScrollPane(defaultList, 20, 31);
    }

    private void makeCustomPanel() {
        this.customOrderPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.upButton = new JButton("Shift Variable Up");
        this.upButton.addActionListener(this);
        this.downButton = new JButton("Shift Variable Down");
        this.downButton.addActionListener(this);
        buttonPanel.add("North", this.upButton);
        buttonPanel.add("South", this.downButton);
        DefaultListModel<String> customListModel = new DefaultListModel<String>();
        ArrayList<CSPVariable> customArrayList = this.window.getVariableOrder();
        this.customVars = customArrayList == null ? this.csp.getVariables() : customArrayList;
        int i = 0;
        while (i < this.customVars.size()) {
            customListModel.addElement(this.customVars.get(i).getName());
            ++i;
        }
        this.customList = new JList(customListModel);
        this.customList.setSelectionMode(0);
        JScrollPane varListScroll = new JScrollPane(this.customList, 20, 31);
        this.customOrderPanel.add("East", buttonPanel);
        this.customOrderPanel.add("Center", varListScroll);
    }

    @Override
    protected boolean actionOK() {
        if (this.smallestTypeButton.isSelected()) {
            this.window.setSplitBy(1431);
        } else if (this.defaultTypeButton.isSelected()) {
            this.window.setVariableOrder(this.defaultVars, 1432);
        } else {
            this.window.setVariableOrder(this.customVars, 1433);
        }
        if (this.halfSplitButton.isSelected()) {
            this.window.setSplitInHalf(true);
        } else if (this.randomSplitButton.isSelected()) {
            this.window.setSplitInHalf(false);
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.upButton) {
            this.moveListSelectUp();
        } else if (e.getSource() == this.downButton) {
            this.moveListSelectDown();
        } else {
            if (e.getSource() == this.smallestTypeButton) {
                this.getContentPane().remove(2);
                this.addComponent(this.smallOrderPanel, this, 3, 0, 1, 2, 1.0, 1.0);
            } else if (e.getSource() == this.defaultTypeButton) {
                this.getContentPane().remove(2);
                this.addComponent(this.defaultOrderPanel, this, 3, 0, 1, 2, 1.0, 1.0);
            } else if (e.getSource() == this.customTypeButton) {
                this.getContentPane().remove(2);
                this.addComponent(this.customOrderPanel, this, 3, 0, 1, 2, 1.0, 1.0);
            }
            this.validate();
            this.repaint();
        }
    }

    public void moveListSelectUp() {
        int index = this.customList.getSelectedIndex();
        if (index <= 0) {
            return;
        }
        DefaultListModel customListModel = (DefaultListModel)this.customList.getModel();
        String oldItem = customListModel.getElementAt(index - 1).toString();
        customListModel.set(index - 1, this.customList.getSelectedValue());
        customListModel.set(index, oldItem);
        this.customList.setSelectedIndex(index - 1);
        CSPVariable v = this.customVars.get(index);
        this.customVars.remove(index);
        this.customVars.add(index - 1, v);
    }

    public void moveListSelectDown() {
        DefaultListModel customListModel = (DefaultListModel)this.customList.getModel();
        int index = this.customList.getSelectedIndex();
        if (index == customListModel.size() - 1 || index < 0) {
            return;
        }
        String oldItem = customListModel.getElementAt(index + 1).toString();
        customListModel.set(index + 1, this.customList.getSelectedValue());
        customListModel.set(index, oldItem);
        this.customList.setSelectedIndex(index + 1);
        CSPVariable v = this.customVars.get(index);
        this.customVars.remove(index);
        this.customVars.add(index + 1, v);
    }
}

