/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint;

import AIspace.Constraint.ConstraintCanvas;
import AIspace.Constraint.ConstraintWindow;
import AIspace.Constraint.InlineCanvas;
import AIspace.Constraint.InlineConstraintApplet;
import AIspace.Constraint.elements.CnsConstraintEdge;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.util.Stack;

public class ConstraintCSP
extends CSP {
    public static final int NORMAL = 1220;
    public static final int DOMAIN_SPLIT = 1221;
    public static final int BACKTRACK = 1222;
    private Stack<ConstraintVariable> pivotNodes = new Stack();

    public ConstraintCSP(Container parent, boolean inline) {
        super(parent, inline);
    }

    public void revertVariables() {
        this.resetVariables();
    }

    @Override
    public CSPVariable newVariable(DomainDiscrete dom, CSPgraph graph, Point p) {
        return new ConstraintVariable(dom, graph, p, this.getName());
    }

    @Override
    public ConstraintEdge newConstraintEdge(Constraint constraint, Graph graph, CSPVariable variable) {
        return new CnsConstraintEdge(constraint, graph, variable);
    }

    public void backtrackOn(ConstraintVariable node, int[] allowed, int[] backtrackAllowed) {
        this.pivotNodes.push(node);
        for (CSPVariable v : this.variables) {
            ((ConstraintVariable)v).pushOldConstraint();
        }
        node.popOldConstraint();
        node.backTrack(allowed, backtrackAllowed);
        node.setLabel();
        this.varChanged(node);
        for (ConstraintEdge e : this.getConstraintEdges()) {
            ((CnsConstraintEdge)e).pushOldQueueValue();
        }
        this.saveStepInfo();
        node.setVarToSplit();
        if (!this.inline) {
            ((ConstraintWindow)this.parent).setPromptLabel("Variable " + node.getName() + " split - " + node.getName() + " in {" + node.getSplitRep() + "}" + "\nClick a variable to split its domain or press step to continue");
        }
    }

    public void backtrackOn(ConstraintVariable node, int value) {
        this.pivotNodes.push(node);
        for (CSPVariable v : this.variables) {
            ((ConstraintVariable)v).pushOldConstraint();
        }
        node.popOldConstraint();
        node.backTrack(value);
        node.setLabel();
        this.varChanged(node);
        for (ConstraintEdge e : this.getConstraintEdges()) {
            ((CnsConstraintEdge)e).pushOldQueueValue();
        }
    }

    public ConstraintVariable revertNodes() {
        for (CSPVariable v : this.variables) {
            ((ConstraintVariable)v).popOldConstraint();
            ((ConstraintVariable)v).setLabel();
        }
        for (ConstraintEdge e : this.getConstraintEdges()) {
            ((CnsConstraintEdge)e).popOldQueueValue();
        }
        this.saveStepInfo();
        ConstraintVariable tmpNode = this.pivotNodes.pop();
        tmpNode.setVarToBackTrack();
        return tmpNode;
    }

    public void saveStepInfo() {
        for (ConstraintEdge e : this.getConstraintEdges()) {
            ((CnsConstraintEdge)e).saveStepInfo();
        }
        for (CSPVariable v : this.variables) {
            ((ConstraintVariable)v).saveSplitHistory();
        }
    }

    public boolean stepBack() {
        boolean isLastStepBack = false;
        int stepType = 1220;
        ConstraintVariable var = null;
        for (CSPVariable v : this.variables) {
            var = (ConstraintVariable)v;
            if (var.getVarType() == 1221) {
                stepType = 1221;
                break;
            }
            if (var.getVarType() != 1222) continue;
            stepType = 1222;
            break;
        }
        switch (stepType) {
            case 1220: {
                for (ConstraintEdge e : this.getConstraintEdges()) {
                    if (((CnsConstraintEdge)e).isCurrArc()) {
                        if (this.inline) {
                            ((InlineConstraintApplet)this.parent).setPromptLabel("Stepped back on arc: " + ((CnsConstraintEdge)e).printString());
                        } else {
                            ((ConstraintWindow)this.parent).setPromptLabel("Stepped back on arc: " + ((CnsConstraintEdge)e).printString());
                        }
                    }
                    isLastStepBack = ((CnsConstraintEdge)e).stepback();
                }
                for (CSPVariable v : this.variables) {
                    ((ConstraintVariable)v).stepBack();
                    ((ConstraintVariable)v).setLabel();
                }
                break;
            }
            case 1221: {
                for (ConstraintEdge e : this.getConstraintEdges()) {
                    isLastStepBack = ((CnsConstraintEdge)e).stepback();
                }
                for (CSPVariable v : this.variables) {
                    ((ConstraintVariable)v).stepBack();
                    ((ConstraintVariable)v).setLabel();
                }
                ((ConstraintWindow)this.parent).setPromptLabel("Stepped back - " + var.getName() + " in {" + var.getSplitRep() + "}");
                ((ConstraintWindow)this.parent).domainHistoryIndent = var.popIndent();
                this.pivotNodes.pop();
                for (CSPVariable v : this.variables) {
                    ((ConstraintVariable)v).popOldSplits();
                }
                --((ConstraintWindow)this.parent).numSplitsOnStack;
                if (((ConstraintWindow)this.parent).numSplitsOnStack > 0) break;
                ((ConstraintWindow)this.parent).getSolveButtonAt(6).setEnabled(false);
                ((ConstraintCanvas)this.canvas).backTrackItem.setEnabled(false);
                break;
            }
            case 1222: {
                for (ConstraintEdge e : this.getConstraintEdges()) {
                    CnsConstraintEdge edge = (CnsConstraintEdge)e;
                    edge.pushOldQueueValue();
                    isLastStepBack = edge.stepback();
                }
                for (CSPVariable v : this.variables) {
                    ((ConstraintVariable)v).stepBackAndSave();
                    ((ConstraintVariable)v).setLabel();
                }
                if (this.inline) {
                    ((InlineConstraintApplet)this.parent).setPromptLabel("Stepped back - " + var.getName() + " in {" + var.getSplitRep() + "}");
                    this.pivotNodes.push(var);
                    --((InlineConstraintApplet)this.parent).domainHistoryIndent;
                    var.pushIndent(((ConstraintWindow)this.parent).domainHistoryIndent);
                    ++((InlineConstraintApplet)this.parent).numSplitsOnStack;
                    ((InlineConstraintApplet)this.parent).backtrackButton.setEnabled(true);
                    ((InlineCanvas)this.canvas).backTrackItem.setEnabled(true);
                    break;
                }
                ((ConstraintWindow)this.parent).setPromptLabel("Stepped back - " + var.getName() + " in {" + var.getSplitRep() + "}");
                this.pivotNodes.push(var);
                --((ConstraintWindow)this.parent).domainHistoryIndent;
                var.pushIndent(((ConstraintWindow)this.parent).domainHistoryIndent);
                ++((ConstraintWindow)this.parent).numSplitsOnStack;
                ((ConstraintWindow)this.parent).getSolveButtonAt(6).setEnabled(true);
                ((ConstraintCanvas)this.canvas).backTrackItem.setEnabled(true);
            }
        }
        return isLastStepBack;
    }

    public void resetNodes() {
        this.resetVariables();
        this.pivotNodes.removeAllElements();
        for (CSPVariable v : this.variables) {
            ((ConstraintVariable)v).pushOldConstraint();
            ((ConstraintVariable)v).clearSplitHistory();
            ((ConstraintVariable)v).saveSplitHistory();
            ((ConstraintVariable)v).setLabel();
            v.xw = 0;
        }
        for (ConstraintEdge e : this.getConstraintEdges()) {
            ((CnsConstraintEdge)e).clearStepHistory();
            ((CnsConstraintEdge)e).putOnQueue();
            ((CnsConstraintEdge)e).saveStepInfo();
            e.xw = 0;
        }
    }

    public boolean isQueueEmpty() {
        for (ConstraintEdge e : this.getConstraintEdges()) {
            if (!((CnsConstraintEdge)e).isOnQueue()) continue;
            return false;
        }
        return true;
    }

    public void varChanged(CSPVariable var) {
        for (Constraint c : this.getConstraints()) {
            CnsConstraintEdge newedge;
            if (!c.containsVariable(var)) continue;
            for (Edge e : c.getAllEdges()[0]) {
                newedge = (CnsConstraintEdge)e;
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.putOnQueue();
                newedge.xw = 0;
            }
            for (Edge e : c.getAllEdges()[1]) {
                newedge = (CnsConstraintEdge)e;
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.putOnQueue();
                newedge.xw = 0;
            }
        }
    }
}

