/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint;

import AIspace.Constraint.AutoAC;
import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintCanvas;
import AIspace.Constraint.ConstraintWindow;
import AIspace.Constraint.InlineConstraintApplet;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.GraphConsts;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;

public class AutoSolve
extends AutoAC {
    private Container window;

    public AutoSolve(ConstraintCanvas parent, int dt, ConstraintCSP csp) {
        super(parent, dt, csp);
        this.window = !parent.inline ? (ConstraintWindow)parent.parent : (InlineConstraintApplet)parent.parent;
    }

    @Override
    public void run() {
        this.isRunning = true;
        if (this.parent.getNextSolve() == ConstraintCanvas.FIRST_SOLVE) {
            super.run();
            if (!this.isRunning) {
                return;
            }
            int solution = this.parent.checkSolutionsforAutoSolve();
            if (solution == ConstraintCanvas.NO_MORE_SOLUTIONS) {
                this.parent.setNextSolve(ConstraintCanvas.NO_MORE_SOLUTIONS);
            } else if (solution == ConstraintCanvas.FAIL_BACKTRACK) {
                this.findSolutions(ConstraintCanvas.SOLUTION_BACKTRACK);
            } else {
                this.findSolutions(ConstraintCanvas.SPLIT);
            }
        } else if (this.parent.getNextSolve() == ConstraintCanvas.SOLUTION_BACKTRACK) {
            this.findSolutions(ConstraintCanvas.SOLUTION_BACKTRACK);
        } else if (this.parent.getNextSolve() == ConstraintCanvas.SPLIT) {
            this.findSolutions(ConstraintCanvas.SPLIT);
        } else if (this.parent.getNextSolve() == ConstraintCanvas.NO_MORE_SOLUTIONS) {
            this.findSolutions(ConstraintCanvas.NO_MORE_SOLUTIONS);
        }
        if (this.isRunning) {
            this.doneSolving();
        }
    }

    private void findSolutions(int nextStep) {
        if (!this.isRunning) {
            return;
        }
        int sol = nextStep;
        if (nextStep == ConstraintCanvas.SPLIT) {
            ConstraintVariable var = (ConstraintVariable)this.getVarToSplit();
            if (var != null) {
                this.split(var);
            }
            super.run();
            sol = this.parent.checkSolutionsforAutoSolve();
            if (sol == ConstraintCanvas.SOLUTION_BACKTRACK) {
                this.parent.setNextSolve(ConstraintCanvas.SOLUTION_BACKTRACK);
                return;
            }
        }
        if (sol == ConstraintCanvas.NO_MORE_SOLUTIONS) {
            this.parent.setNextSolve(ConstraintCanvas.NO_MORE_SOLUTIONS);
            return;
        }
        if (sol == ConstraintCanvas.SPLIT) {
            this.findSolutions(ConstraintCanvas.SPLIT);
        } else if (sol == ConstraintCanvas.SOLUTION_BACKTRACK || sol == ConstraintCanvas.FAIL_BACKTRACK) {
            while (sol != ConstraintCanvas.SPLIT) {
                this.backtrack();
                super.run();
                sol = this.parent.checkSolutionsforAutoSolve();
                if (sol == ConstraintCanvas.NO_MORE_SOLUTIONS) {
                    this.parent.setNextSolve(ConstraintCanvas.NO_MORE_SOLUTIONS);
                    return;
                }
                if (sol == ConstraintCanvas.FAIL_NO_MORE_SOLUTIONS) {
                    this.parent.setNextSolve(ConstraintCanvas.FAIL_NO_MORE_SOLUTIONS);
                    return;
                }
                if (sol != ConstraintCanvas.SOLUTION_BACKTRACK) continue;
                this.parent.setNextSolve(ConstraintCanvas.SOLUTION_BACKTRACK);
                return;
            }
            this.findSolutions(ConstraintCanvas.SPLIT);
        }
    }

    public void split(ConstraintVariable var) {
        DomainDiscrete domain = var.getDomain();
        int[] split = domain.getSplitElements();
        ArrayList<Integer> allowList = new ArrayList<Integer>();
        ArrayList<Integer> backtrackList = new ArrayList<Integer>();
        if (!(this.window instanceof ConstraintWindow) || ((ConstraintWindow)this.window).getSplitInHalf()) {
            int i = 0;
            i = 0;
            while (i < split.length / 2) {
                allowList.add(new Integer(split[i]));
                ++i;
            }
            int j = i;
            while (j < split.length) {
                backtrackList.add(new Integer(split[j]));
                ++j;
            }
        } else {
            int numToPick;
            while ((numToPick = (int)(Math.random() * (double)split.length)) == 0 || numToPick == split.length) {
            }
            while (numToPick > 0) {
                Integer item = new Integer(split[(int)(Math.random() * (double)split.length)]);
                if (allowList.contains(item)) continue;
                allowList.add(item);
                --numToPick;
            }
            int j = 0;
            while (j < split.length) {
                if (!allowList.contains(new Integer(split[j]))) {
                    backtrackList.add(new Integer(split[j]));
                }
                ++j;
            }
        }
        int[] allowed = new int[allowList.size()];
        int[] backtrackAllowed = new int[backtrackList.size()];
        int k = 0;
        while (k < allowed.length) {
            allowed[k] = (Integer)allowList.get(k);
            ++k;
        }
        k = 0;
        while (k < backtrackAllowed.length) {
            backtrackAllowed[k] = (Integer)backtrackList.get(k);
            ++k;
        }
        this.csp.backtrackOn(var, allowed, backtrackAllowed);
        if (this.parent.inline) {
            ((InlineConstraintApplet)this.window).domainSplittingOccurred(var);
        } else {
            ((ConstraintWindow)this.window).domainSplittingOccurred(var);
        }
    }

    protected void backtrack() {
        if (this.parent.inline) {
            ConstraintVariable v = this.parent.backtrack();
            ((InlineConstraintApplet)this.parent.parent).backtrackingOccurred(v, false);
            int indent = v.popIndent();
            ((InlineConstraintApplet)this.window).setIndent(indent);
            ((InlineConstraintApplet)this.window).ta.append("\n");
            int i = 0;
            while (i < indent) {
                ((InlineConstraintApplet)this.window).ta.append("    ");
                ++i;
            }
            ((InlineConstraintApplet)this.window).ta.append(v.getSplittingString());
            ((InlineConstraintApplet)this.window).setIndent(++indent);
        } else {
            ConstraintVariable v = this.parent.backtrack();
            ((ConstraintWindow)this.parent.parent).backtrackingOccurred(v, false);
            int indent = v.popIndent();
            ((ConstraintWindow)this.window).setIndent(indent);
            ((ConstraintWindow)this.window).textArea.append("\n");
            int i = 0;
            while (i < indent) {
                ((ConstraintWindow)this.window).textArea.append("    ");
                ++i;
            }
            ((ConstraintWindow)this.window).textArea.append(v.getSplittingString());
            ((ConstraintWindow)this.window).setIndent(++indent);
        }
    }

    protected CSPVariable getVarToSplit() {
        if (!(this.window instanceof ConstraintWindow) || ((ConstraintWindow)this.window).getSplitBy() == 1431) {
            Iterator<CSPVariable> itr = this.csp.getVariables().iterator();
            ConstraintVariable minVar = null;
            DomainDiscrete minDomain = null;
            boolean foundOne = false;
            while (itr.hasNext()) {
                minVar = (ConstraintVariable)itr.next();
                minDomain = minVar.getDomain();
                if (minDomain.getSplitElements().length <= 1) continue;
                foundOne = true;
                break;
            }
            if (!foundOne) {
                return null;
            }
            int[] minSplit = minDomain.getSplitElements();
            int minDomainSize = minSplit.length;
            while (itr.hasNext()) {
                ConstraintVariable v = (ConstraintVariable)itr.next();
                DomainDiscrete domain = v.getDomain();
                int[] split = domain.getSplitElements();
                if (split.length <= 1 || split.length >= minDomainSize) continue;
                minDomainSize = split.length;
                minVar = v;
            }
            return minVar;
        }
        ConstraintVariable returnVariable = (ConstraintVariable)((ConstraintWindow)this.window).getVariableOrder().get(0);
        for (CSPVariable c : ((ConstraintWindow)this.window).getVariableOrder()) {
            ConstraintVariable v = (ConstraintVariable)c;
            DomainDiscrete domain = v.getDomain();
            if (domain.getSplitElements().length <= 1) continue;
            returnVariable = v;
            break;
        }
        return returnVariable;
    }

    @Override
    protected void doneAC() {
    }

    protected void doneSolving() {
        this.parent.setCursor(GraphConsts.DEFAULT_CURSOR);
        this.parent.doneAutoSolve();
    }
}

