%% Laboratorio di Intelligent Systems
%% 17/10/2017
%% 
%% Davide Lanti

%% Esercizio 1: Algebra dei termini di Peano

% Somma Peano X+Y = Z

sum(X,0,X).                       /* X + 0 = X */
sum(X,s(Y),s(Z)) :- sum(X,Y,Z).   /* X + Y = Z => X + (Y + 1) = Z + 1 */

% Differenza X-Y = Z

diff(X,Y,Z) :- sum(Z,Y,X).
diff(X,Y,Z) :- sum(Z,Y,X). /* Z + Y = X, ossia, Z = X - Y*/ 

% Moltiplicazione

mul(0,_,0).
mul(s(X),Y,Z) :- mul(X,Y,Temp), sum(Y,Temp,Z).

%% Esercizio 2: Liste

membro(X,[X|_]).
membro(X,[_|R]) :- membro(X,R).

% Enumera tutti gli elementi di una lista

enumera(L,X) :- membro(X,L).

% Append di due liste

append([],L,L).
append([X|R],L,[X|Rest]) :- append(R,L,Rest).

% Enumera tutte le possibili coppie di liste L1, L2 per cui la append di L1, L2 da come risultato L.

all_appends(L1,L2,L) :- append(L1,L2,L).

/* 
   ?- all_appends(L1,L2,[1,2,3]).
   L1 = [],
   L2 = [1, 2, 3] ;
   L1 = [1],
   L2 = [2, 3] ;
   L1 = [1, 2],
   L2 = [3] ;
   L1 = [1, 2, 3],
   L2 = [] ;
   false.
*/

%% Esercizio 3: bagof/setof/findall

foo(a, b, c). 
foo(a, b, d). 
foo(b, c, e). 
foo(b, c, f). 
foo(c, c, g). 
foo(c, d, g).

/*  
   ?- bagof(C,foo(A,B,C),Cs).
   A = a,
   B = b,
   Cs = [c, d] ;
   A = b,
   B = c,
   Cs = [e, f] ;
   A = B, B = c,
   Cs = [g] ;
   A = c,
   B = d,
   Cs = [g].

   ?- bagof(C,B^foo(A,B,C),Cs).
   A = a,
   Cs = [c, d] ;
   A = b,
   Cs = [e, f] ;
   A = c,
   Cs = [g, g].

   ?- setof(C,B^foo(A,B,C),Cs).
   A = a,
   Cs = [c, d] ;
   A = b,
   Cs = [e, f] ;
   A = c,
   Cs = [g].

   ?- bagof(C,A^B^foo(A,B,C),Cs).
   Cs = [c, d, e, f, g, g].

   ?- findall(C,foo(A,B,C),Cs).
   Cs = [c, d, e, f, g, g].

*/

% all_appends(L1,L2,L,Results) enumera tutte le possibili coppie di liste L1, L2 per cui la append di L1, L2 da come risultato L. Il risultato
%                              viene salvato nella variabile Results.

all_appends(L1,L2,L,Results) :- findall([L1,L2],append(L1,L2,L),Results).

%% Esercizio 4

a(1).
b(X) :- a(X).

/*
a(1).
b(X) :­ a(X).
?- assert(a(2)). %% Aggiungi il predicato a(2) alla base di conoscenza.
a(1). 
a(2). %% Nuovo predicato
b(X) :­ a(X).
?­ asserta(a(3)). %% Aggiungi il predicato a(3) all'INIZIO della base di conoscenza. 
a(3). %% Nuovo predicato
a(1).
a(2).
b(X) :­ a(X).
?- assertz(a(4)). %% Aggiungi il predicato a(4) alla FINE della base di conoscenza.
a(3).
a(1).
a(2).
a(4). %% Nuovo predicato
b(X) :­ a(X).
?- restract(a(3)) %% Rimuovi il predicato a(3) dalla base di conoscenza.
a(1).
a(2).
a(4).
b(X) :­ a(X).

*/
