import java.util.*;

public class RandomData {

    private Random rn = new Random();

    private String[] months = {"JAN","FEB","MAR","APR","MAY","JUN",
		               "JUL","AUG","SEP","OCT","NOV","DEC"};

                             

    private int[] lengthOfMonth = {31,28,31,30,31,30,31,31,30,31,30,31};

    public int randomInt(int lo, int hi)
    {
	int n = hi - lo + 1;
	int i = rn.nextInt() % n;
	if (i < 0)
	    i = -i;
	return lo + i;
    }

    public String randomString(int lo, int hi)
    // Assumes that strings have at least length 1
    {
	int n = randomInt(lo, hi);
	byte b[] = new byte[n];
	b[0] = (byte)randomInt('A', 'Z');
	for (int i = 1; i < n; i++)
	    b[i] = (byte)randomInt('a', 'z');
	// return new String(b, 0); // deprecated method
	return new String(b);
    }

    public String randomDate(int loYear, int hiYear)
    {
	int randomMonthNo = randomInt(1,12);
	int randomDay = randomInt(1,lengthOfMonth[randomMonthNo-1]);
	String randomMonth = months[randomMonthNo-1];
	int randomYear = randomInt(loYear, hiYear);

	String rDate = "'" + 
                       Integer.toString(randomDay) + ' ' +
	               randomMonth + ' ' +
                       randomYear + "'";
	return rDate;
    }

}

