/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.search;

import AIspace.hill.Updateable;
import AIspace.hill.search.Heuristics;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class NeighbourPanel
extends JPanel
implements Updateable {
    private Heuristics heuristics;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private JRadioButton varFirst;
    private JRadioButton varVal;
    private ButtonGroup group;

    public NeighbourPanel(Heuristics heuristics, ItemListener l) {
        this.heuristics = heuristics;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.setLayout(this.gbl);
        this.group = new ButtonGroup();
        this.varFirst = new JRadioButton("2 stage (Choose Variable First)", heuristics.getVarFirst());
        this.group.add(this.varFirst);
        this.varVal = new JRadioButton("1 stage (Choose Variable and Value together)", !heuristics.getVarFirst());
        this.group.add(this.varVal);
        this.addComponent(this.varVal, this, 2, 0, 3, 1, 0.0, 0.0);
        this.addComponent(this.varFirst, this, 3, 0, 3, 1, 0.0, 0.0);
        if (l != null) {
            this.varFirst.addItemListener(l);
            this.varVal.addItemListener(l);
        }
    }

    private void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    @Override
    public void update() {
        this.heuristics.setVarFirst(this.varFirst.isSelected());
    }

    public boolean getState() {
        return this.varFirst.isSelected();
    }
}

