/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.dialogs;

import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.dialogs.BasicFrame;
import AIspace.graphToolKit.elements.Point;
import AIspace.hill.HillCSP;
import AIspace.hill.HillEngine;
import AIspace.hill.HillWindow;
import AIspace.hill.InlineHillApplet;
import AIspace.hill.elements.HillVariable;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TraceFrame
extends BasicFrame {
    private static final int SPACES = 7;
    protected JList display;
    protected ArrayList<int[]> trace;
    protected int numVariables;
    protected String[] titles;
    protected int numElementsInTrace;
    protected Container parent;
    protected HillEngine engine;
    public boolean valid;

    public TraceFrame(Container window, HillEngine engine) {
        super("Trace");
        super.setCancelString("Close");
        this.parent = window;
        this.engine = engine;
        java.awt.Point point = window.getLocation();
        Dimension d = window.getSize();
        point.setLocation(point.x + d.width, point.y + d.height - 420);
        this.getContentPane().setLayout(new BorderLayout());
        DefaultListModel model = new DefaultListModel();
        this.display = new JList(model);
        Font font = engine.canvas.inline ? new Font("Monospaced", 0, ((InlineHillApplet)this.parent).returnCanvas().getFont().getSize()) : new Font("Monospaced", 0, ((HillWindow)this.parent).returnCanvas().getFont().getSize());
        this.display.setFont(font);
        this.getContentPane().add("Center", new JScrollPane(this.display, 22, 30));
        this.valid = false;
        JPanel p = new JPanel();
        JButton buttonHide = new JButton("Close");
        JButton buttonBack = new JButton("Step Back");
        buttonBack.setToolTipText("Steps back through the trace.");
        JButton buttonStep = new JButton("Step Forward");
        buttonStep.setToolTipText("Steps forward through the algorithm.");
        JButton buttonSet = new JButton("Set CSP");
        buttonSet.setToolTipText("Sets the CSP back to the selected configuration.\tSelect a row first.");
        buttonHide.addActionListener(this);
        buttonStep.addActionListener(this);
        buttonBack.addActionListener(this);
        buttonSet.addActionListener(this);
        p.add(buttonHide);
        p.add(buttonStep);
        p.add(buttonBack);
        p.add(buttonSet);
        this.getContentPane().add("South", p);
        this.setSize(400, 420);
        super.ensureOnScreen(new Point(point.x, point.y));
        this.validate();
    }

    public void addAssig(HillCSP csp) {
        if (!this.valid) {
            this.init(csp);
            return;
        }
        int[] vals = new int[this.numVariables + 2];
        int i = 0;
        for (CSPVariable v : csp.getVariables()) {
            vals[i++] = ((HillVariable)v).getCurrIndex();
        }
        vals[this.numVariables + 1] = this.engine.getSteps();
        this.trace.add(vals);
        ++this.numElementsInTrace;
        this.setDisplay();
    }

    public boolean setCSP(HillCSP csp, int assig) {
        if (assig > this.numElementsInTrace || assig < 0 || csp.numVariables() != this.numVariables) {
            return false;
        }
        csp.preInitNodes();
        int[] assignment = this.trace.get(assig);
        int i = 0;
        for (CSPVariable v : csp.getVariables()) {
            ((HillVariable)v).setCurrIndex(assignment[i++]);
        }
        int oldLength = this.trace.size();
        DefaultListModel model = (DefaultListModel)this.display.getModel();
        int j = oldLength - 1;
        while (j > assig) {
            this.trace.remove(j);
            model.remove(j + 1);
            --j;
        }
        this.numElementsInTrace = assig + 1;
        this.engine.setSteps(assignment[this.numVariables + 1]);
        csp.resetLabels();
        csp.checkNodeColors();
        return true;
    }

    public void init(HillCSP csp) {
        this.valid = true;
        this.numElementsInTrace = 0;
        this.trace = new ArrayList();
        this.numVariables = csp.numVariables();
        ((DefaultListModel)this.display.getModel()).removeAllElements();
        this.titles = new String[this.numVariables];
        int i = 0;
        for (CSPVariable v : csp.getVariables()) {
            this.titles[i++] = ((HillVariable)v).getName();
        }
        this.addAssig(csp);
    }

    public JList getDisplay() {
        return this.display;
    }

    public void open(boolean bool) {
        this.setVisible(bool);
    }

    private void setDisplay() {
        int i;
        DefaultListModel model = (DefaultListModel)this.display.getModel();
        if (this.numElementsInTrace <= 1) {
            StringBuffer str = new StringBuffer();
            str.append("  ");
            i = 0;
            while (i < this.numVariables) {
                str.append(this.buf(this.titles[i], 7));
                ++i;
            }
            model.addElement("step \t" + str.toString() + "Conflicts");
        }
        int[] curr = this.trace.get(this.trace.size() - 1);
        i = 0;
        StringBuffer g = new StringBuffer();
        for (CSPVariable v : this.engine.getCSP().getVariables()) {
            g.append(this.buf(v.getDomain().getElementString(curr[i++]), 7));
        }
        model.addElement(String.valueOf(this.buf(String.valueOf(this.engine.getSteps()), 7)) + g.toString() + "\t\t" + this.engine.getCSP().numRedEdges);
        this.validate();
    }

    private String buf(String s, int spaces) {
        if (s.length() > spaces - 1) {
            return String.valueOf(s.substring(0, spaces - 2)) + "\t";
        }
        int k = s.length();
        int i = 0;
        while (i < spaces - k) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        return s;
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg == "Step Forward") {
            if (this.engine.canvas.inline) {
                ((InlineHillApplet)this.parent).step();
            } else {
                ((HillWindow)this.parent).step();
            }
        } else if (arg == "Step Back") {
            int stepnum = this.numElementsInTrace - 2;
            if (stepnum >= 0) {
                this.setCSP(this.engine.getCSP(), stepnum);
                this.display.setSelectedIndex(stepnum + 1);
                if (this.engine.canvas.inline) {
                    ((InlineHillApplet)this.parent).setPromptLabel("Stepped Back to step " + stepnum);
                } else {
                    ((HillWindow)this.parent).setPromptLabel("Stepped Back to step " + stepnum);
                }
            }
        } else if (arg == "Set CSP") {
            int stepnum = this.display.getSelectedIndex() - 1;
            if (stepnum >= 0) {
                this.setCSP(this.engine.getCSP(), this.display.getSelectedIndex() - 1);
                if (this.engine.canvas.inline) {
                    ((InlineHillApplet)this.parent).setPromptLabel("Stepped Back to step " + stepnum);
                } else {
                    ((HillWindow)this.parent).setPromptLabel("Stepped Back to step " + stepnum);
                }
            }
        } else {
            super.actionPerformed(e);
        }
    }
}

