/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.hill.batch.BatchStep;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StatsDialog
extends BasicDialog
implements ItemListener,
ChangeListener {
    private ArrayList<BatchStep> steps;
    private ButtonGroup runGroup;
    private JRadioButton[] runBox;
    private JButton closeButton;
    private JPanel center;
    private JPanel west;
    private JPanel closePanel;
    private boolean viewStats;
    private JTabbedPane tabs;
    private JScrollPane westSPane;

    public StatsDialog(JFrame parent, ArrayList<BatchStep> steps, int select) {
        super(parent, "Statistics and Settings", false);
        super.setCancelString("Close");
        if (steps.size() == 0) {
            return;
        }
        this.steps = steps;
        this.closePanel = new JPanel();
        this.closeButton = new JButton("Close");
        this.closePanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.west = this.makeWestPanel(select);
        this.westSPane = new JScrollPane(this.west, 20, 30);
        this.makeCenterPanel();
        this.viewStats = true;
        this.getContentPane().add((Component)this.westSPane, "West");
        this.getContentPane().add((Component)this.center, "Center");
        this.getContentPane().add((Component)this.closePanel, "South");
        this.pack();
        this.setSize(500, 400);
        this.setVisible(true);
        this.setResizable(true);
    }

    public void reset(ArrayList<BatchStep> steps, int select) {
        this.steps = steps;
        this.west = this.makeWestPanel(select);
        this.westSPane = new JScrollPane(this.west, 20, 30);
        this.center.removeAll();
        this.makeInnerPanel();
        this.center.add((Component)this.tabs, "Center");
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.westSPane, "West");
        this.getContentPane().add((Component)this.center, "Center");
        this.getContentPane().add((Component)this.closePanel, "South");
        this.validate();
        this.setVisible(true);
    }

    private JPanel makeWestPanel(int select) {
        JPanel panel = new JPanel();
        int size = this.steps.size();
        this.runGroup = new ButtonGroup();
        this.runBox = new JRadioButton[size];
        GridLayout grid = new GridLayout(size + 3, 1);
        panel.setLayout(grid);
        int i = 0;
        while (i < size) {
            this.runBox[i] = new JRadioButton("Plot #" + i, false);
            this.runGroup.add(this.runBox[i]);
            panel.add(this.runBox[i]);
            this.runBox[i].addActionListener(this);
            ++i;
        }
        this.runBox[select].setSelected(true);
        panel.setPreferredSize(new Dimension(100, 300));
        return panel;
    }

    private void makeCenterPanel() {
        this.center = new JPanel();
        this.center.setLayout(new BorderLayout());
        this.makeInnerPanel();
        this.center.add((Component)this.tabs, "Center");
    }

    private void makeInnerPanel() {
        JRadioButton current = null;
        Enumeration<AbstractButton> enumer = this.runGroup.getElements();
        while (enumer.hasMoreElements()) {
            JRadioButton b = (JRadioButton)enumer.nextElement();
            if (!b.isSelected()) continue;
            current = b;
        }
        this.tabs = new JTabbedPane();
        this.tabs.addChangeListener(this);
        String label = current.getText();
        int index = -1;
        try {
            index = Integer.parseInt(label.substring(label.indexOf("#") + 1));
        }
        catch (Exception e) {
            System.out.println("ErrShouldBeInteger");
        }
        this.tabs.addTab("Statistics", this.steps.get(index).getStatPanel(label));
        this.tabs.addTab("Settings", this.steps.get(index).getSettingsPanel(label));
        this.tabs.setSelectedIndex(0);
    }

    private void resetStat(boolean stats) {
        if (this.tabs != null) {
            if (stats) {
                this.tabs.setSelectedIndex(0);
            } else {
                this.tabs.setSelectedIndex(1);
            }
        }
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!e.getActionCommand().equals("Close")) {
            this.center.removeAll();
            this.makeInnerPanel();
            this.center.add((Component)this.tabs, "Center");
            this.validate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabs.getSelectedIndex() == 0) {
            this.viewStats = true;
        } else if (this.tabs.getSelectedIndex() == 1) {
            this.viewStats = false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.resetStat(this.viewStats);
    }
}

