/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.batch;

import AIspace.hill.PlotCanvas;
import AIspace.hill.batch.BatchPanel;
import AIspace.hill.batch.BatchStep;
import AIspace.hill.intList.IntVector;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.JFrame;

public class BatchCanvas
extends PlotCanvas {
    private BatchPanel panel;
    private boolean isCompleted;
    private ArrayList<BatchStep> steps;
    private int selected;

    public BatchCanvas(BatchPanel panel) {
        this.panel = panel;
        this.initCanvas();
        this.drawingBatch = true;
        this.drawSteps = true;
        this.selected = -1;
    }

    public ArrayList<BatchStep> getSteps() {
        return this.steps;
    }

    public void switchDrawSteps() {
        this.drawSteps = true;
        this.redraw(this.steps, this.isCompleted);
        this.resetSteps();
        this.redrawCoords();
    }

    public void switchDrawTimes() {
        this.drawSteps = false;
        this.redraw(this.steps, this.isCompleted);
        this.resetSteps();
        this.redrawCoords();
    }

    public void highlight(int n) {
        this.selected = n;
        this.redraw(this.steps, this.isCompleted);
    }

    public void redraw(ArrayList<BatchStep> steps, boolean completed) {
        this.steps = steps;
        this.drawingBatch = true;
        this.isCompleted = completed;
        this.maxX = 0;
        this.maxY = 0;
        if (steps == null) {
            this.maxX = 100;
            this.maxY = 100;
        } else {
            int i = 0;
            while (i < steps.size()) {
                BatchStep step = steps.get(i);
                int max = completed ? this.panel.getMaxSteps() : step.getSuccesses();
                IntVector curr = this.drawSteps ? step.getSteps() : step.getTimes();
                int tmpX = step.getSuccesses() - 1 > 0 ? curr.get(step.getSuccesses() - 1) : (max > 0 ? curr.get(max - 1) : 1);
                int tmpY = max;
                if (tmpX > this.maxX) {
                    this.maxX = tmpX;
                }
                if (tmpY > this.maxY) {
                    this.maxY = tmpY;
                }
                ++i;
            }
        }
        this.xStep = (float)this.width / (float)this.maxX;
        this.resetSteps();
        this.repaint();
    }

    public void paint(ArrayList<BatchStep> steps, boolean completed) {
        this.steps = steps;
        this.drawingBatch = true;
        if (!this.isCompleted && completed) {
            this.redraw(steps, completed);
            return;
        }
        this.isCompleted = completed;
        IntVector last = null;
        try {
            last = steps.get(steps.size() - 1).getSteps();
        }
        catch (NoSuchElementException nse) {
            this.resetSteps();
            this.repaint();
            return;
        }
        int tmp = last.last();
        if (tmp > this.maxX) {
            this.maxX = tmp;
        }
        if (this.maxX == -1) {
            this.maxX = 1;
        }
        this.xStep = (float)this.width / (float)this.maxX;
        tmp = last.size() - 1;
        if (tmp > this.maxY) {
            this.maxY = tmp;
        }
        this.resetSteps();
        this.repaint();
    }

    @Override
    public String title() {
        return "Runtime Distribution";
    }

    protected void drawBars(Graphics graphics, IntVector vector, Color color) {
        if (this.maxY == 0) {
            return;
        }
        graphics.setColor(color);
        int x = vector.first();
        float y = 0.0f;
        int xStart = 51;
        int yStart = this.getHeight() - 50;
        int h = this.height / this.maxY;
        if (h > 5) {
            h = 5;
        } else if (h < 1) {
            h = 1;
        }
        while (x != -1) {
            if (this.useLogScale) {
                if (x != 0) {
                    x = (int)(Math.log(x) / Math.log(this.maxX) * (double)this.width);
                }
            } else {
                x = (int)((float)x * this.xStep);
            }
            graphics.fillRect(xStart, yStart - (int)y - h, x, h);
            y += this.yStep;
            x = vector.next();
        }
    }

    protected void drawSorted(Graphics graphics, IntVector vector, Color color, boolean wd, int size) {
        graphics.setColor(color);
        int x = vector.first();
        float y = 0.0f;
        int xStart = 50;
        int yStart = this.getHeight() - 50;
        float graphYStep = (float)this.height / (float)(this.maxY - 1);
        int[] xCoords = new int[size];
        int[] yCoords = new int[size];
        int i = 0;
        while (i < size) {
            if (this.useLogScale) {
                if (x != 0) {
                    x = (int)(Math.log(x) / Math.log(this.maxX) * (double)this.width);
                }
            } else {
                x = (int)((float)x * this.xStep);
            }
            xCoords[i] = xStart + x;
            yCoords[i] = yStart - (int)y;
            y += graphYStep;
            x = vector.next();
            ++i;
        }
        this.drawLine(graphics, wd, xCoords, yCoords, size);
    }

    @Override
    public void clear(int numEdges) {
        this.steps = null;
        this.redraw(this.steps, false);
    }

    protected void drawLabels(Graphics graphics) {
        String title = this.title();
        String xName = this.drawSteps ? "Step Count" : "Time (ms)";
        String yName = "Red Edges";
        if (this.drawingBatch) {
            yName = "Successes";
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.getFont());
        graphics.drawString(title, this.getWidth() / 2 - this.fm.stringWidth(title) / 2, 25);
        graphics.drawString(xName, this.getWidth() / 2 - this.fm.stringWidth(xName) / 2, this.getHeight() - 15);
        if (25 + this.fm.stringWidth(yName) < 0) {
            return;
        }
        int fontSize = this.getFont().getSize();
        int y = this.getHeight() / 2 - this.fm.getHeight() / 2;
        int i = 0;
        while (i < yName.length()) {
            graphics.drawString(String.valueOf(yName.charAt(i)), 15, y + (i - yName.length() / 2) * fontSize);
            ++i;
        }
    }

    protected void drawEverything(Graphics2D g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawGrid(g);
        if (this.steps != null && !this.steps.isEmpty()) {
            IntVector subject = this.drawSteps ? this.steps.get(this.steps.size() - 1).getSteps() : this.steps.get(this.steps.size() - 1).getTimes();
            if (this.isCompleted) {
                BatchStep step = this.steps.get(this.steps.size() - 1);
                this.drawSorted(g, subject, step.color, false, step.getSuccesses());
            } else {
                this.drawBars(g, subject, this.steps.get((int)(this.steps.size() - 1)).color);
            }
            int i = 0;
            while (i < this.steps.size() - 1) {
                BatchStep step = this.steps.get(i);
                subject = this.drawSteps ? step.getSteps() : step.getTimes();
                if (this.selected != i) {
                    this.drawSorted(g, subject, step.color, false, step.getSuccesses());
                }
                ++i;
            }
            if (this.selected >= 0) {
                BatchStep step = this.steps.get(this.selected);
                subject = this.drawSteps ? step.getSteps() : step.getTimes();
                this.drawSorted(g, subject, step.color, true, step.getSuccesses());
            }
        }
        this.drawLabels(g);
        if (this.mouseX > 50 && this.mouseX < this.getWidth() - 20 && this.mouseY > 50 && this.mouseY < this.getHeight() - 50) {
            g.setColor(Color.white);
            g.fillRect(this.mouseX + 10, this.mouseY - this.fm.getAscent(), this.fm.stringWidth(this.coords), this.fm.getHeight());
            g.setColor(Color.black);
            g.drawString(this.coords, this.mouseX + 10, this.mouseY);
            g.drawLine(this.mouseX - 5, this.mouseY - 5, this.mouseX + 5, this.mouseY + 5);
            g.drawLine(this.mouseX - 5, this.mouseY + 5, this.mouseX + 5, this.mouseY - 5);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.drawEverything((Graphics2D)g);
    }

    private void drawLine(Graphics graphics, boolean thick, int[] xCoords, int[] yCoords, int size) {
        graphics.drawPolyline(xCoords, yCoords, size);
        if (thick) {
            Graphics2D g2 = (Graphics2D)graphics;
            AffineTransform saveAffine = g2.getTransform();
            AffineTransform transform = new AffineTransform();
            transform.translate(0.0, 1.0);
            g2.transform(transform);
            graphics.drawPolyline(xCoords, yCoords, size);
            transform.translate(0.0, -2.0);
            g2.transform(transform);
            graphics.drawPolyline(xCoords, yCoords, size);
            g2.transform(saveAffine);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.testCoords(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    public void print(JFrame parent) {
        PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(parent, "Print", null);
        if (pj == null) {
            System.out.println("The print request was cancelled");
            return;
        }
        Graphics g = pj.getGraphics();
        Image im = this.createImage(this.width + 50 + 20, this.height + 50 + 50);
        Graphics graphics = im.getGraphics();
        this.drawEverything((Graphics2D)graphics);
        g.drawImage(im, 0, 0, this);
        g.dispose();
        pj.end();
    }
}

