/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.IO;
import AIspace.cspTools.dialogs.CSPTextFrame;
import AIspace.hill.HillCanvas;
import AIspace.hill.InlineHillApplet;
import AIspace.hill.dialogs.BatchDialog;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class InlineCanvas
extends HillCanvas {
    private static final long serialVersionUID = 1L;
    protected JMenuItem algorithmOptions;
    protected JMenuItem batchRunOptions;

    public InlineCanvas(Container parent, CSP csp) {
        super(parent, true, csp);
        this.setSize(parent.getSize());
        this.WIDTH = this.getSize().width;
        this.HEIGHT = this.getSize().height;
        this.mode = 2221;
        this.submode = 351;
        this.graph = new CSPgraph(csp, this);
    }

    public void initializePopup() {
        this.initialize = new JMenuItem("Initialize");
        this.initialize.setActionCommand(this.initialize.getText());
        this.initialize.addActionListener(this);
        this.finestep = new JMenuItem("Fine Step");
        this.finestep.setActionCommand(this.finestep.getText());
        this.finestep.addActionListener(this);
        this.finestep.setEnabled(false);
        this.step = new JMenuItem("Step");
        this.step.setActionCommand(this.step.getText());
        this.step.addActionListener(this);
        this.step.setEnabled(false);
        this.auto = new JMenuItem("AutoSolve");
        this.auto.setActionCommand(this.auto.getText());
        this.auto.addActionListener(this);
        this.auto.setEnabled(false);
        this.batch = new JMenuItem("Batch Run");
        this.batch.setActionCommand(this.batch.getText());
        this.batch.addActionListener(this);
        this.stop = new JMenuItem("Stop");
        this.stop.setActionCommand(this.stop.getText());
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        this.showPlot = new JMenuItem("Show Plot");
        this.showPlot.setActionCommand(this.showPlot.getText());
        this.showPlot.addActionListener(this);
        this.showTrace = new JMenuItem("Show Trace");
        this.showTrace.setActionCommand(this.showTrace.getText());
        this.showTrace.addActionListener(this);
        this.algorithmOptions = new JMenuItem("Algorithm Options");
        this.algorithmOptions.setActionCommand(this.algorithmOptions.getText());
        this.algorithmOptions.addActionListener(this);
        this.batchRunOptions = new JMenuItem("Batch Run Options");
        this.batchRunOptions.setActionCommand(this.batchRunOptions.getText());
        this.batchRunOptions.addActionListener(this);
        if (!((InlineHillApplet)this.parent).isPopupMenuOn()) {
            this.pop.setPopupSize(0, 0);
        }
    }

    @Override
    protected void popupSCanv() {
        this.pop.removeAll();
        this.pop.add(this.algorithmOptions);
        this.pop.add(this.batchRunOptions);
        if (((InlineHillApplet)this.parent).showBatchRunOptions || ((InlineHillApplet)this.parent).showAlgorithmOptions) {
            this.pop.addSeparator();
        }
        if (!((InlineHillApplet)this.parent).isPopupMenuOn()) {
            this.pop.setPopupSize(0, 0);
        }
        super.popupSCanv();
        if (!((InlineHillApplet)this.parent).initializePopupOn) {
            this.initialize.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).fineStepPopupOn) {
            this.finestep.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).stepPopupOn) {
            this.step.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).autoSolvePopupOn) {
            this.auto.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).batchRunPopupOn) {
            this.batch.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).stopPopupOn) {
            this.stop.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).showPlotPopupOn) {
            this.showPlot.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).showTracePopupOn) {
            this.showTrace.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).showAlgorithmOptions) {
            this.algorithmOptions.setVisible(false);
        }
        if (!((InlineHillApplet)this.parent).showBatchRunOptions) {
            this.batchRunOptions.setVisible(false);
        }
        if (((InlineHillApplet)this.parent).textRepresentationPopupOn) {
            this.pop.addSeparator();
            JMenuItem mItem = new JMenuItem("View Text Representation");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("View Current State Text Representation");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return true;
    }

    @Override
    protected void aSolvePerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Initialize")) {
            ((InlineHillApplet)this.parent).initializeGraph();
        } else if (arg.equals("Step")) {
            ((InlineHillApplet)this.parent).step();
        } else if (arg.equals("Fine Step")) {
            ((InlineHillApplet)this.parent).fineStep();
        } else if (arg.equals("AutoSolve")) {
            ((InlineHillApplet)this.parent).autoSolveStart();
        } else if (arg.equals("Stop")) {
            ((InlineHillApplet)this.parent).autoSolveStop();
        } else if (arg.equals("Batch Run")) {
            ((InlineHillApplet)this.parent).batchRunStart();
        } else if (arg.equals("Show Plot")) {
            ((InlineHillApplet)this.parent).showPlot();
        } else if (arg.equals("Show Trace")) {
            ((InlineHillApplet)this.parent).showTrace();
        } else if (arg.equals("Algorithm Options")) {
            this.engine.openHeurOptions(null);
        } else if (arg.equals("Batch Run Options")) {
            new BatchDialog(null, this.engine);
        } else if (arg.equals("View Text Representation")) {
            new CSPTextFrame(this, IO.createXML(this.csp, false), "Text Representaion of the Graph", false);
        } else if (arg.equals("View Current State Text Representation")) {
            new CSPTextFrame(this, IO.createXML(this.csp, true), "Current State Text Representaion", false);
        } else {
            super.aSolvePerformed(e);
        }
    }
}

