/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.relations;

import AIspace.cspTools.Domain;
import AIspace.cspTools.Relation;
import AIspace.cspTools.VE.EltsIterator;
import AIspace.cspTools.VE.Factor;
import AIspace.cspTools.VE.FactorUpdatable;
import AIspace.cspTools.VE.VE_Variable;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.relations.FactorPanel;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;

public class RelationFactor
extends Relation {
    protected FactorUpdatable factor;
    protected JFrame parent;
    private String relationLabel = "Custom";
    protected int[] offsets;

    @Override
    public void init(Constraint cns) {
        this.cns = cns;
        this.reset();
    }

    @Override
    public void reset() {
        VE_Variable[] variables = this.getDomains(this.cns.getVariables());
        this.factor = new FactorUpdatable(variables, 1.0);
        this.setOffsets((DomainDiscrete[])variables);
    }

    protected void setOffsets(DomainDiscrete[] domains) {
        int curr;
        if (domains == null || domains.length == 0) {
            this.offsets = new int[1];
            return;
        }
        this.offsets = new int[domains.length];
        this.offsets[this.offsets.length - 1] = curr = 1;
        int i = this.offsets.length - 1;
        while (i > 0) {
            this.offsets[i - 1] = curr *= domains[i].getSize();
            --i;
        }
    }

    @Override
    public boolean testDomains(Domain[] domains) {
        int i = 0;
        while (i < domains.length) {
            if (!(domains[i] instanceof DomainDiscrete)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getType() {
        return "Custom";
    }

    @Override
    public String getLabel() {
        return this.relationLabel;
    }

    @Override
    public void setLabel(String s) {
        this.relationLabel = s;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean viable(int var, int val) {
        splits = new int[this.offsets.length][];
        variables = this.cns.getVariables();
        size = 1;
        i = 0;
        while (i < splits.length) {
            splits[i] = i != var ? variables.get(i).getDomain().getSplitElements() : new int[]{val};
            size *= splits[i].length;
            ++i;
        }
        assig = new int[this.offsets.length];
        i = 0;
        while (i < assig.length) {
            assig[i] = 0;
            ++i;
        }
        v = 0;
        i = 0;
        while (i < size) {
            newassig = new int[assig.length];
            j = 0;
            while (j < assig.length) {
                newassig[j] = splits[j][assig[j]];
                ++j;
            }
            bool = this.getAllowed(newassig);
            if (!bool) ** GOTO lbl30
            return true;
lbl-1000:
            // 1 sources

            {
                assig[v] = 0;
                ++v;
lbl30:
                // 2 sources

                ** while (assig[v] == splits[v].length - 1 && i < size - 1)
            }
lbl31:
            // 1 sources

            v0 = v;
            assig[v0] = assig[v0] + 1;
            v = 0;
            ++i;
        }
        return false;
    }

    @Override
    public boolean testVar(CSPVariable var) {
        return true;
    }

    @Override
    public boolean complete() {
        return true;
    }

    @Override
    public boolean openRD() {
        return true;
    }

    @Override
    public boolean getAllowed(int[] assig) {
        if (this.offsets.length == 0) {
            return this.allowed(0);
        }
        if (assig.length != this.offsets.length) {
            return false;
        }
        int pos = 0;
        int i = 0;
        while (i < this.offsets.length) {
            pos += this.offsets[i] * assig[i];
            ++i;
        }
        return this.allowed(pos);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean test() {
        splits = new int[this.offsets.length][];
        variables = this.cns.getVariables();
        size = 1;
        i = 0;
        while (i < splits.length) {
            splits[i] = variables.get(i).getDomain().getSplitElements();
            size *= splits[i].length;
            ++i;
        }
        assig = new int[this.offsets.length];
        i = 0;
        while (i < assig.length) {
            assig[i] = 0;
            ++i;
        }
        v = 0;
        i = 0;
        while (i < size) {
            newassig = new int[assig.length];
            j = 0;
            while (j < assig.length) {
                newassig[j] = splits[j][assig[j]];
                ++j;
            }
            bool = this.getAllowed(newassig);
            if (!bool) ** GOTO lbl30
            return true;
lbl-1000:
            // 1 sources

            {
                assig[v] = 0;
                ++v;
lbl30:
                // 2 sources

                ** while (assig[v] == splits[v].length - 1 && i < size - 1)
            }
lbl31:
            // 1 sources

            v0 = v;
            assig[v0] = assig[v0] + 1;
            v = 0;
            ++i;
        }
        return false;
    }

    @Override
    public String getTypeString() {
        return "Custom";
    }

    @Override
    public AffirmPanel getEditPanel(boolean edit) {
        FactorPanel panel = new FactorPanel(this.factor, 10, this.cns.getVariables(), edit);
        return panel;
    }

    @Override
    public boolean addDomain(Domain domain) {
        if (domain instanceof DomainDiscrete) {
            DomainDiscrete d = (DomainDiscrete)domain;
            VE_Variable[] vars = this.factor.getVariables();
            VE_Variable[] variables = new VE_Variable[vars.length + 1];
            int i = 0;
            while (i < vars.length) {
                variables[i + 1] = vars[i];
                ++i;
            }
            variables[0] = d;
            FactorUpdatable newfactor = new FactorUpdatable(variables, 1.0);
            int j = 0;
            while (j < d.getSize()) {
                int i2 = 0;
                while (i2 < this.factor.size()) {
                    double val = 0.0;
                    if (this.allowed(i2)) {
                        val = 1.0;
                    }
                    newfactor.update(j * this.factor.size() + i2, val);
                    ++i2;
                }
                ++j;
            }
            this.factor = newfactor;
            this.setOffsets(this.getVariables());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeDomain(Domain domain) {
        if (domain instanceof DomainDiscrete) {
            FactorUpdatable newfactor;
            DomainDiscrete d = (DomainDiscrete)domain;
            VE_Variable[] vars = this.factor.getVariables();
            VE_Variable[] variables = vars.length <= 1 ? new DomainDiscrete[]{} : new DomainDiscrete[vars.length - 1];
            boolean flag = false;
            int i = 0;
            while (i < vars.length) {
                if (vars[i].equals(domain)) {
                    flag = true;
                }
                ++i;
            }
            if (!flag) {
                return false;
            }
            i = 0;
            int j = 0;
            while (j < vars.length) {
                boolean b = vars[j].equals(d);
                if (!b) {
                    variables[i] = (DomainDiscrete)vars[j];
                    ++i;
                }
                ++j;
            }
            this.factor = newfactor = new FactorUpdatable(variables, 1.0);
            this.setOffsets(this.getVariables());
            return true;
        }
        return false;
    }

    public RelationFactor toRFactor() {
        return this;
    }

    protected final boolean allowed(int pos) {
        EltsIterator its = this.factor.iterator();
        its.backTo(pos);
        return its.next() != 0.0;
    }

    protected DomainDiscrete[] getVariables() {
        DomainDiscrete[] vars = new DomainDiscrete[this.factor.getVariables().length];
        VE_Variable[] oldvars = this.factor.getVariables();
        int i = 0;
        while (i < vars.length) {
            vars[i] = (DomainDiscrete)oldvars[i];
            ++i;
        }
        return vars;
    }

    @Override
    public boolean setArgs(Enumeration arg) {
        int i = 0;
        while (arg.hasMoreElements()) {
            if (i >= this.factor.size()) {
                return false;
            }
            Object a = arg.nextElement();
            if (a instanceof String) {
                String s = (String)a;
                if (s.toUpperCase().equals("T")) {
                    this.factor.update(i, 1.0);
                } else if (s.toUpperCase().equals("F")) {
                    this.factor.update(i, 0.0);
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public Factor getFactor() {
        return this.factor;
    }

    @Override
    public String additionalXML(String indent) {
        StringBuffer rep = new StringBuffer();
        rep.append(indent).append("<").append("TABLE").append(">\n").append(indent).append("\t");
        int i = 0;
        while (i < this.factor.size()) {
            if (this.allowed(i)) {
                rep.append("T ");
            } else {
                rep.append("F ");
            }
            ++i;
        }
        rep.append("\n").append(indent).append("</").append("TABLE").append(">\n");
        return rep.toString();
    }

    public void reorder(ArrayList<CSPVariable> variables) {
        VE_Variable[] newOrder = new DomainDiscrete[variables.size()];
        int loop = 0;
        while (loop < variables.size()) {
            newOrder[loop] = variables.get(loop).getDomain();
            ++loop;
        }
        this.factor = this.factor.reorder(newOrder, false, true);
    }
}

