/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.visualElements;

import AIspace.STRIPSToCSP.visualElements.StripsContainer;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class StripsNode
extends Node {
    private StripsContainer container;

    public StripsNode(Graph graph, Point pos) {
        super(graph);
        this.pos = pos;
    }

    public void centerAround(Point pos) {
        Point temp = this.getPos();
        float xPos = pos.x;
        float yPos = pos.y;
        float width = this.getWidth();
        float height = this.getHeight();
        temp.move(xPos -= width / 2.0f, yPos -= height / 2.0f);
        this.setPos(temp);
    }

    public void alignXTo(float xAlignPoint) {
        float tempY = this.getYPos();
        Point newPos = new Point(xAlignPoint, tempY);
        this.setPos(newPos);
        super.move(newPos);
    }

    @Override
    public void move(Point p) {
        float yMax = this.container.getPos().y + (float)this.container.getHeight() - (float)(this.height / 2) - 5.0f;
        float yMin = this.container.getPos().y + (float)this.graph.canvas.getFontMetrics().getAscent() + (float)(this.height / 2) + 2.0f;
        p.x = this.container.getCenterPoint().x;
        if (p.y > yMax) {
            p.y = yMax;
        } else if (p.y < yMin) {
            p.y = yMin;
        }
        float dy = p.y - this.pos.y;
        super.move(p);
    }

    @Override
    public void translate(float dx, float dy) {
        float yMax = this.container.getPos().y + (float)this.container.getHeight() - (float)(this.height / 2) - 5.0f;
        float yMin = this.container.getPos().y + (float)this.graph.canvas.getFontMetrics().getAscent() + (float)(this.height / 2) + 2.0f;
        if (this.getPos().y + dy > yMax) {
            dy = yMax - this.getPos().y;
        } else if (this.getPos().y + dy < yMin) {
            dy = yMin - this.getPos().y;
        }
        if (this.getPos().x + dx != this.container.getCenterPoint().x) {
            dx = this.container.getCenterPoint().x - this.getPos().x;
        }
        super.translate(dx, dy);
    }

    @Override
    protected void drawLabel(Graphics offscreen) {
        FontMetrics fm = this.graph.canvas.getFontMetrics();
        int h = fm.getAscent();
        int width1 = fm.stringWidth(this.label[0]) + this.wPad;
        int width2 = fm.stringWidth(this.label[1]) + this.wPad;
        if (this.isBold && this.color == Color.black) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(this.getColor());
        }
        if (this.label[1].equals("")) {
            offscreen.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y + h / 2);
        } else {
            offscreen.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y - (this.height - this.hPad) / 4 + h / 2);
            offscreen.drawString(this.label[1], (int)this.pos.x - (width2 - this.wPad) / 2, (int)this.pos.y + (this.height - this.hPad) / 4 + h / 2);
        }
    }

    public StripsContainer getContainer() {
        return this.container;
    }

    public void setContainer(StripsContainer container) {
        this.container = container;
    }
}

