/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.visualElements;

import AIspace.STRIPSToCSP.StripsGraph;
import AIspace.STRIPSToCSP.elements.StripsCondition;
import AIspace.STRIPSToCSP.elements.StripsCondition_Conj;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.STRIPSToCSP.visualElements.StripsActionNode;
import AIspace.STRIPSToCSP.visualElements.StripsVariableNode;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;

public class StripsEdge
extends Edge {
    private StripsVariable variable;
    private StripsCondition condition;

    public StripsEdge(StripsGraph graph, Node tail, Node head) {
        super(graph, tail, head);
        this.edgeType = 5551;
        if (tail instanceof StripsVariableNode) {
            this.variable = ((StripsVariableNode)tail).getVariable();
            this.condition = ((StripsActionNode)head).getAction().getPreCondition();
            this.condition.addVariable(this.variable);
        } else if (head instanceof StripsVariableNode) {
            this.variable = ((StripsVariableNode)head).getVariable();
            this.condition = ((StripsActionNode)tail).getAction().getPostCondition();
            this.condition.addVariable(this.variable);
        }
        this.determineLabel();
    }

    public static boolean edgeValid(Node tail, Node head) {
        if (tail instanceof StripsActionNode && head instanceof StripsVariableNode) {
            return ((StripsVariableNode)head).getVariableType() == 4293;
        }
        if (tail instanceof StripsVariableNode && head instanceof StripsActionNode) {
            return ((StripsVariableNode)tail).getVariableType() == 4292;
        }
        return false;
    }

    public StripsCondition getCondition() {
        return this.condition;
    }

    public void setVariableValue(String value) {
        if (this.condition instanceof StripsCondition_Conj) {
            ((StripsCondition_Conj)this.condition).setVariableValue(this.variable, value);
        }
        this.determineLabel();
    }

    private StripsActionNode getActionNode() {
        if (this.getEndNode() instanceof StripsActionNode) {
            return (StripsActionNode)this.getEndNode();
        }
        return (StripsActionNode)this.getStartNode();
    }

    public void removeModel() {
        this.condition.removeVariable(this.variable);
    }

    @Override
    public void removeFromNodes() {
        this.removeModel();
        this.start.removeEdgesOut(this);
        this.end.removeEdgesIn(this);
    }

    public void determineLabel() {
        if (this.condition instanceof StripsCondition_Conj) {
            this.label[0] = ((StripsCondition_Conj)this.condition).getValue(this.variable);
        }
    }

    public StripsVariable getVariable() {
        return this.variable;
    }

    public void setVariable(StripsVariable variable) {
        this.variable = variable;
    }
}

