/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.visualElements;

import AIspace.STRIPSToCSP.visualElements.StripsNode;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Node;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class StripsContainer
extends Node {
    public static final int PRE_CONDITIONS = 99876;
    public static final int POST_CONDITIONS = 99877;
    public static final int ACTIONS = 99878;
    private static final int WIDTH_DELTA = 10;
    private final int DEFAULT_WIDTH = 100;
    private ArrayList<Node> containedObj;
    private int containerType;
    private boolean active;
    private int nodeSpacing;
    private float default_y;

    public StripsContainer(Graph graph) {
        super(graph);
        this.width = 100;
        this.height = 100;
        this.containedObj = new ArrayList();
        this.nodeSpacing = 5;
    }

    @Override
    public boolean contains(AIspace.graphToolKit.elements.Point p) {
        if (p.x > this.pos.x && p.x < this.pos.x + (float)this.width + (float)this.graph.getLineWidth() + (float)this.xw && p.y > this.pos.y && p.y < this.pos.y + (float)this.height * this.graph.getScale() + (float)this.graph.getLineWidth() + (float)this.xw) {
            for (Node e : this.containedObj) {
                if (!e.contains(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void draw(Graphics g, boolean moving) {
        float scale = this.graph.getScale();
        int drawHeight = (int)((float)this.height * scale);
        float lineWidth = this.graph.getLineWidth() + this.xw;
        Color temp = g.getColor();
        g.setColor(this.color);
        g.fillRect((int)(this.pos.x - lineWidth * 2.0f), (int)(this.pos.y - lineWidth * 2.0f), (int)((float)this.width + lineWidth * 4.0f), (int)((float)drawHeight + lineWidth * 4.0f));
        g.setColor(this.internalColor);
        g.fillRect((int)this.pos.x, (int)this.pos.y, this.width, drawHeight);
        this.drawLabel(g);
        if ((!moving || this.graph.canvas.getSubmode() == 3335) && this.isSelected && this.graph.canvas.getMode() != 2221) {
            g.setColor(Color.magenta);
            g.fillRect((int)this.pos.x - 4, (int)this.pos.y - 2, 4, 4);
            g.fillRect((int)this.pos.x - 4, (int)(this.pos.y + (float)this.height * scale) + 2, 4, 4);
            g.fillRect((int)(this.pos.x + (float)this.width * scale) + 2, (int)(this.pos.y - 2.0f), 4, 4);
            g.fillRect((int)(this.pos.x + (float)this.width * scale) + 2, (int)(this.pos.y + (float)this.height * scale) + 2, 4, 4);
        }
        g.setColor(temp);
    }

    @Override
    protected void drawLabel(Graphics offscreen) {
        Color temp = offscreen.getColor();
        if (this.internalColor == Color.black) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(this.color);
        }
        Dimension newDim = this.graph.canvas.parent.getSize();
        offscreen.drawString(this.label[0], (int)(this.pos.x + 5.0f), (int)this.pos.y + this.graph.canvas.getFontMetrics().getAscent());
        offscreen.setColor(temp);
    }

    @Override
    public boolean isInRect(AIspace.graphToolKit.elements.Point a, AIspace.graphToolKit.elements.Point b) {
        boolean left = false;
        boolean right = false;
        boolean top = false;
        boolean bottom = false;
        if (a.x < b.x && this.pos.x > a.x) {
            left = true;
        } else if (this.pos.x > b.x) {
            left = true;
        }
        if (a.x > b.x && this.pos.x + (float)this.width < a.x) {
            right = true;
        } else if (this.pos.x + (float)this.width < b.x) {
            right = true;
        }
        if (a.y < b.y && this.pos.y > a.y) {
            top = true;
        } else if (this.pos.y > b.y) {
            top = true;
        }
        if (a.x > b.x && this.pos.x + (float)this.height < a.x) {
            bottom = true;
        } else if (this.pos.x + (float)this.height < b.x) {
            bottom = true;
        }
        return left && right && top && bottom;
    }

    @Override
    public void move(AIspace.graphToolKit.elements.Point p) {
        p.y = this.pos.y;
        this.pos = p;
        this.layoutContainedObj();
    }

    @Override
    public void translate(float dx, float dy) {
        this.pos.translate(dx, dy);
        this.pos.y = this.default_y;
        for (Node n : this.containedObj) {
            n.translate(dx, dy);
        }
        this.layoutContainedObj();
    }

    public void addMember(Node obj) {
        this.containedObj.add(obj);
        this.height += obj.height;
        if (this.width <= obj.width) {
            this.width = obj.width + 10;
        }
        this.layoutContainedObj();
    }

    public void removeMember(Node obj) {
        if (this.containedObj.remove(obj)) {
            this.height -= obj.height;
            this.layoutContainedObj();
        }
    }

    public ArrayList<Node> getMembers() {
        return this.containedObj;
    }

    @Override
    public Color getInternalColor() {
        return this.internalColor;
    }

    @Override
    public void setInternalColor(Color internalColor) {
        this.internalColor = internalColor;
    }

    public int getContainerType() {
        return this.containerType;
    }

    public void setContainerType(int containerType) {
        this.containerType = containerType;
    }

    public AIspace.graphToolKit.elements.Point getCenterPoint() {
        AIspace.graphToolKit.elements.Point tempPoint = new AIspace.graphToolKit.elements.Point();
        tempPoint.x = this.pos.x + (float)(this.width / 2);
        tempPoint.y = this.pos.y + (float)(this.height / 2);
        return tempPoint;
    }

    public void setCenterPoint(AIspace.graphToolKit.elements.Point center) {
        this.pos.x = center.x - (float)(this.width / 2);
        this.default_y = this.pos.y = center.y - (float)(this.height / 2);
    }

    private void layoutContainedObj() {
        AIspace.graphToolKit.elements.Point centerP = this.getCenterPoint();
        float yMin = this.pos.y + (float)this.graph.canvas.getFontMetrics().getAscent();
        float yMax = this.pos.y + (float)this.height * this.graph.getScale();
        for (Node n : this.containedObj) {
            float dY;
            AIspace.graphToolKit.elements.Point moveToP = new AIspace.graphToolKit.elements.Point(centerP.x, yMin);
            if (!this.active) {
                n.setColor(Color.lightGray);
            } else {
                n.setColor(Color.black);
            }
            float nodeYPos = ((StripsNode)n).pos.y - (float)(n.height / 2) - 5.0f;
            if (nodeYPos < yMin) {
                dY = yMin - nodeYPos;
                ((StripsNode)n).translate(0.0f, dY);
            }
            if ((nodeYPos = ((StripsNode)n).pos.y + (float)(n.height / 2) + 2.0f) > yMax) {
                dY = yMax - nodeYPos;
                ((StripsNode)n).translate(0.0f, dY);
            }
            ((StripsNode)n).alignXTo(moveToP.x);
        }
        this.graph.canvas.updateGraph();
    }

    @Override
    protected int getHeight() {
        return this.height;
    }

    @Override
    protected int getWidth() {
        int oldWidth = this.width;
        this.width = 100;
        if (this.containedObj != null && !this.containedObj.isEmpty()) {
            for (Node n : this.containedObj) {
                n.updateSize();
                if (n.width <= this.width - 10) continue;
                this.width = n.width + 10;
            }
        } else {
            int tempWidth = this.graph.canvas.getFontMetrics().stringWidth(this.label[0]) + this.wPad;
            if (tempWidth > this.width) {
                this.width = tempWidth;
            }
        }
        return this.width;
    }

    public void makeNonActive() {
        this.active = false;
        this.color = Color.lightGray;
        this.layoutContainedObj();
    }

    public boolean isActive() {
        return this.active;
    }

    public void makeActive() {
        this.active = true;
        this.color = Color.black;
        this.layoutContainedObj();
    }

    public int getNodeSpacing() {
        return this.nodeSpacing;
    }

    public void setNodeSpacing(int nodeSpacing) {
        this.nodeSpacing = nodeSpacing;
    }

    public boolean withinResizeArea(MouseEvent e) {
        int pad = 2;
        AIspace.graphToolKit.elements.Point containerPos = this.getPos();
        float lowerBoundX = containerPos.x;
        float lowerBoundY = containerPos.y + (float)this.height - (float)pad;
        float upperBoundX = lowerBoundX + (float)this.width + (float)this.graph.getLineWidth() + (float)this.xw;
        float upperBoundY = lowerBoundY + (float)this.graph.getLineWidth() + (float)this.xw + (float)pad;
        Point eventPoint = e.getPoint();
        return (float)eventPoint.x >= lowerBoundX && (float)eventPoint.x < upperBoundX && (float)eventPoint.y >= lowerBoundY && (float)eventPoint.y < upperBoundY && this.active;
    }

    public void resizeY(float draggingDifY) {
        this.height = (int)((float)this.height + draggingDifY / this.graph.getScale());
    }
}

