/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP.dialogs;

import AIspace.STRIPSToCSP.elements.StripsAction;
import AIspace.STRIPSToCSP.elements.StripsCondition;
import AIspace.STRIPSToCSP.elements.StripsCondition_Conj;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Point;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class ActionEditDialog
extends BasicDialog {
    private static final long serialVersionUID = -5958496959271452902L;
    private StripsAction currentAct;
    private boolean isCancelled = true;
    private JPanel controlPanel;
    private AffirmPanel namePanel;
    private JSplitPane split;

    public ActionEditDialog(JFrame parent, StripsAction action, boolean creating) {
        super(parent, "Action creation/edit", true);
        this.currentAct = action;
        new JToolBar();
        if (parent != null) {
            java.awt.Point tempPoint = parent.getLocationOnScreen();
            Point loc = new Point((float)tempPoint.getX(), (float)tempPoint.getY());
            loc.translate(20.0f, 20.0f);
        }
        this.setInternals();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridheight = 3;
        this.getContentPane().setLayout(this.gbl);
        this.controlPanel = new JPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        this.controlPanel.add(ok);
        this.controlPanel.add(cancel);
        this.addComponent(this.namePanel, this, 0, 0, 1, 1, 0.0, 0.0);
        if (!creating) {
            this.addComponent(this.split, this, 1, 0, -1, 1, 1.0, 1.0);
            this.setSize(400, 300);
        } else {
            this.setSize(300, 100);
        }
        this.addComponent(this.controlPanel, this, 2, 0, -1, 1, 0.0, 0.0);
        this.centerWindow();
        this.setVisible(true);
    }

    private void setInternals() {
        this.namePanel = new AffirmPanel();
        this.setLayout(new BoxLayout(this, 0));
        this.namePanel.add(new JLabel("Variable Name:     "));
        JTextField value = new JTextField(this.currentAct.getName(), 10);
        this.namePanel.add(value);
        this.split = new JSplitPane(1);
        this.split.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent c) {
                ActionEditDialog.this.split.setDividerLocation(0.5);
            }
        });
        JPanel preConditions = new JPanel();
        preConditions.setLayout(new BoxLayout(preConditions, 1));
        JPanel label = new JPanel();
        label.add(new JLabel("Preconditions"));
        label.setAlignmentX(0.5f);
        preConditions.add(label);
        preConditions.add(Box.createVerticalStrut(5));
        StripsCondition condition = this.currentAct.getPreCondition();
        Iterator<StripsVariable> preIter = condition.getVariables().iterator();
        while (preIter.hasNext()) {
            preConditions.add(this.makeCondPanel(preIter.next(), condition));
            preConditions.add(Box.createVerticalStrut(10));
        }
        preConditions.add(Box.createVerticalGlue());
        preConditions.add(Box.createVerticalGlue());
        JPanel postConditions = new JPanel();
        postConditions.setLayout(new BoxLayout(postConditions, 1));
        label = new JPanel();
        label.add(new JLabel("PostConditions"));
        postConditions.add(label);
        condition = this.currentAct.getPostCondition();
        Iterator<StripsVariable> postIter = condition.getVariables().iterator();
        while (postIter.hasNext()) {
            postConditions.add(this.makeCondPanel(postIter.next(), condition));
            postConditions.add(Box.createVerticalStrut(5));
        }
        postConditions.add(Box.createVerticalGlue());
        postConditions.add(Box.createVerticalGlue());
        JScrollPane variableScrollPane = new JScrollPane(preConditions);
        JScrollPane actionScrollPane = new JScrollPane(postConditions);
        this.split.setLeftComponent(variableScrollPane);
        this.split.setRightComponent(actionScrollPane);
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    protected boolean actionOK() {
        if (!this.namePanel.ok()) {
            return false;
        }
        this.currentAct.setName(((JTextField)this.namePanel.getComponent(1)).getText());
        this.isCancelled = false;
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public StripsAction getCurrentVar() {
        return this.currentAct;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    private JPanel makeCondPanel(StripsVariable variable, StripsCondition condition) {
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 1));
        JLabel name = new JLabel("Name: " + variable.getName());
        name.setAlignmentX(0.0f);
        tempPanel.add(name);
        if (this.currentAct.getPreCondition() instanceof StripsCondition_Conj) {
            JLabel value = new JLabel("Value: " + ((StripsCondition_Conj)condition).getValue(variable));
            value.setAlignmentX(0.0f);
            tempPanel.add(value);
        }
        tempPanel.setAlignmentX(0.5f);
        return tempPanel;
    }
}

