/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP;

import AIspace.STRIPSToCSP.StripsCanvas;
import AIspace.STRIPSToCSP.StripsGraph;
import AIspace.STRIPSToCSP.StripsIO.StripsIO;
import AIspace.STRIPSToCSP.conversion.StripsArcConsistency;
import AIspace.STRIPSToCSP.conversion.StripsConverter;
import AIspace.STRIPSToCSP.conversion.StripsStochasticSearch;
import AIspace.STRIPSToCSP.dialogs.ActionEditDialog;
import AIspace.STRIPSToCSP.dialogs.MaximumHorizonSetterDialog;
import AIspace.STRIPSToCSP.dialogs.StripsDescriptionDialog;
import AIspace.STRIPSToCSP.dialogs.StripsStateEditor;
import AIspace.STRIPSToCSP.dialogs.StripsTextFrame;
import AIspace.STRIPSToCSP.dialogs.VariableEditDialog;
import AIspace.STRIPSToCSP.elements.StripsAction;
import AIspace.STRIPSToCSP.elements.StripsProblem;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.cspTools.CSPWindow;
import AIspace.cspTools.domains.DomainBoolean;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.help.HelpMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class StripsWindow
extends GraphWindow {
    private static final long serialVersionUID = 7544765637596615415L;
    private JMenuItem xmlRepresentationMenuItem;
    private JMenuItem descriptionMenuItem;
    private JMenuItem redoItem;
    private JMenuItem undoItem;
    protected String[] undoArray;
    protected int undoIndex;
    protected final int undoLimit = 5;
    private JButton fakeButton;
    private JButton[] createButtons;
    private JButton[] solveButtons;
    private StripsConverter converter;
    private JButton horizonButton;
    private JComboBox horizonBox;
    private int horizonLength = 5;
    private int horizonMax = 5;
    private JMenuItem maxHorizonSetter;
    private StripsIO IO;
    protected int canvasSubMode;
    protected int savedPressedButton;
    private static final int NUM_CREATE_TOGGLES = 6;
    private static final int NUM_CREATE_NONTOGGLES = 2;
    private static final int NUM_SOLVE_NONTOGGLES = 3;
    private static final int NUM_SOLVE_TOGGLES = 0;
    private StripsProblem problem;

    public StripsWindow(JApplet parent) {
        super(parent);
        this.setSize(850, 700);
        this.initializeAppletInfo();
        this.initialize();
        this.algoText.setText("");
        this.bottomPanel.setVisible(false);
        this.centerWindow();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new StripsWindow(null);
    }

    private void initializeAppletInfo() {
        appletTitle = "STRIPS to CSP Applet Version 4.0.4";
        appletName = "STRIPStoCSP";
        aboutText = "About this Applet\n\n" + appletTitle + "\n\n" + "This applet was written by Andre Gagne with help from " + "Holger Hoos, Cristina Conati, Wesley Coelho, Joseph Roy Santos, " + "Mike Cline, Peter Gorniak, Giuseppe Carenini, Alan Mackworth and " + "David Poole.";
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.xml");
    }

    private void initialize() {
        this.IO = new StripsIO();
        this.converter = new StripsConverter();
        this.undoArray = new String[6];
        this.resetUndoState();
        this.toolBar.setVisible(true);
        this.createToolBarWithText();
        this.undoItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        this.tabbedPane.setSelectedIndex(0);
        ((StripsCanvas)this.canvas).setProblem(new StripsProblem());
        this.problem = ((StripsCanvas)this.canvas).getProblem();
        ((StripsGraph)this.canvas.graph).setInitialContainers();
        this.setInitialCreateMode();
    }

    private void setInitialCreateMode() {
        this.returnCanvas().setMode(2220);
        this.returnCanvas().setSubmode(33491);
        this.setPromptLabel("Click in PreConditions area to create a variable.");
        this.createButModes[0].setSelected(true);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    @Override
    protected void getCanvas() {
        this.canvas = new StripsCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    @Override
    protected void createToolBarWithText() {
        this.createButtons = new JButton[2];
        this.setCreateButtonsWithText(0, "Set Start State", this.createNodeIcon, "View/Edit the Start State", false);
        this.setCreateButtonsWithText(1, "Set Goal State", this.createNodeIcon, "View/Edit the Goal State", false);
        this.createButModes = new JToggleButton[6];
        this.setCreateButtonsWithText(0, "Create Variable", this.createNodeIcon, "Create Variable", true);
        this.setCreateButtonsWithText(1, "Create Action", this.createNodeIcon, "Create Action", true);
        this.setCreateButtonsWithText(2, "Create Arc", this.createEdgeIcon, "Create Arc", true);
        this.setCreateButtonsWithText(3, "   Select   ", this.selectIcon, "Select", true);
        this.setCreateButtonsWithText(4, "   Delete   ", this.deleteIcon, "Delete", true);
        this.setCreateButtonsWithText(5, "Set Properties", this.setPropsIcon, "Set Properties", true);
        this.createToolBarLayout();
    }

    @Override
    protected void createToolBar() {
        this.createButtons = new JButton[2];
        this.setCreateButtons(0, this.createNodeIcon, "View/Edit the Start State", false);
        this.setCreateButtons(1, this.createNodeIcon, "View/Edit the Goal State", false);
        this.createButModes = new JToggleButton[6];
        this.setCreateButtons(0, this.createNodeIcon, "Create Variable", true);
        this.setCreateButtons(1, this.createNodeIcon, "Create Action", true);
        this.setCreateButtons(2, this.createEdgeIcon, "Create Arc", true);
        this.setCreateButtons(3, this.selectIcon, "   Select   ", true);
        this.setCreateButtons(4, this.deleteIcon, "   Delete   ", true);
        this.setCreateButtons(5, this.setPropsIcon, "Set Properties", true);
        this.createToolBarLayout();
    }

    private void createToolBarLayout() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        int i = 0;
        while (i < this.createButModes.length) {
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 0;
        while (i < this.createButtons.length) {
            this.createModeButGroup.add(this.createButtons[i]);
            this.toolBar.add(this.createButtons[i]);
            this.createButtons[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        return menuBar;
    }

    @Override
    protected void solveToolBar() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        this.solveButModes = new JToggleButton[0];
        this.solveButtons = new JButton[3];
        this.setSolveButtonsWithText(0, "Solve with Arc Consistency", this.setPropsIcon, "Launch Arc Consistency applet", false);
        this.setSolveButtonsWithText(1, "Solve with SLS", this.setPropsIcon, "Solve with Stochastic Local Search", false);
        this.setSolveButtonsWithText(2, "Save as CSP", this.setPropsIcon, "Save the problem as a CSP", false);
        this.horizonButton = new JButton("Set Horizon", this.setPropsIcon);
        this.horizonButton.setActionCommand("Set Horizon");
        this.horizonButton.addActionListener(this);
        this.horizonButton.setToolTipText("Click to set the horizon");
        this.horizonButton.setVerticalTextPosition(3);
        this.horizonButton.setHorizontalTextPosition(0);
        this.horizonBox = new JComboBox();
        this.fillHorizonBox();
        this.horizonBox.addActionListener(this);
        this.layoutSolveButtons();
    }

    private void layoutSolveButtons() {
        int i;
        this.toolBar.removeAll();
        if (this.solveButModes.length > 0) {
            this.solveModeButGroup = new ButtonGroup();
            i = 0;
            while (i < this.solveButModes.length) {
                this.solveModeButGroup.add(this.solveButtons[i]);
                this.toolBar.add(this.solveButModes[i]);
                this.solveButModes[i].setFont(this.toolBarFont);
                ++i;
            }
            this.toolBar.addSeparator();
        }
        i = 0;
        while (i < this.solveButtons.length) {
            this.solveModeButGroup.add(this.solveButtons[i]);
            this.toolBar.add(this.solveButtons[i]);
            this.solveButtons[i].setFont(this.toolBarFont);
            ++i;
        }
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.horizonButton);
        this.toolBar.add(this.horizonBox);
        this.algoText.setText(" ");
    }

    protected void setCreateButtons(int num, ImageIcon icon, String toolTip, Boolean toggle) {
        if (toggle.booleanValue()) {
            this.createButModes[num] = new JToggleButton(icon);
            this.createButModes[num].setActionCommand(toolTip);
            this.createButModes[num].addActionListener(this);
            this.createButModes[num].setToolTipText(toolTip);
        } else {
            this.createButtons[num] = new JButton(icon);
            this.createButtons[num].setActionCommand(toolTip);
            this.createButtons[num].addActionListener(this);
            this.createButtons[num].setToolTipText(toolTip);
        }
    }

    protected void setSolveButtons(int num, ImageIcon icon, String toolTip, Boolean toggle) {
        if (toggle.booleanValue()) {
            this.solveButModes[num] = new JToggleButton(icon);
            this.solveButModes[num].setActionCommand(toolTip);
            this.solveButModes[num].addActionListener(this);
            this.solveButModes[num].setToolTipText(toolTip);
        } else {
            this.solveButtons[num] = new JButton(icon);
            this.solveButtons[num].setActionCommand(toolTip);
            this.solveButtons[num].addActionListener(this);
            this.solveButtons[num].setToolTipText(toolTip);
        }
    }

    protected void setCreateButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip, Boolean toggle) {
        if (toggle.booleanValue()) {
            this.createButModes[num] = new JToggleButton(buttonName, icon);
            this.createButModes[num].addActionListener(this);
            this.createButModes[num].setToolTipText(toolTip);
            this.createButModes[num].setVerticalTextPosition(3);
            this.createButModes[num].setHorizontalTextPosition(0);
        } else {
            this.createButtons[num] = new JButton(buttonName, icon);
            this.createButtons[num].addActionListener(this);
            this.createButtons[num].setToolTipText(toolTip);
            this.createButtons[num].setVerticalTextPosition(3);
            this.createButtons[num].setHorizontalTextPosition(0);
        }
    }

    protected void setSolveButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip, Boolean toggle) {
        if (toggle.booleanValue()) {
            this.solveButModes[num] = new JToggleButton(buttonName, icon);
            this.solveButModes[num].setActionCommand(toolTip);
            this.solveButModes[num].addActionListener(this);
            this.solveButModes[num].setToolTipText(toolTip);
            this.solveButModes[num].setVerticalTextPosition(3);
            this.solveButModes[num].setHorizontalTextPosition(0);
        } else {
            this.solveButtons[num] = new JButton(buttonName, icon);
            this.solveButtons[num].setActionCommand(toolTip);
            this.solveButtons[num].addActionListener(this);
            this.solveButtons[num].setToolTipText(toolTip);
            this.solveButtons[num].setVerticalTextPosition(3);
            this.solveButtons[num].setHorizontalTextPosition(0);
        }
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        JMenuItem mItem = new JMenuItem("Create New STRIPS");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(78);
        m.add(mItem);
        mItem = new JMenuItem("Load Sample STRIPS");
        mItem.addActionListener(this);
        mItem.setMnemonic(83);
        m.add(mItem);
        boolean hasLocalAccess = this.hasLocalAccess();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Load From File");
            mItem.setActionCommand(mItem.getText());
            mItem.setMnemonic(70);
            mItem.setDisplayedMnemonicIndex(10);
            mItem.addActionListener(this);
            m.add(mItem);
        }
        mItem = new JMenuItem("Load From URL");
        mItem.setMnemonic(85);
        mItem.addActionListener(this);
        m.add(mItem);
        m.addSeparator();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Save STRIPS");
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        }
        mItem = new JMenuItem("Print");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(80);
        m.add(mItem);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        m.setMnemonic(69);
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.setMnemonic(85);
        this.undoItem.addActionListener(this);
        m.add(this.undoItem);
        this.redoItem = new JMenuItem("Redo");
        this.redoItem.setMnemonic(82);
        this.redoItem.addActionListener(this);
        m.add(this.redoItem);
        this.maxHorizonSetter = new JMenuItem("Set Max Horizon Length");
        this.maxHorizonSetter.addActionListener(this);
        this.maxHorizonSetter.setVisible(false);
        m.add(this.maxHorizonSetter);
        m.addSeparator();
        this.xmlRepresentationMenuItem = new JMenuItem("View/Edit XML Representation");
        this.xmlRepresentationMenuItem.setMnemonic(88);
        this.xmlRepresentationMenuItem.addActionListener(this);
        m.add(this.xmlRepresentationMenuItem);
        this.descriptionMenuItem = new JMenuItem("View/Edit STRIPS Description");
        this.descriptionMenuItem.setMnemonic(68);
        this.descriptionMenuItem.setDisplayedMnemonicIndex(10);
        this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
        this.descriptionMenuItem.addActionListener(this);
        m.add(this.descriptionMenuItem);
        return m;
    }

    @Override
    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        return m;
    }

    @Override
    protected JMenu createHelpMenu() {
        return new HelpMenu("strips_to_csp", this);
    }

    @Override
    public void switchTab(String str) {
        super.switchTab(str);
        this.setPromptColor(Color.blue);
        if (str == "Create") {
            this.xmlRepresentationMenuItem.setText("View/Edit XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View/Edit CSP Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.maxHorizonSetter.setVisible(false);
            this.bottomPanel.setVisible(false);
            if (this.undoIndex > 0) {
                this.undoItem.setEnabled(true);
            }
            if (this.undoArray[this.undoIndex] != null) {
                this.redoItem.setEnabled(true);
            }
        } else if (str == "Solve") {
            this.xmlRepresentationMenuItem.setText("View XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View CSP Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.maxHorizonSetter.setVisible(true);
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Press on one of the buttons in the toolbar to convert the problem and begin solving");
        }
        this.validate();
    }

    public void saveUndo() {
        this.redoItem.setEnabled(false);
        this.undoItem.setEnabled(true);
        if (this.undoIndex >= 5) {
            int i = 0;
            while (i < 4) {
                this.undoArray[i] = this.undoArray[i + 1];
                ++i;
            }
            this.undoArray[5] = null;
        } else if (this.undoArray[this.undoIndex] != null) {
            int i = this.undoIndex;
            while (i < 5) {
                this.undoArray[i] = null;
                ++i;
            }
        }
    }

    public void loadUndo() {
        String cfr_ignored_0 = this.undoArray[this.undoIndex];
        this.redoItem.setEnabled(true);
        if (this.undoIndex == 0) {
            this.undoItem.setEnabled(false);
        }
    }

    public void resetUndoState() {
        this.undoItem.setEnabled(false);
        this.redoItem.setEnabled(false);
        int i = 0;
        while (i < 5) {
            this.undoArray[i] = null;
            ++i;
        }
        this.undoIndex = 0;
    }

    public void loadRedo() {
        if (this.undoIndex >= 5 || this.undoArray[this.undoIndex] == null) {
            return;
        }
        this.undoItem.setEnabled(true);
        if (this.undoIndex == 5 || this.undoArray[this.undoIndex + 1] == null) {
            this.redoItem.setEnabled(false);
        }
    }

    private void createNewVariable() {
        StripsVariable newVar = new StripsVariable(new DomainBoolean(), "New Variable");
        VariableEditDialog variableDialog = new VariableEditDialog((JFrame)this, newVar);
        if (!variableDialog.isCancelled()) {
            this.problem.addVariable(newVar);
        }
    }

    private void createNewAction() {
        StripsAction newAct = new StripsAction("New Action");
        ActionEditDialog actionDialog = new ActionEditDialog((JFrame)this, newAct, true);
        if (!actionDialog.isCancelled()) {
            this.problem.addAction(newAct);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand();
        if (this.canvas.getMode() == 2220) {
            if (e.getSource() == this.createButModes[0]) {
                this.returnCanvas().setSubmode(33491);
                this.setPromptLabel("Click in PreConditions area to create a variable.");
                return;
            }
            if (e.getSource() == this.createButModes[1]) {
                this.returnCanvas().setSubmode(33492);
                this.setPromptLabel("Click in the Actions area to create an action.");
                return;
            }
            if (e.getSource() == this.createButtons[0]) {
                StripsStateEditor editor = new StripsStateEditor((JFrame)this, this.problem.getStartState());
                return;
            }
            if (e.getSource() == this.createButtons[1]) {
                StripsStateEditor editor = new StripsStateEditor((JFrame)this, this.problem.getEndState());
                return;
            }
        }
        if (this.canvas.getMode() == 2221) {
            if (e.getSource() == this.solveButtons[0]) {
                StripsArcConsistency consistencyApp = new StripsArcConsistency(null);
                this.convertToCSPandRun(consistencyApp);
                return;
            }
            if (e.getSource() == this.solveButtons[1]) {
                StripsStochasticSearch SLSapp = new StripsStochasticSearch(null);
                this.convertToCSPandRun(SLSapp);
                return;
            }
            if (e.getSource() == this.solveButtons[2]) {
                StripsArcConsistency consistencyApp = new StripsArcConsistency(null, false);
                this.saveAsCSP(consistencyApp);
                return;
            }
            if (e.getSource() == this.horizonButton) {
                this.horizonLength = (Integer)this.horizonBox.getSelectedItem();
                return;
            }
            if (e.getSource() == this.horizonBox) {
                this.horizonLength = this.horizonBox.getItemCount() != 0 ? (Integer)this.horizonBox.getSelectedItem() : 0;
                return;
            }
            if (e.getSource() == this.maxHorizonSetter) {
                this.setMaxHorizonLength();
                return;
            }
        }
        super.actionPerformed(e);
        if (arg.equals("Create New STRIPS")) {
            this.createNewGraph();
        } else if (arg.equals("Load Sample STRIPS")) {
            this.loadSampleGraph();
        } else if (arg.equals("Save STRIPS")) {
            this.saveGraph();
        } else if (arg.equals("View/Edit XML Representation")) {
            new StripsTextFrame(this.canvas, this.IO.graphToXML((StripsGraph)this.canvas.graph), "Text Representaion of the Graph", true);
        } else if (arg.equals("View XML Representation")) {
            new StripsTextFrame(this.canvas, this.IO.graphToXML((StripsGraph)this.canvas.graph), "Text Representaion of the Graph", false);
        } else if (arg.equals("View/Edit STRIPS Description")) {
            new StripsDescriptionDialog((GraphWindow)this, (StripsGraph)this.canvas.graph, true).open();
        } else if (arg.equals("View STRIPS Description")) {
            new StripsDescriptionDialog((GraphWindow)this, (StripsGraph)this.canvas.graph, true).open();
        }
    }

    @Override
    public void load(BufferedReader in) {
        try {
            String line;
            StringBuffer allText = new StringBuffer();
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
                lines.add(line);
            }
            in.close();
            this.canvas.reset();
            this.updateFromXML(allText.toString());
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (IOException e) {
            this.showMessage("Error", e.toString());
        }
    }

    public boolean updateFromXML(String text) {
        StripsGraph newGraph = new StripsGraph((StripsCanvas)this.canvas);
        newGraph.setInitialContainers();
        Boolean success = this.IO.parseXML(text, newGraph);
        if (success.booleanValue()) {
            this.problem = newGraph.getProblem();
            this.canvas.setGraph(newGraph);
            this.canvas.updateGraph();
            this.validate();
            this.setInitialCreateMode();
        } else {
            this.setInitialCreateMode();
        }
        return true;
    }

    @Override
    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(this.IO.graphToXML((StripsGraph)this.canvas.graph));
            out.close();
            this.fileName = file.getName();
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    @Override
    protected void createNewGraph() {
        super.createNewGraph();
        ((StripsGraph)this.canvas.graph).setInitialContainers();
        this.setInitialCreateMode();
    }

    @Override
    protected void restoreProperties() {
        this.savedLineWidthMenuItem.setSelected(true);
        this.returnCanvas().graph.setLineWidth(this.savedLineWidth);
        this.returnCanvas().changeLineWidth();
        this.savedFontSizeMenuItem.setSelected(true);
        this.returnCanvas().changeFont(this.savedFontSize);
    }

    private void convertToCSPandRun(CSPWindow window) {
        if (window instanceof StripsArcConsistency) {
            ((StripsArcConsistency)window).setCSPcanvas(this.converter.convertToCSP((StripsGraph)this.canvas.graph, this.horizonLength, window));
        } else if (window instanceof StripsStochasticSearch) {
            ((StripsStochasticSearch)window).setCSPcanvas(this.converter.convertToCSP((StripsGraph)this.canvas.graph, this.horizonLength, window));
        }
    }

    private void saveAsCSP(CSPWindow window) {
        ((StripsArcConsistency)window).setCSPcanvas(this.converter.convertToCSP((StripsGraph)this.canvas.graph, this.horizonLength, window));
        window.saveGraph();
        window.dispose();
    }

    private void setMaxHorizonLength() {
        MaximumHorizonSetterDialog horizonDialog = new MaximumHorizonSetterDialog((JFrame)this, this.horizonMax);
        if (!horizonDialog.isCancelled()) {
            this.horizonMax = horizonDialog.getMaxLength();
            this.fillHorizonBox();
        }
    }

    private void fillHorizonBox() {
        this.horizonBox.removeAllItems();
        int loop = 1;
        while (loop <= this.horizonMax) {
            this.horizonBox.addItem(new Integer(loop));
            ++loop;
        }
        this.horizonBox.setSelectedIndex(0);
        this.horizonLength = (Integer)this.horizonBox.getSelectedItem();
    }
}

