/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP;

import AIspace.STRIPSToCSP.StripsCanvas;
import AIspace.STRIPSToCSP.elements.StripsProblem;
import AIspace.STRIPSToCSP.visualElements.StripsActionNode;
import AIspace.STRIPSToCSP.visualElements.StripsContainer;
import AIspace.STRIPSToCSP.visualElements.StripsEdge;
import AIspace.STRIPSToCSP.visualElements.StripsNode;
import AIspace.STRIPSToCSP.visualElements.StripsVariableNode;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;

public class StripsGraph
extends Graph {
    private StripsProblem problem;
    private String shortDescription;
    private String detailedDescription;

    public StripsGraph(StripsCanvas canvas) {
        super(canvas);
        this.problem = canvas.getProblem();
        this.shortDescription = new String();
        this.detailedDescription = new String();
    }

    public void setInitialContainers() {
        int height = this.canvas.parent.getHeight();
        int width = this.canvas.parent.getWidth();
        StripsContainer tempContainer = new StripsContainer(this.canvas.graph);
        Point tempPoint = new Point();
        Dimension size = this.canvas.getPreferredSize();
        double centerX = size.getWidth() / 2.0;
        double centerY = size.getHeight() / 2.0;
        tempPoint.move((float)centerX, (float)centerY);
        tempContainer.setLabel("PreConditions");
        tempContainer.setContainerType(99876);
        tempPoint.translate(-(width / 4 + tempContainer.width), height / 8);
        tempContainer.setCenterPoint(tempPoint);
        this.addNode(tempContainer);
        tempContainer = new StripsContainer(this.canvas.graph);
        tempContainer.setLabel("Actions");
        tempContainer.setContainerType(99878);
        tempPoint.translate(width / 4, 0.0f);
        tempContainer.setCenterPoint(tempPoint);
        this.addNode(tempContainer);
        tempContainer = new StripsContainer(this.canvas.graph);
        tempContainer.setLabel("Postconditions");
        tempContainer.setContainerType(99877);
        tempPoint.translate(width / 4, 0.0f);
        tempContainer.setCenterPoint(tempPoint);
        this.addNode(tempContainer);
    }

    public StripsProblem getProblem() {
        return this.problem;
    }

    public void setProblem(StripsProblem problem) {
        this.problem = problem;
    }

    public void updateLabels() {
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.get(i);
            if (n instanceof StripsVariableNode) {
                ((StripsVariableNode)n).updateLabel();
            } else if (n instanceof StripsActionNode) {
                ((StripsActionNode)n).updateLabel();
            }
            ++i;
        }
    }

    @Override
    public void deleteSelected() {
        int i = 0;
        while (i < this.selectedNodes.size()) {
            Node e = (Node)this.selectedNodes.get(i);
            if (e instanceof StripsVariableNode) {
                this.deleteVariable((StripsVariableNode)e);
            }
            ++i;
        }
        super.deleteSelected();
    }

    private void deleteVariable(StripsVariableNode node) {
        ArrayList<StripsVariableNode> siblings = new ArrayList<StripsVariableNode>();
        StripsVariableNode sibling = node.getSibling();
        if (!this.selectedNodes.contains(sibling)) {
            siblings.add(sibling);
        }
        this.problem.removeVariable(node.getVariable());
        int i = 0;
        while (i < this.nodes.size() && this.nodes.get(i) instanceof StripsContainer) {
            ((StripsContainer)this.nodes.get(i)).removeMember(node);
            ++i;
        }
        if (!this.selectedNodes.containsAll(siblings)) {
            this.selectedNodes.addAll(siblings);
        }
    }

    protected void deleteEdge(StripsEdge edge) {
        this.selectedEdges.add(edge);
        this.deleteSelected();
    }

    @Override
    public void addNode(Node newNode) {
        Node properContainer = null;
        for (Node n : this.nodes) {
            if (!(n instanceof StripsContainer)) continue;
            if (((StripsContainer)n).getContainerType() == 99878 && newNode instanceof StripsActionNode) {
                properContainer = n;
            }
            if (((StripsContainer)n).getContainerType() == 99876 && newNode instanceof StripsVariableNode && ((StripsVariableNode)newNode).getVariableType() == 4292) {
                properContainer = n;
            }
            if (((StripsContainer)n).getContainerType() != 99877 || !(newNode instanceof StripsVariableNode) || ((StripsVariableNode)newNode).getVariableType() != 4293) continue;
            properContainer = n;
        }
        if (properContainer != null) {
            ((StripsNode)newNode).setContainer((StripsContainer)properContainer);
            ((StripsContainer)properContainer).addMember(newNode);
        }
        super.addNode(newNode);
    }

    @Override
    public void draw(Graphics g, boolean moving) {
        this.drawContainers(g, moving);
        this.drawEdges(g, moving);
        this.drawNodes(g, moving);
    }

    public void makeActive(int containerType) {
        int i = 0;
        while (i < this.nodes.size() && this.nodes.get(i) instanceof StripsContainer) {
            Node n = (Node)this.nodes.get(i);
            if (((StripsContainer)n).getContainerType() != containerType) {
                ((StripsContainer)n).makeNonActive();
            }
            if (((StripsContainer)n).getContainerType() == containerType) {
                ((StripsContainer)n).makeActive();
            }
            ++i;
        }
    }

    public void makeDefaultActive() {
        int i = 0;
        while (i < this.nodes.size() && this.nodes.get(i) instanceof StripsContainer) {
            Node n = (Node)this.nodes.get(i);
            ((StripsContainer)n).makeActive();
            ++i;
        }
    }

    public void drawContainers(Graphics g, boolean moving) {
        this.updateEdgeSize();
        int i = 0;
        while (i < this.nodes.size() && this.nodes.get(i) instanceof StripsContainer) {
            ((Node)this.nodes.get(i)).draw(g, moving);
            ++i;
        }
    }

    public void drawEdges(Graphics g, boolean moving) {
        int i = 0;
        while (i < this.edges.size()) {
            Edge curEdge = (Edge)this.edges.get(i);
            curEdge.draw(g, moving);
            curEdge.eLabel.draw(g, moving);
            ++i;
        }
    }

    public void drawNodes(Graphics g, boolean moving) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (!(this.nodes.get(i) instanceof StripsContainer)) {
                ((Node)this.nodes.get(i)).draw(g, moving);
            }
            ++i;
        }
    }

    @Override
    public void translateAll(float dx, float dy) {
        int i = 0;
        while (i < this.nodes.size() && this.nodes.get(i) instanceof StripsContainer) {
            ((Node)this.nodes.get(i)).translate(dx, dy);
            ++i;
        }
    }

    @Override
    public Point[] getBound() {
        float miny;
        float minx;
        ArrayList<StripsContainer> containers = this.getContainers();
        StripsContainer firstContainer = containers.get(0);
        float maxx = minx = firstContainer.getXPos();
        float maxy = miny = firstContainer.getYPos();
        int loop = 1;
        while (loop < containers.size()) {
            StripsContainer container = containers.get(loop);
            if (minx > container.getXPos()) {
                minx = container.getXPos();
            }
            if (miny > container.getYPos()) {
                miny = container.getYPos();
            }
            if (maxx < container.getXPos() + (float)container.width) {
                maxx = container.getXPos() + (float)container.width;
            }
            if (maxy < container.getYPos() + (float)container.height) {
                maxy = container.getYPos() + (float)container.height;
            }
            ++loop;
        }
        float pad = 30.0f;
        Point[] tmp = new Point[]{new Point(minx - pad, miny - pad), new Point(maxx + pad, maxy + pad)};
        return tmp;
    }

    public ArrayList<StripsContainer> getContainers() {
        ArrayList<StripsContainer> returnArray = new ArrayList<StripsContainer>();
        int i = 0;
        while (i < this.nodes.size() && this.nodes.get(i) instanceof StripsContainer) {
            returnArray.add((StripsContainer)this.nodes.get(i));
            ++i;
        }
        return returnArray;
    }

    public ArrayList<StripsActionNode> getActionNodes() {
        ArrayList<StripsActionNode> returnArray = new ArrayList<StripsActionNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i) instanceof StripsActionNode) {
                returnArray.add((StripsActionNode)this.nodes.get(i));
            }
            ++i;
        }
        return returnArray;
    }

    public ArrayList<StripsVariableNode> getVariableNodes() {
        ArrayList<StripsVariableNode> returnArray = new ArrayList<StripsVariableNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i) instanceof StripsVariableNode) {
                returnArray.add((StripsVariableNode)this.nodes.get(i));
            }
            ++i;
        }
        return returnArray;
    }

    public StripsVariableNode getVariableNode(Object obj, int type) {
        Iterator<Node> itr = this.getNodes();
        while (itr.hasNext()) {
            Node n = itr.next();
            if (!(n instanceof StripsVariableNode) || !((StripsVariableNode)n).getVariable().equals(obj) || ((StripsVariableNode)n).getVariableType() != type) continue;
            return (StripsVariableNode)n;
        }
        return null;
    }

    public void variableUpdated(StripsVariableNode variable, ArrayList<String> removedValues) {
        ArrayList<StripsEdge> edges = new ArrayList<StripsEdge>();
        for (Edge edge : variable.getAllEdges()[1]) {
            edges.add((StripsEdge)edge);
        }
        for (Edge edge : variable.getSibling().getAllEdges()[0]) {
            edges.add((StripsEdge)edge);
        }
        for (StripsEdge stripsEdge : edges) {
            if (!stripsEdge.getCondition().removeEdge(stripsEdge, removedValues)) continue;
            ((StripsCanvas)this.canvas).deleteEnt(stripsEdge);
        }
        if (removedValues.contains(this.problem.getStartState().getValue(variable.getVariable()))) {
            this.problem.getStartState().setValue(variable.getVariable(), "  ---  ");
        }
        if (removedValues.contains(this.problem.getEndState().getValue(variable.getVariable()))) {
            this.problem.getEndState().setValue(variable.getVariable(), "  ---  ");
        }
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public void setDetailedDescription(String longDescription) {
        this.detailedDescription = longDescription;
    }
}

