/*
 * Decompiled with CFR 0.152.
 */
package AIspace.STRIPSToCSP;

import AIspace.STRIPSToCSP.StripsGraph;
import AIspace.STRIPSToCSP.StripsWindow;
import AIspace.STRIPSToCSP.dialogs.ActionEditDialog;
import AIspace.STRIPSToCSP.dialogs.StripsEdgeEditor;
import AIspace.STRIPSToCSP.dialogs.VariableEditDialog;
import AIspace.STRIPSToCSP.elements.StripsAction;
import AIspace.STRIPSToCSP.elements.StripsProblem;
import AIspace.STRIPSToCSP.elements.StripsVariable;
import AIspace.STRIPSToCSP.visualElements.StripsActionNode;
import AIspace.STRIPSToCSP.visualElements.StripsContainer;
import AIspace.STRIPSToCSP.visualElements.StripsEdge;
import AIspace.STRIPSToCSP.visualElements.StripsNode;
import AIspace.STRIPSToCSP.visualElements.StripsVariableNode;
import AIspace.cspTools.domains.DomainBoolean;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.elements.EdgeLabel;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFrame;

public class StripsCanvas
extends GraphCanvas {
    static final int C_CREATE_VARIABLE = 33491;
    static final int C_CREATE_ACTION = 33492;
    private int variableNumber = 1;
    private int actionNumber = 1;
    boolean resizing;
    private StripsProblem problem;

    public StripsCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.setFont(parent.getFont());
        this.problem = new StripsProblem();
        this.resizing = false;
        this.graph = new StripsGraph(this);
    }

    private void createVariable(java.awt.Point pointCreated) {
        Point temp = new Point((float)pointCreated.getX(), (float)pointCreated.getY());
        StripsVariable newVar = new StripsVariable(new DomainBoolean(), "Variable " + this.variableNumber);
        VariableEditDialog variableDialog = new VariableEditDialog((JFrame)((StripsWindow)this.parent), newVar);
        if (!variableDialog.isCancelled()) {
            this.problem.addVariable(newVar);
            StripsVariableNode newNode = new StripsVariableNode(this.graph, temp, 4292, newVar);
            this.graph.addNode(newNode);
            ++this.variableNumber;
        }
        this.updateGraph();
    }

    private void createAction(java.awt.Point pointCreated) {
        Point temp = new Point((float)pointCreated.getX(), (float)pointCreated.getY());
        StripsAction newAction = new StripsAction("Action " + this.actionNumber);
        ActionEditDialog actionDialog = new ActionEditDialog((JFrame)((StripsWindow)this.parent), newAction, true);
        if (!actionDialog.isCancelled()) {
            this.problem.addAction(newAction);
            StripsActionNode newNode = new StripsActionNode(this.graph, temp, newAction);
            this.graph.addNode(newNode);
            ++this.actionNumber;
        }
        this.updateGraph();
    }

    @Override
    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            this.pause();
            if (!this.inline) {
                if (ent.type == 7770) {
                    if (ent instanceof StripsVariableNode) {
                        VariableEditDialog varDialog = new VariableEditDialog((JFrame)((StripsWindow)this.parent), ((StripsVariableNode)ent).getVariable());
                        if (!varDialog.isCancelled() && varDialog.isDomainUpdated()) {
                            ((StripsGraph)this.graph).variableUpdated((StripsVariableNode)ent, varDialog.getRemovedValues());
                        }
                    } else if (ent instanceof StripsActionNode) {
                        new ActionEditDialog((JFrame)((StripsWindow)this.parent), ((StripsActionNode)ent).getAction(), false);
                    }
                    this.graph.updateNodeSize((Node)ent);
                } else if (ent.type == 7771) {
                    StripsEdgeEditor stripsEdgeEditor = new StripsEdgeEditor((JFrame)((StripsWindow)this.parent), (StripsEdge)ent);
                }
            }
            this.updateGraph();
            this.unpause();
        }
    }

    @Override
    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.makingEdge = 2;
                this.to = (Node)ent;
                if (!this.to.equals(this.from) && StripsEdge.edgeValid(this.from, this.to)) {
                    StripsEdge edge = new StripsEdge((StripsGraph)this.graph, this.from, this.to);
                    StripsEdgeEditor editor = new StripsEdgeEditor((JFrame)((StripsWindow)this.parent), edge);
                    this.graph.addEdge(edge);
                    if (editor.isCancelled()) {
                        ((StripsGraph)this.graph).deleteEdge(edge);
                    }
                }
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (Node)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p;
        Entity ent;
        if ((this.getSubmode() == 3331 || this.getSubmode() == 3333) && (ent = this.graph.searchEntities(p = new Point(e.getX(), e.getY()))) instanceof StripsContainer) {
            this.makingEdge = 0;
            return;
        }
        super.mousePressed(e);
        if (e.getModifiers() == 4) {
            return;
        }
        if (this.mode == 2220) {
            p = new Point(e.getX(), e.getY());
            ent = this.graph.searchEntities(p);
            if (ent == null) {
                return;
            }
            if (ent instanceof StripsContainer) {
                if (!((StripsContainer)ent).isActive()) {
                    this.repaint();
                    return;
                }
                if (((StripsContainer)ent).withinResizeArea(e)) {
                    this.resizing = true;
                    return;
                }
            }
            if (ent instanceof StripsNode) {
                if (!((StripsNode)ent).getContainer().isActive()) {
                    this.repaint();
                }
                return;
            }
            switch (this.submode) {
                case 33492: {
                    this.createAction(e.getPoint());
                    break;
                }
                case 33491: {
                    this.createVariable(e.getPoint());
                }
            }
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (ent instanceof StripsContainer) {
            return;
        }
        super.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizing = true;
        if (true) {
            this.resizing = false;
        }
    }

    public StripsProblem getProblem() {
        return this.problem;
    }

    public void setProblem(StripsProblem problem) {
        this.problem = problem;
        ((StripsGraph)this.graph).setProblem(problem);
    }

    private void printGraph() {
        Iterator<Node> nodeIter = this.graph.getNodes();
        while (nodeIter.hasNext()) {
            Node temp = nodeIter.next();
            if (temp instanceof StripsVariableNode) {
                StripsVariableNode tempVar = (StripsVariableNode)temp;
                System.out.println(tempVar.getLabel());
                System.out.println(String.valueOf(tempVar.getPos().x) + " " + tempVar.getPos().y);
            }
            if (temp instanceof StripsActionNode) {
                StripsActionNode tempAct = (StripsActionNode)temp;
                System.out.println(tempAct.getLabel());
                System.out.println(String.valueOf(tempAct.getPos().x) + " " + tempAct.getPos().y);
            }
            if (!(temp instanceof StripsContainer)) continue;
            StripsContainer tempCont = (StripsContainer)temp;
            System.out.println(tempCont.getLabel());
            System.out.println(String.valueOf(tempCont.getPos().x) + " " + tempCont.getPos().y);
        }
    }

    @Override
    public void updateGraph() {
        ((StripsGraph)this.graph).updateLabels();
        super.updateGraph();
        this.repaint();
    }

    @Override
    protected void mDraggedSelect() {
        if (this.resizing) {
            this.resizeContainerY((StripsContainer)this.hover, this.mDraggedPos.y - this.mPressedPos.y);
            this.mPressedPos = new Point(this.mDraggedPos.x, this.mDraggedPos.y);
        } else {
            if (!this.isDragging) {
                if (Math.abs(this.mPressedPos.x - this.mDraggedPos.x) > 5.0f || Math.abs(this.mPressedPos.y - this.mDraggedPos.y) > 5.0f) {
                    this.isDragging = true;
                    if (this.hover != null && this.hover.type == 7770) {
                        if (!(this.hover instanceof StripsContainer)) {
                            this.graph.order_bringToFront((Node)this.hover);
                        }
                        this.draggingDifX = ((Node)this.hover).getPos().x - this.mPressedPos.x;
                        this.draggingDifY = ((Node)this.hover).getPos().y - this.mPressedPos.y;
                    }
                }
                return;
            }
            if (this.hover != null && this.hover.type != 7771) {
                if (this.isMoving) {
                    switch (this.hover.type) {
                        case 7770: {
                            if (!(this.hover instanceof StripsContainer)) {
                                this.graph.order_bringToFront((Node)this.hover);
                            }
                            float offsetX = this.mDraggedPos.x + this.draggingDifX;
                            float offsetY = this.mDraggedPos.y + this.draggingDifY;
                            Point point = new Point(offsetX, offsetY);
                            this.graph.moveEntities(point, (Node)this.hover);
                            break;
                        }
                        case 7772: {
                            this.graph.moveLabel(this.mDraggedPos, (EdgeLabel)this.hover);
                        }
                    }
                } else if (this.isSelected) {
                    this.isDragging = true;
                    this.isMoving = true;
                }
            }
        }
        this.repaint();
    }

    private void resizeContainerY(StripsContainer container, float dy) {
        container.resizeY(dy);
        ArrayList<StripsContainer> containers = ((StripsGraph)this.graph).getContainers();
        for (StripsContainer con : containers) {
            if (container.getContainerType() == 99876 && con.getContainerType() == 99877) {
                con.resizeY(dy);
                continue;
            }
            if (container.getContainerType() != 99877 || con.getContainerType() != 99876) continue;
            con.resizeY(dy);
        }
    }

    @Override
    public void setSubmode(int newMode) {
        if (newMode == 33491) {
            ((StripsGraph)this.graph).makeActive(99876);
        } else if (newMode == 33492) {
            ((StripsGraph)this.graph).makeActive(99878);
        } else {
            this.setBackground(Color.white);
            ((StripsGraph)this.graph).makeDefaultActive();
        }
        super.setSubmode(newMode);
    }

    @Override
    public void drawPrint(Graphics2D g2) {
        if (this.isAntiAliasingEnabled()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setColor(Color.black);
        if (this.isDragging && !this.isMoving && this.mode != 2221) {
            g2.drawRect((int)Math.min(this.mPressedPos.x, this.mDraggedPos.x), (int)Math.min(this.mPressedPos.y, this.mDraggedPos.y), (int)Math.abs(this.mPressedPos.x - this.mDraggedPos.x), (int)Math.abs(this.mPressedPos.y - this.mDraggedPos.y));
        }
        if (this.makingEdge == 1 || this.makingEdge == 2) {
            ((StripsGraph)this.graph).drawContainers(g2, this.isMoving);
            g2.drawLine((int)this.from.pos.x, (int)this.from.pos.y, (int)this.mMovedPos.x, (int)this.mMovedPos.y);
            ((StripsGraph)this.graph).drawEdges(g2, this.isMoving);
            ((StripsGraph)this.graph).drawNodes(g2, this.isMoving);
        } else {
            this.graph.draw(g2, this.isMoving);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (ent instanceof StripsContainer) {
            if (((StripsContainer)ent).withinResizeArea(e)) {
                Cursor resizingCursor = new Cursor(8);
                this.setCursor(resizingCursor);
            } else {
                Cursor resizingCursor = new Cursor(0);
                this.setCursor(resizingCursor);
            }
        } else {
            Cursor resizingCursor = new Cursor(0);
            this.setCursor(resizingCursor);
        }
        super.mouseMoved(e);
    }

    @Override
    public void setGraph(Graph graph) {
        this.clearMouse();
        this.graph = graph;
        this.actionNumber = ((StripsGraph)graph).getActionNodes().size() + 1;
        this.variableNumber = ((StripsGraph)graph).getVariableNodes().size() / 2 + 1;
    }

    @Override
    public void reset() {
        this.graph = new StripsGraph(this);
        this.clearMouse();
        this.repaint();
        this.problem.reInitialize();
        this.variableNumber = 1;
        this.actionNumber = 1;
    }

    @Override
    protected void deleteEnt(Entity ent) {
        super.deleteEnt(ent);
    }
}

