/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint.elements;

import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.graphToolKit.Graph;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;

public class CnsConstraintEdge
extends ConstraintEdge {
    private boolean isOnQueue;
    private boolean isConsistent;
    private Stack<Boolean> oldOnQueueValues = new Stack();
    private ArrayList<StepInformation> stepHistory = new ArrayList();

    public CnsConstraintEdge(Constraint constraint, Graph graph, CSPVariable variable) {
        super(constraint, graph, variable);
    }

    public void saveStepInfo() {
        this.stepHistory.add(new StepInformation(this.isOnQueue, false));
    }

    public void setStepArc() {
        this.stepHistory.get((int)(this.stepHistory.size() - 1)).currentArc = true;
    }

    public boolean isCurrArc() {
        return this.stepHistory.get((int)(this.stepHistory.size() - 1)).currentArc;
    }

    public boolean stepback() {
        int lastElementIndex = this.stepHistory.size() - 1;
        if (lastElementIndex != 0) {
            this.stepHistory.remove(lastElementIndex);
        }
        if (this.stepHistory.get((int)(this.stepHistory.size() - 1)).isQueued) {
            this.isOnQueue = true;
        } else {
            this.isOnQueue = false;
            this.isConsistent = true;
        }
        this.setColor(true);
        return lastElementIndex == 0;
    }

    public void clearStepHistory() {
        this.stepHistory.clear();
    }

    public boolean isOnQueue() {
        return this.isOnQueue;
    }

    public void putOnQueue() {
        this.isOnQueue = true;
        this.setColor(true);
    }

    public void setConsistent(boolean bool) {
        this.isConsistent = bool;
        this.setColor(true);
    }

    public boolean getConsistent() {
        return this.isConsistent;
    }

    public void removeFromQueue() {
        this.isOnQueue = false;
        this.setColor(true);
    }

    public void pushOldQueueValue() {
        this.oldOnQueueValues.push(new Boolean(this.isOnQueue));
    }

    public void popOldQueueValue() {
        try {
            this.isOnQueue = this.oldOnQueueValues.pop();
            this.setColor(true);
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private void setColor(boolean solve) {
        this.color = !solve ? Color.black : (this.isOnQueue ? Color.blue : (this.isConsistent ? Color.green : Color.red));
    }

    public String printString() {
        return "( " + ((ConstraintVariable)this.end).getName() + ", " + this.start.toString() + " )";
    }

    class StepInformation {
        public boolean currentArc;
        public boolean isQueued;

        public StepInformation(boolean isQueued, boolean currentArc) {
            this.currentArc = currentArc;
            this.isQueued = isQueued;
        }
    }
}

