/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint;

import AIspace.Constraint.AutoAC;
import AIspace.Constraint.AutoFineStep;
import AIspace.Constraint.AutoSolve;
import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintWindow;
import AIspace.Constraint.InlineConstraintApplet;
import AIspace.Constraint.dialogs.SplitNodeDialog;
import AIspace.Constraint.elements.CnsConstraintEdge;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;

public class ConstraintCanvas
extends CSPcanvas {
    private boolean addNewLine = true;
    public AutoSolve autosolve;
    protected SplitNodeDialog backtrackDialog;
    protected AutoAC auto;
    protected AutoFineStep autoFS;
    protected int dt = 500;
    protected boolean splittable = true;
    protected int fineStepCount = 0;
    protected boolean showFS = true;
    protected boolean lastSolution = false;
    protected CnsConstraintEdge fineStepEdge;
    protected boolean lastStepWasStep = true;
    protected JMenuItem backTrackItem;
    protected JMenuItem stopItem;
    protected JMenuItem autoSolveItem;
    protected JMenuItem stepBackItem;
    protected JMenuItem fineStepItem;
    protected JMenuItem resetItem;
    protected JMenuItem autoACItem;
    protected JMenuItem stepItem;
    public int nextSolve = FIRST_SOLVE;
    public static int FIRST_SOLVE = 3;
    public static int FAIL_BACKTRACK = 4;
    public static int SOLUTION_BACKTRACK = 5;
    public static int SPLIT = 6;
    public static int NO_MORE_SOLUTIONS = 7;
    public static int FAIL_NO_MORE_SOLUTIONS = 8;
    public static int MORE_SOLUTION_SPLIT = 9;

    public ConstraintCanvas(Container parent, boolean inline, CSP csp) {
        super(parent, inline, csp);
        this.backTrackItem = new JMenuItem("Backtrack");
        this.backTrackItem.setActionCommand(this.backTrackItem.getText());
        this.backTrackItem.addActionListener(this);
        this.backTrackItem.setEnabled(false);
        this.stopItem = new JMenuItem("Stop");
        this.stopItem.setActionCommand(this.stopItem.getText());
        this.stopItem.addActionListener(this);
        this.stopItem.setEnabled(false);
        this.autoSolveItem = new JMenuItem("AutoSolve");
        this.autoSolveItem.setActionCommand(this.autoSolveItem.getText());
        this.autoSolveItem.addActionListener(this);
        this.autoSolveItem.setEnabled(true);
        this.stepBackItem = new JMenuItem("Step Back");
        this.stepBackItem.setActionCommand(this.stepBackItem.getText());
        this.stepBackItem.addActionListener(this);
        this.stepBackItem.setEnabled(false);
    }

    @Override
    protected void popupSCanv() {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
        this.fineStepItem = new JMenuItem("Fine Step");
        this.fineStepItem.setActionCommand(this.fineStepItem.getText());
        this.fineStepItem.addActionListener(this);
        this.pop.add(this.fineStepItem);
        this.stepItem = new JMenuItem("Step");
        this.stepItem.setActionCommand(this.stepItem.getText());
        this.stepItem.addActionListener(this);
        this.pop.add(this.stepItem);
        this.autoACItem = new JMenuItem("Auto Arc-Consistency");
        this.autoACItem.setActionCommand(this.autoACItem.getText());
        this.autoACItem.addActionListener(this);
        this.pop.add(this.autoACItem);
        this.pop.add(this.autoSolveItem);
        this.pop.add(this.stopItem);
        this.pop.add(this.stepBackItem);
        this.pop.add(this.backTrackItem);
        this.resetItem = new JMenuItem("Reset");
        this.resetItem.setActionCommand(this.resetItem.getText());
        this.resetItem.addActionListener(this);
        this.pop.add(this.resetItem);
        this.pop.addSeparator();
        this.popupStands();
    }

    @Override
    protected void popupSCns(int x, int y) {
    }

    protected void popupEdgeSCns(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Constraint Options"));
        JMenuItem mItem = new JMenuItem("Make Consistent");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    @Override
    protected void popupEdge(int x, int y) {
        if (this.mode == 2221) {
            this.popupEdgeSCns(x, y);
        }
    }

    public void setSplittable(boolean split) {
        this.splittable = split;
    }

    @Override
    public void setSpeed(int speed) {
        this.dt = speed;
        if (this.auto != null) {
            this.auto.delayTime = speed;
        }
        if (this.autoFS != null) {
            this.autoFS.dt = speed;
        }
    }

    @Override
    public int getSpeed() {
        return this.dt;
    }

    private void makeConsistent(CnsConstraintEdge edge) {
        boolean inconsistent = this.stepOne(edge);
        edge.setConsistent(!inconsistent);
        if (inconsistent) {
            this.stepTwo(edge);
            this.stepThree(edge);
        }
    }

    public void stepback() {
        if (((ConstraintCSP)this.csp).stepBack()) {
            this.stepBackItem.setEnabled(false);
            ((ConstraintWindow)this.parent).getSolveButtonAt(6).setEnabled(false);
        }
    }

    public boolean step() {
        if (this.autoFSAlive()) {
            return false;
        }
        if (this.fineStepEdge != null) {
            while (this.fineStepCount != 0) {
                this.fineStep(this.fineStepEdge);
            }
            this.fineStepEdge = null;
            this.repaint();
            return false;
        }
        this.lastStepWasStep = true;
        for (CnsConstraintEdge cnsConstraintEdge : ((ConstraintCSP)this.csp).getConstraintEdges()) {
            if (!cnsConstraintEdge.isOnQueue()) continue;
            if (this.showFS) {
                this.autoFS(cnsConstraintEdge);
            } else {
                this.makeConsistent(cnsConstraintEdge);
            }
            return false;
        }
        return true;
    }

    protected boolean stepOne(CnsConstraintEdge edge) {
        edge.removeFromQueue();
        CSPVariable var = edge.getVariable();
        Constraint constraint = edge.getConstraint();
        DomainDiscrete dom = var.getDomain();
        int[] split = dom.getSplitElements();
        boolean changed = false;
        int index = constraint.index(var);
        int j = 0;
        while (j < split.length) {
            if (!constraint.viable(index, split[j])) {
                changed = true;
            }
            ++j;
        }
        return changed;
    }

    protected void stepTwo(CnsConstraintEdge edge) {
        ConstraintVariable var = (ConstraintVariable)edge.getVariable();
        Constraint cns = edge.getConstraint();
        for (Constraint constraint : this.csp.getConstraints()) {
            if (!constraint.containsVariable(var) || cns.equals(constraint)) continue;
            for (ConstraintEdge e : constraint.getConstraintEdges()) {
                CnsConstraintEdge newedge = (CnsConstraintEdge)e;
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.xw = this.graph.getLineWidth() + 1;
            }
        }
    }

    protected void stepThree(CnsConstraintEdge edge) {
        CSPVariable var = edge.getVariable();
        Constraint cns = edge.getConstraint();
        DomainDiscrete dom = var.getDomain();
        int[] split = dom.getSplitElements();
        int index = cns.index(var);
        int i = 0;
        ArrayList<Integer> removedElements = new ArrayList<Integer>();
        int j = 0;
        while (j < split.length) {
            if (!cns.viable(index, split[j])) {
                removedElements.add(new Integer(split[j]));
                dom.hide(i);
            } else {
                ++i;
            }
            ++j;
        }
        if (removedElements.size() == 1) {
            if (this.inline) {
                ((InlineConstraintApplet)this.parent).setPromptLabel(String.valueOf(dom.getElementString((Integer)removedElements.get(0))) + " removed from the domain of " + var.getName() + " because of arc " + edge.printString() + "\n");
            } else {
                ((ConstraintWindow)this.parent).setPromptLabel(String.valueOf(dom.getElementString((Integer)removedElements.get(0))) + " removed from the domain of " + var.getName() + " because of arc " + edge.printString() + "\n");
            }
        } else if (removedElements.size() > 1) {
            String removedString = "";
            int j2 = 0;
            while (j2 < removedElements.size()) {
                removedString = String.valueOf(removedString) + dom.getElementString((Integer)removedElements.get(j2)) + " ";
                ++j2;
            }
            if (this.inline) {
                ((InlineConstraintApplet)this.parent).setPromptLabel(String.valueOf(removedString) + " removed from the domain of " + var.getName() + " because of arc " + edge.printString() + "\n");
            } else {
                ((ConstraintWindow)this.parent).setPromptLabel(String.valueOf(removedString) + " removed from the domain of " + var.getName() + " because of arc " + edge.printString() + "\n");
            }
        }
        edge.setConsistent(true);
        var.setLabel();
        for (Constraint constraint : this.csp.getConstraints()) {
            if (!constraint.containsVariable(var) || cns.equals(constraint)) continue;
            for (ConstraintEdge e : constraint.getConstraintEdges()) {
                CnsConstraintEdge newedge = (CnsConstraintEdge)e;
                if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                newedge.putOnQueue();
                newedge.xw = 0;
            }
        }
    }

    public boolean fineStep(CnsConstraintEdge edge) {
        this.lastStepWasStep = false;
        if (this.fineStepCount == 0) {
            ((ConstraintWindow)this.parent).getSolveButtonAt(5).setEnabled(false);
            this.stepBackItem.setEnabled(false);
            ((ConstraintWindow)this.parent).setPromptLabel("Selected arc: " + edge.printString());
            edge.xw = this.graph.getLineWidth() + 1;
            ++this.fineStepCount;
        } else if (this.fineStepCount == 1) {
            edge.removeFromQueue();
            boolean inconsistent = this.stepOne(edge);
            edge.setConsistent(!inconsistent);
            if (!inconsistent) {
                ((ConstraintWindow)this.parent).setPromptLabel("Arc " + edge.printString() + " is consistent");
                this.fineStepCount = 0;
                edge.xw = 0;
                ((ConstraintCSP)this.csp).saveStepInfo();
                ((ConstraintWindow)this.parent).getSolveButtonAt(5).setEnabled(true);
                this.stepBackItem.setEnabled(true);
                edge.setStepArc();
                return false;
            }
            ((ConstraintWindow)this.parent).getSolveButtonAt(5).setEnabled(false);
            this.stepBackItem.setEnabled(false);
            ((ConstraintWindow)this.parent).setPromptLabel("Arc " + edge.printString() + " is inconsistent");
            ++this.fineStepCount;
            this.stepTwo(edge);
            ++this.fineStepCount;
        } else if (this.fineStepCount == 2) {
            ((ConstraintWindow)this.parent).getSolveButtonAt(5).setEnabled(false);
            this.stepBackItem.setEnabled(false);
            this.stepTwo(edge);
            ++this.fineStepCount;
        } else if (this.fineStepCount == 3) {
            edge.xw = 0;
            this.stepThree(edge);
            ((ConstraintWindow)this.parent).getSolveButtonAt(5).setEnabled(true);
            this.stepBackItem.setEnabled(true);
            ((ConstraintCSP)this.csp).saveStepInfo();
            edge.setStepArc();
            this.fineStepCount = 0;
            return false;
        }
        return true;
    }

    public boolean fineStep() {
        if (this.autoFSAlive()) {
            return false;
        }
        if (this.fineStepEdge != null) {
            this.fineStep(this.fineStepEdge);
            if (this.fineStepCount == 0) {
                this.fineStepEdge = null;
            }
            return false;
        }
        for (ConstraintEdge e : this.csp.getConstraintEdges()) {
            CnsConstraintEdge fineEdge = (CnsConstraintEdge)e;
            if (!fineEdge.isOnQueue()) continue;
            this.fineStepEdge = fineEdge;
            this.fineStep();
            return false;
        }
        return true;
    }

    public void autoAC() {
        ((ConstraintWindow)this.parent).setButtonsForAutoAC(true);
        this.auto = new AutoAC(this, this.dt, (ConstraintCSP)this.csp);
        ((ConstraintWindow)this.parent).setPromptLabel("Running auto arc-consistency...");
        this.auto.start();
    }

    public void stopAC() {
        ((ConstraintWindow)this.parent).setButtonsForAutoAC(false);
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
        ((ConstraintWindow)this.parent).setPromptLabel("Stopped auto arc-consistency");
    }

    public void doneAC() {
        ((ConstraintWindow)this.parent).setButtonsForAutoAC(false);
        ((ConstraintWindow)this.parent).setACButtons(false);
        ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(true);
        this.autoSolveItem.setEnabled(true);
        ((ConstraintWindow)this.parent).getSolveButtonAt(4).setEnabled(false);
        this.stopItem.setEnabled(false);
        ((ConstraintWindow)this.parent).getSolveButtonAt(8).setSelected(true);
        int solutionsReturn = this.checkSolutions();
        if (solutionsReturn == MORE_SOLUTION_SPLIT) {
            ((ConstraintWindow)this.parent).setPromptLabel("Auto arc-consistency finished.\nClick on a variable to split its domain and try again.");
        } else if (solutionsReturn == NO_MORE_SOLUTIONS) {
            this.ACSolve();
        }
        this.fineStepEdge = null;
        this.repaint();
    }

    public void ACSolve() {
        if (!((ConstraintWindow)this.parent).domainSplit) {
            this.printSolutions();
            this.setNextSolve(NO_MORE_SOLUTIONS);
            this.lastSolution = false;
        } else {
            this.setNextSolve(SOLUTION_BACKTRACK);
        }
    }

    public void setNextSolve(int flag) {
        if (flag == NO_MORE_SOLUTIONS && this.nextSolve != NO_MORE_SOLUTIONS && this.nextSolve != FAIL_NO_MORE_SOLUTIONS) {
            this.lastSolution = true;
        }
        this.nextSolve = flag;
    }

    public int getNextSolve() {
        return this.nextSolve;
    }

    public void autoSolve() {
        this.addNewLine = true;
        this.autosolve = new AutoSolve(this, this.dt, (ConstraintCSP)this.csp);
        this.autosolve.start();
        if (!this.inline) {
            ((ConstraintWindow)this.parent).setPromptLabel("Auto solving...");
        } else {
            ((InlineConstraintApplet)this.parent).setPromptLabel("Auto solving...");
        }
    }

    public void stopSolving() {
        if (this.autosolve == null) {
            return;
        }
        if (this.autosolve.isAlive()) {
            this.autosolve.quit();
        }
        if (this.inline) {
            ((InlineConstraintApplet)this.parent).setPromptLabel("Stopped auto solve.");
        } else {
            ((ConstraintWindow)this.parent).setPromptLabel("Stopped auto solve.");
        }
    }

    public void doneAutoSolve() {
        this.checkSolutions();
        ((ConstraintWindow)this.parent).setACButtons(false);
        ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(true);
        this.autoSolveItem.setEnabled(true);
        ((ConstraintWindow)this.parent).getSolveButtonAt(4).setEnabled(false);
        this.stopItem.setEnabled(false);
        ((ConstraintWindow)this.parent).getSolveButtonAt(8).setSelected(true);
        if (!this.lastSolution && this.nextSolve == NO_MORE_SOLUTIONS) {
            ((ConstraintWindow)this.parent).setPromptLabel("No more solutions.");
        } else if (this.nextSolve == FAIL_NO_MORE_SOLUTIONS) {
            this.lastSolution = false;
            ((ConstraintWindow)this.parent).setPromptLabel("No solution found. No more solutions.");
            this.setNextSolve(NO_MORE_SOLUTIONS);
        } else {
            this.lastSolution = false;
            ((ConstraintWindow)this.parent).setPromptLabel("Solution found.\nClick AutoSolve again to find more solutions.");
        }
        this.repaint();
    }

    public boolean printSolutions() {
        StringBuffer solution = new StringBuffer();
        ArrayList<CSPVariable> variables = ((ConstraintWindow)this.parent).returnCSP().getVariables();
        boolean case3 = false;
        for (CSPVariable currVar : variables) {
            solution.append(" ").append(currVar.getName()).append(" = ").append(currVar.getDomain().getSplitRep()).append(",");
            if (currVar.getDomain().getVisibleDomainSize() == 0) {
                return false;
            }
            if (currVar.getDomain().getVisibleDomainSize() <= 1) continue;
            case3 = true;
        }
        if (case3) {
            return false;
        }
        solution.deleteCharAt(solution.lastIndexOf(","));
        if (this.addNewLine) {
            ((ConstraintWindow)this.parent).textArea.append("\n");
        }
        ((ConstraintWindow)this.parent).textArea.append("Solution found: " + solution + "\n");
        this.addNewLine = false;
        return true;
    }

    public int checkSolutionsforAutoSolve() {
        ArrayList<CSPVariable> variables = ((ConstraintWindow)this.parent).returnCSP().getVariables();
        boolean isCase3 = false;
        for (CSPVariable currVar : variables) {
            if (currVar.getDomain().getVisibleDomainSize() == 0) {
                ((ConstraintWindow)this.parent).textArea.append("\n");
                int i = 0;
                while (i < ((ConstraintWindow)this.parent).getIndent()) {
                    ((ConstraintWindow)this.parent).textArea.append("    ");
                    ++i;
                }
                ((ConstraintWindow)this.parent).textArea.append("Cannot split variable " + currVar.getName());
                if (((ConstraintWindow)this.parent).hasMoreSplits()) {
                    return FAIL_BACKTRACK;
                }
                return FAIL_NO_MORE_SOLUTIONS;
            }
            if (currVar.getDomain().getVisibleDomainSize() <= 1) continue;
            isCase3 = true;
        }
        if (isCase3) {
            return SPLIT;
        }
        if (((ConstraintWindow)this.parent).hasMoreSplits()) {
            return SOLUTION_BACKTRACK;
        }
        return NO_MORE_SOLUTIONS;
    }

    public int checkSolutions() {
        StringBuffer solution = new StringBuffer();
        ArrayList<CSPVariable> variables = ((ConstraintWindow)this.parent).returnCSP().getVariables();
        boolean case3 = false;
        for (CSPVariable currVar : variables) {
            solution.append(" ").append(currVar.getName()).append(" = ").append(currVar.getDomain().getSplitRep()).append(",");
            if (currVar.getDomain().getVisibleDomainSize() == 0) {
                if (((ConstraintWindow)this.parent).hasMoreSplits()) {
                    ((ConstraintWindow)this.parent).setPromptLabel("No solution, backtrack and try solving again");
                } else {
                    ((ConstraintWindow)this.parent).setPromptLabel("No solution");
                }
                ((ConstraintWindow)this.parent).setACButtons(false);
                if (((ConstraintWindow)this.parent).domainSplit) {
                    ((ConstraintWindow)this.parent).textArea.append("\n");
                    int i = 0;
                    while (i < ((ConstraintWindow)this.parent).getIndent()) {
                        ((ConstraintWindow)this.parent).textArea.append("    ");
                        ++i;
                    }
                    ((ConstraintWindow)this.parent).textArea.append("Cannot split variable " + currVar.getName());
                }
                return FAIL_NO_MORE_SOLUTIONS;
            }
            if (currVar.getDomain().getVisibleDomainSize() <= 1) continue;
            case3 = true;
        }
        if (case3) {
            ((ConstraintWindow)this.parent).setPromptLabel("Click on a variable to split its domain and try again.");
            ((ConstraintWindow)this.parent).setACButtons(false);
            return MORE_SOLUTION_SPLIT;
        }
        solution.deleteCharAt(solution.lastIndexOf(","));
        ((ConstraintWindow)this.parent).setPromptLabel("Solution found: " + solution);
        if (((ConstraintWindow)this.parent).domainSplit) {
            ((ConstraintWindow)this.parent).textArea.append("\n");
            int i = 0;
            while (i < ((ConstraintWindow)this.parent).getIndent()) {
                ((ConstraintWindow)this.parent).textArea.append("    ");
                ++i;
            }
            ((ConstraintWindow)this.parent).textArea.append("Solution found: " + solution);
        }
        return NO_MORE_SOLUTIONS;
    }

    public void autoFS(CnsConstraintEdge edge) {
        this.fineStepCount = 0;
        if (this.fineStepEdge != null) {
            this.fineStepEdge.putOnQueue();
            this.fineStepEdge.xw = 0;
            CSPVariable var = this.fineStepEdge.getVariable();
            Constraint cns = this.fineStepEdge.getConstraint();
            for (Constraint constraint : this.csp.getConstraints()) {
                if (!constraint.containsVariable(var) || cns.equals(constraint)) continue;
                for (ConstraintEdge e : constraint.getConstraintEdges()) {
                    CnsConstraintEdge newedge = (CnsConstraintEdge)e;
                    if (newedge.getVariable().equals(var) || newedge.isOnQueue()) continue;
                    newedge.xw = 0;
                }
            }
            this.fineStepEdge = null;
        }
        this.autoFS = new AutoFineStep(this, this.dt, edge);
        this.autoFS.start();
    }

    public void stopFS() {
        if (this.autoFS == null) {
            return;
        }
        if (this.autoFS.isAlive()) {
            this.autoFS.quit();
        }
    }

    public boolean autoFSAlive() {
        if (this.autoFS == null) {
            return false;
        }
        return this.autoFS.isAlive();
    }

    public void showFS(boolean bool) {
        this.showFS = bool;
    }

    public ConstraintVariable backtrack() {
        ConstraintVariable node = null;
        try {
            node = ((ConstraintCSP)this.csp).revertNodes();
            this.setNextSolve(SPLIT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
        return node;
    }

    public void resetCSP() {
        ((ConstraintCSP)this.csp).resetNodes();
        this.fineStepCount = 0;
        if (this.mode == 2221) {
            if (this.inline) {
                ((InlineConstraintApplet)this.parent).setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
            } else {
                ((ConstraintWindow)this.parent).setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
            }
        }
        this.stepBackItem.setEnabled(false);
        this.backTrackItem.setEnabled(false);
        this.repaint();
    }

    @Override
    public void changeFont(int size) {
        super.changeFont(size);
        ((ConstraintWindow)this.parent).textArea.setFont(new Font("SansSerif", 0, this.font.getSize()));
    }

    @Override
    public void disposeWindows() {
        super.disposeWindows();
        if (this.backtrackDialog != null) {
            this.backtrackDialog.dispose();
        }
        if (this.nDialog != null) {
            this.nDialog.dispose();
        }
        if (this.eDialog != null) {
            this.eDialog.dispose();
        }
    }

    protected void splitDomain(ConstraintVariable node) {
        this.backtrackDialog = new SplitNodeDialog(this);
        this.backtrackDialog.open(node, (ConstraintCSP)this.csp);
        if (!this.backtrackDialog.isCancelled()) {
            ((ConstraintWindow)this.parent).setACButtons(true);
            ((ConstraintWindow)this.parent).domainSplittingOccurred(node);
        }
        this.repaint();
    }

    public void enableBacktrack(boolean isEnabled) {
        this.backTrackItem.setEnabled(isEnabled);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.entClicked == null && !e.isControlDown() && !e.isShiftDown()) {
            this.graph.deselectAll();
            if (this.pop.isVisible()) {
                this.pop.setVisible(false);
                return;
            }
        }
        if (this.pause) {
            return;
        }
        super.mouseClicked(e);
        if (e.getModifiers() == 4 || this.entClicked == null) {
            return;
        }
        if (this.mode == 2221 && this.entClicked.type == 7770) {
            if (this.autoFSAlive()) {
                return;
            }
            if (this.auto != null && this.auto.isAlive()) {
                return;
            }
            this.pause();
            if (this.entClicked instanceof ConstraintVariable) {
                ConstraintVariable tmpNode = (ConstraintVariable)this.entClicked;
                if (this.splittable) {
                    if (this.inline) {
                        if (((InlineConstraintApplet)this.parent).domainSplitClick) {
                            this.splitDomain(tmpNode);
                        }
                    } else {
                        this.splitDomain(tmpNode);
                    }
                }
            } else if (this.entClicked instanceof Constraint) {
                if (this.inline) {
                    if (((InlineConstraintApplet)this.parent).constraintPropertyClick) {
                        this.inspectConstraint((Constraint)this.entClicked);
                    }
                } else {
                    this.inspectConstraint((Constraint)this.entClicked);
                }
            }
            this.unpause();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.autoFSAlive() || this.pause) {
            return;
        }
        super.mousePressed(e);
        Entity ent = this.graph.searchEntities(new Point(e.getX(), e.getY()));
        if (e.getModifiers() == 4) {
            return;
        }
        if (this.mode == 2221 && ent != null && ent instanceof CnsConstraintEdge) {
            CnsConstraintEdge edge = (CnsConstraintEdge)ent;
            if (edge.isOnQueue()) {
                if (this.showFS) {
                    this.autoFS(edge);
                } else {
                    this.makeConsistent(edge);
                    if (((ConstraintCSP)this.csp).isQueueEmpty()) {
                        this.checkSolutions();
                    }
                }
                this.repaint();
            } else if (((ConstraintCSP)this.csp).isQueueEmpty()) {
                this.checkSolutions();
            }
        }
        this.repaint();
    }

    @Override
    protected void aSolvePerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (this.autoFSAlive() && !arg.equals("Stop") && !arg.equals("Reset")) {
            return;
        }
        if (arg.equals("Split Domain")) {
            this.splitDomain((ConstraintVariable)this.entClicked);
        } else if (arg.equals("Make Consistent")) {
            if (this.entClicked instanceof CnsConstraintEdge) {
                CnsConstraintEdge edge = (CnsConstraintEdge)this.entClicked;
                if (edge.isOnQueue()) {
                    if (this.showFS) {
                        this.autoFS(edge);
                    } else {
                        this.makeConsistent(edge);
                    }
                    this.repaint();
                }
            } else {
                Constraint constraint = (Constraint)this.entClicked;
                for (CnsConstraintEdge cnsConstraintEdge : constraint.getAllEdges()[1]) {
                    if (!cnsConstraintEdge.isOnQueue()) continue;
                    if (this.showFS) {
                        this.autoFS(cnsConstraintEdge);
                    } else {
                        this.makeConsistent(cnsConstraintEdge);
                    }
                    this.repaint();
                }
            }
        } else if (arg.equals("Auto Arc-Consistency")) {
            this.stopItem.setEnabled(true);
            ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(false);
            this.autoSolveItem.setEnabled(false);
            this.autoACItem.setEnabled(false);
            ((ConstraintWindow)this.parent).getSolveButtonAt(2).setSelected(true);
            ((ConstraintWindow)this.parent).getSolveButtonAt(4).setEnabled(true);
            this.autoAC();
        } else if (arg.equals("AutoSolve")) {
            ((ConstraintWindow)this.parent).setButtonsForAutoAC(true);
            this.stopItem.setEnabled(true);
            ((ConstraintWindow)this.parent).getSolveButtonAt(3).setSelected(true);
            ((ConstraintWindow)this.parent).getSolveButtonAt(4).setEnabled(true);
            this.autoSolve();
        } else if (arg.equals("Step")) {
            ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(false);
            this.autoSolveItem.setEnabled(false);
            if (!this.step()) {
                ((ConstraintWindow)this.parent).setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
                ((ConstraintWindow)this.parent).getSolveButtonAt(1).setSelected(true);
                this.repaint();
                ((ConstraintWindow)this.parent).getSolveButtonAt(8).setSelected(true);
            } else {
                this.checkSolutions();
            }
        } else if (arg.equals("Fine Step")) {
            ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(false);
            this.autoSolveItem.setEnabled(false);
            if (!this.fineStep()) {
                ((ConstraintWindow)this.parent).getSolveButtonAt(0).setSelected(true);
                this.repaint();
                ((ConstraintWindow)this.parent).getSolveButtonAt(8).setSelected(true);
            } else {
                this.checkSolutions();
            }
        } else if (arg.equals("Stop")) {
            ((ConstraintWindow)this.parent).setButtonsForAutoAC(false);
            this.stopItem.setEnabled(false);
            ((ConstraintWindow)this.parent).getSolveButtonAt(4).setEnabled(false);
            if (this.autosolve != null) {
                this.stopSolving();
                ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(false);
                this.autoSolveItem.setEnabled(false);
            }
            if (this.auto != null) {
                this.stopAC();
            }
            this.repaint();
        } else if (arg.equals("Step Back")) {
            this.stepback();
            this.repaint();
            ((ConstraintWindow)this.parent).getSolveButtonAt(8).setSelected(true);
        } else if (arg.equals("Backtrack")) {
            ((ConstraintWindow)this.parent).backtrackingOccurred(this.backtrack(), true);
        } else if (arg.equals("Reset")) {
            this.stopSolving();
            this.stopAC();
            ((ConstraintWindow)this.parent).getSolveButtonAt(4).setEnabled(false);
            this.stopItem.setEnabled(false);
            ((ConstraintWindow)this.parent).getSolveButtonAt(3).setEnabled(false);
            this.autoSolveItem.setEnabled(false);
            while (this.auto != null && this.auto.isAlive() || this.autosolve != null && this.autosolve.isAlive()) {
            }
            ((ConstraintWindow)this.parent).resetWindow();
            this.repaint();
        }
        this.graph.deselectAll();
        super.aSolvePerformed(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.pause || this.mode == 2221) {
            return;
        }
        super.keyPressed(e);
        int arg = e.getKeyCode();
        if (arg == 32 || arg == 10 || arg == 83) {
            if (this.lastStepWasStep) {
                this.step();
            } else {
                this.fineStep();
            }
            this.repaint();
        }
    }
}

