/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search.elements;

import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.search.SearchCanvas;
import AIspace.search.SearchGraph;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class SearchNode
extends Node {
    public static final int REGULAR_NODE = 0;
    public static final int START_NODE = 1;
    public static final int GOAL_NODE = 2;
    public static final int CURRENT_NODE = 3;
    public static final int FRONTIER_NODE = 4;
    public static final int CHILDREN_NODE = 5;
    public static final int NON_CURRENT_NODE = 6;
    protected ArrayList<SearchNode> neighbours = new ArrayList(5);
    protected ArrayList<SearchNode> oldNeighbours;
    protected int nodeType = 0;
    protected int nodeSearchType = 6;
    protected int currNeighbour;
    protected double heuristics = 0.0;
    protected String searchOrder = "";
    protected String predicateLabel = this.getLabel();
    protected double distance = 0.0;
    protected boolean isSearchOrderDisplayed = false;
    protected boolean isPathFound = false;
    protected boolean isDrawnShadowed = false;

    public SearchNode(SearchGraph graph) {
        super(graph);
        this.hPad = 7;
        this.wPad = 7;
        this.updateSize();
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public double getNodeHeuristics() {
        return this.heuristics;
    }

    public void setNodeType(int type) {
        this.nodeType = type;
    }

    public int getNodeSearchType() {
        return this.nodeSearchType;
    }

    public void setNodeSearchType(int type) {
        this.nodeSearchType = type;
    }

    public boolean isPathFound() {
        return this.isPathFound;
    }

    public void setPathFound(boolean isFound) {
        this.isPathFound = isFound;
    }

    public boolean isDrawnShadowed() {
        return this.isDrawnShadowed;
    }

    public void setDrawnShadowed(boolean isDrawnShadowed) {
        this.isDrawnShadowed = isDrawnShadowed;
    }

    public int numNeighbours() {
        return this.neighbours.size();
    }

    public ArrayList getOldNeighbours() {
        return this.oldNeighbours;
    }

    public void addOldNeighbour(SearchNode node) {
        if (!this.oldNeighbours.contains(node)) {
            this.oldNeighbours.add(node);
        }
    }

    public void setOldNeighbours(ArrayList<SearchNode> neigh) {
        this.oldNeighbours = neigh;
    }

    public int getFirstNeighbour() {
        if (this.neighbours.size() == 0) {
            return -1;
        }
        this.currNeighbour = 1;
        return this.neighbours.get(0).getIndex();
    }

    public int getNextNeighbour() {
        if (this.currNeighbour >= this.neighbours.size()) {
            return -1;
        }
        return this.neighbours.get(this.currNeighbour++).getIndex();
    }

    public void setChild(SearchNode child) {
        if (!this.neighbours.contains(child)) {
            this.neighbours.add(child);
        }
    }

    public ArrayList<SearchNode> getChildren() {
        return this.neighbours;
    }

    public void addChildren(ArrayList<SearchNode> children) {
        this.neighbours = new ArrayList<SearchNode>(children);
    }

    public void clearChild(SearchNode child) {
        this.neighbours.remove(child);
    }

    @Override
    public void removeEdgesOut(Edge e) {
        this.edgesOut.remove(e);
        this.clearChild((SearchNode)e.end);
    }

    public void setHeuristics(double h) {
        DecimalFormat twoDigits = new DecimalFormat("###,###.####");
        this.heuristics = Double.parseDouble(twoDigits.format(h));
        this.label[1] = String.valueOf(this.heuristics);
    }

    public double getHeuristics() {
        return this.heuristics;
    }

    public String getDecimalFormat() {
        String decimalFormat = new String("###,###.####");
        return decimalFormat;
    }

    public void setDistance(double d) {
        this.distance = d / (double)this.graph.getScale();
    }

    public double getDistance() {
        return this.distance;
    }

    public void setSearchOrder(int order) {
        this.searchOrder = this.searchOrder.equals("") ? String.valueOf(this.searchOrder) + order : String.valueOf(this.searchOrder) + ", " + order;
    }

    public void resetSearchOrder() {
        this.searchOrder = "";
    }

    public void setSearchOrderDisplayed(boolean value) {
        this.isSearchOrderDisplayed = value;
    }

    public boolean isSearchOrderDisplayed() {
        return this.isSearchOrderDisplayed;
    }

    public String getPredicateLabel() {
        return this.predicateLabel;
    }

    public void setPredicateLabel(String l) {
        this.label[0] = this.predicateLabel = l;
    }

    public void setNodeAppearance(int type) {
        this.shape = 1113;
        switch (type) {
            case 1: {
                this.setHeavy(false);
                this.internalColor = Color.decode("#C8A2C8");
                break;
            }
            case 2: {
                this.setHeavy(false);
                this.internalColor = Color.yellow;
                break;
            }
            case 0: {
                this.setHeavy(false);
                this.internalColor = Color.white;
                break;
            }
            case 3: {
                this.setHeavy(true);
                this.color = Color.red;
                break;
            }
            case 4: {
                this.setHeavy(true);
                this.color = Color.green;
                break;
            }
            case 5: {
                this.setHeavy(true);
                this.color = Color.blue;
                break;
            }
            case 6: {
                this.setHeavy(false);
                this.color = Color.black;
                break;
            }
            default: {
                this.color = Color.black;
                this.setHeavy(false);
            }
        }
    }

    public int getNodeAppearance() {
        if (this.internalColor == Color.orange && !this.isHeavy) {
            return 1;
        }
        if (this.internalColor == Color.yellow && !this.isHeavy) {
            return 2;
        }
        if (this.internalColor == Color.white && !this.isHeavy) {
            return 0;
        }
        if (this.color == Color.red && this.isHeavy) {
            return 3;
        }
        if (this.color == Color.green && this.isHeavy) {
            return 4;
        }
        if (this.color == Color.blue && this.isHeavy) {
            return 5;
        }
        if (this.color == Color.black && !this.isHeavy) {
            return 6;
        }
        return -1;
    }

    @Override
    public void draw(Graphics graphics, boolean moving) {
        if (this.isSearchOrderDisplayed && this.color.equals(Color.black)) {
            this.setHeavy(true);
            this.color = Color.gray;
        }
        if (this.isDrawnShadowed) {
            Color tempInternalColor = this.internalColor;
            this.internalColor = Color.GRAY;
            Color tempColor = this.color;
            this.color = Color.GRAY;
            this.pos.translate(5.0f, 5.0f);
            super.draw(graphics, moving);
            this.internalColor = tempInternalColor;
            this.color = tempColor;
            this.pos.translate(-5.0f, -5.0f);
        }
        super.draw(graphics, moving);
        if (this.isSearchOrderDisplayed && ((SearchGraph)this.graph).getShowNum()) {
            FontMetrics fm = graphics.getFontMetrics();
            double lx = (double)this.pos.x + (double)this.width / 2.0;
            double ly = (double)this.pos.y - (double)this.height / 2.0 - 2.0 - (double)fm.getDescent();
            graphics.setColor(Color.red);
            graphics.drawString(new String(this.searchOrder), (int)lx, (int)ly);
        }
        if (this.isSelected && !moving || this.graph.canvas.getSubmode() == 3335) {
            graphics.setColor(Color.magenta);
            graphics.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
            graphics.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
            graphics.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
            graphics.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
        }
    }

    public void updateProperties(String label, double h) {
        this.setPredicateLabel(label);
        this.setHeuristics(h);
        this.updateSize();
    }

    @Override
    protected int getWidth() {
        if (((SearchCanvas)this.graph.canvas).isDisplayingHeuristics()) {
            FontMetrics fm = this.graph.canvas.getFontMetrics();
            int width1 = fm.stringWidth(this.label[0]) + this.wPad;
            int width2 = fm.stringWidth(this.label[1]) + this.wPad;
            return Math.max(width1, width2);
        }
        return super.getWidth();
    }

    @Override
    protected int getHeight() {
        if (((SearchCanvas)this.graph.canvas).isDisplayingHeuristics()) {
            return this.graph.canvas.getFontMetrics().getHeight() * 2 + this.hPad;
        }
        return super.getHeight();
    }

    @Override
    protected void drawLabel(Graphics offscreen) {
        if (((SearchCanvas)this.graph.canvas).isDisplayingHeuristics()) {
            FontMetrics fm = this.graph.canvas.getFontMetrics();
            int width1 = fm.stringWidth(this.label[0]);
            int width2 = fm.stringWidth(this.label[1]);
            if (this.isBold && (this.color.equals(Color.red) || this.color.equals(Color.black))) {
                offscreen.setColor(Color.white);
            } else {
                offscreen.setColor(Color.black);
            }
            int h = fm.getAscent();
            offscreen.drawString(this.label[0], (int)this.pos.x - width1 / 2, (int)this.pos.y - this.height / 5 + h / 2);
            offscreen.drawString(this.label[1], (int)this.pos.x - width2 / 2, (int)this.pos.y + this.height / 5 + h / 2);
        } else {
            super.drawLabel(offscreen);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getLabel()) + ", index: " + this.index;
    }
}

