/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search.elements;

import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.search.SearchCanvas;
import AIspace.search.SearchGraph;
import AIspace.search.elements.SearchNode;
import java.awt.Color;

public class SearchEdge
extends Edge {
    public static final int UNSEARCHED_EDGE = 0;
    public static final int SEARCHED_EDGE = 1;
    private double cost = 1.0;

    public SearchEdge(SearchGraph graph, Node tail, Node head) {
        super(graph, tail, head);
        this.edgeType = 5551;
        ((SearchNode)this.start).setChild((SearchNode)graph.nodeAt(this.end.index));
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double c) {
        this.cost = c;
    }

    public void setDisplayCost(boolean isShown) {
        if (isShown) {
            this.setLabel(String.valueOf(this.cost));
        } else {
            this.setLabel("");
        }
    }

    public void setAppearance(int type) {
        switch (type) {
            case 0: {
                this.color = Color.black;
                this.xw = 0;
                break;
            }
            case 1: {
                this.color = Color.red;
                this.xw = 2;
                break;
            }
            default: {
                this.color = Color.black;
            }
        }
    }

    public int getAppearance() {
        switch (this.xw) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public void updateProperties(double c) {
        this.setCost(c);
        this.setDisplayCost(((SearchCanvas)this.graph.canvas).isDisplayingCost());
    }

    @Override
    public void updateLength() {
        this.b[0] = this.start.findBorder(this.end);
        this.b[1] = this.end.findBorder(this.start);
        this.length = this.distance(this.b[0], this.b[1]);
        if (((SearchGraph)this.graph).getUseEdgeLength()) {
            this.cost = (double)Math.round(this.distance(this.start.pos, this.end.pos) / this.graph.getScale()) / 10.0;
            this.setDisplayCost(((SearchCanvas)this.graph.canvas).isDisplayingCost());
        }
    }
}

