/*
 * Decompiled with CFR 0.152.
 */
package AIspace.search.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Point;
import AIspace.search.SearchGraph;
import AIspace.search.SearchWindow;
import AIspace.search.elements.SearchNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NodeDialog
extends BasicDialog {
    private JTextField textNodeName;
    private JTextField textHeuristics;
    private JRadioButton goalNodeButton;
    private JRadioButton startNodeButton;
    private JRadioButton regularNodeButton;
    private JLabel labelError;
    private SearchGraph graph;
    private SearchWindow sWindow;
    private SearchNode selected;
    private int nodeType;
    public boolean isCancelled;

    public NodeDialog(JFrame parent, SearchGraph g) {
        super(parent, "Node Properties", true);
        this.sWindow = (SearchWindow)parent;
        this.graph = g;
        this.nodeType = 16;
        this.textNodeName = new JTextField("", 20);
        this.textNodeName.addActionListener(this);
        this.textHeuristics = new JTextField("", 20);
        this.textHeuristics.addActionListener(this);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        ButtonGroup setNodesGroup = new ButtonGroup();
        JPanel selectPanel = new JPanel(new BorderLayout());
        this.regularNodeButton = new JRadioButton("Regular Node", true);
        setNodesGroup.add(this.regularNodeButton);
        selectPanel.add((Component)this.regularNodeButton, "West");
        this.goalNodeButton = new JRadioButton(" Goal Node ", false);
        setNodesGroup.add(this.goalNodeButton);
        selectPanel.add((Component)this.goalNodeButton, "Center");
        this.startNodeButton = new JRadioButton(" Start Node ", false);
        setNodesGroup.add(this.startNodeButton);
        selectPanel.add((Component)this.startNodeButton, "East");
        JButton buttonOk = new JButton("  OK  ");
        buttonOk.addActionListener(this);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(this);
        this.labelError = new JLabel(" ");
        JPanel panel = new JPanel();
        panel.setLayout(this.gbl);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(buttonOk);
        buttonPanel.add(buttonCancel);
        JPanel cancelPanel = new JPanel(new BorderLayout());
        cancelPanel.add((Component)buttonPanel, "West");
        this.addComponent(new JLabel("Node predicate:"), panel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.textNodeName, panel, 0, 1, -1, 1, 1.0, 0.0);
        this.addComponent(new JLabel("Node heuristics:"), panel, 1, 0, -1, 1, 1.0, 0.0);
        this.addComponent(this.textHeuristics, panel, 1, 1, -1, 1, 1.0, 0.0);
        this.addComponent(new JLabel("Set Node as:"), panel, 2, 0, -1, 1, 1.0, 0.0);
        this.addComponent(selectPanel, panel, 2, 1, -1, 1, 1.0, 0.0);
        this.addComponent(cancelPanel, panel, 3, 1, -1, 1, 0.0, 0.0);
        this.getContentPane().add(panel);
        this.getContentPane().add("South", this.labelError);
    }

    public void open(SearchNode node, Point pos) {
        this.isCancelled = true;
        this.selected = node;
        String nodeName = this.selected.getPredicateLabel();
        if (nodeName.equals("")) {
            boolean nameFound = false;
            int nameCount = 0;
            nodeName = "Node " + nameCount;
            block0: while (!nameFound && this.graph.numNodes() > 0) {
                int count = 0;
                while (count < this.graph.numNodes()) {
                    if (this.graph.nodeAt(count).getLabel().equals(nodeName)) {
                        nodeName = "Node " + ++nameCount;
                        continue block0;
                    }
                    if (count == this.graph.numNodes() - 1) {
                        nameFound = true;
                    }
                    ++count;
                }
            }
        }
        int type = node.getNodeType();
        this.textNodeName.setText(nodeName);
        this.textHeuristics.setText(String.valueOf(this.selected.getHeuristics()));
        if (type == 1) {
            this.startNodeButton.setSelected(true);
        } else if (type == 2) {
            this.goalNodeButton.setSelected(true);
        } else if (type == 0) {
            this.regularNodeButton.setSelected(true);
        }
        this.pack();
        this.ensureOnScreen(pos);
        this.setVisible(true);
    }

    public boolean setProperties() {
        block8: {
            try {
                this.sWindow.saveUndo();
                if (this.textNodeName.getText().trim().equals("") || this.selected.getLabel().equals(this.textNodeName.getText().trim()) || this.graph.isNodeNameAllowed(this.textNodeName.getText().trim(), this.selected)) break block8;
                this.graph.showMessage("Error in Name", "Name has already been used.");
                return false;
            }
            catch (NumberFormatException e) {
                this.labelError.setText("Error: Heuristics has invalid real number format!");
                return false;
            }
        }
        this.selected.updateProperties(this.textNodeName.getText().trim(), Double.parseDouble(this.textHeuristics.getText()));
        this.setNodeType();
        if (this.nodeType == 11) {
            this.selected.setNodeType(1);
            this.graph.setAsStartNode(this.selected);
        } else if (this.nodeType == 15) {
            this.selected.setNodeType(2);
            this.graph.setAsGoalNode(this.selected);
        } else if (this.nodeType == 16) {
            this.selected.setNodeType(0);
            this.graph.setAsRegularNode(this.selected);
        }
        return true;
    }

    public void setNodeType() {
        if (this.startNodeButton.isSelected()) {
            this.nodeType = 11;
        } else if (this.goalNodeButton.isSelected()) {
            this.nodeType = 15;
        } else if (this.regularNodeButton.isSelected()) {
            this.nodeType = 16;
        }
    }

    @Override
    protected boolean actionOK() {
        if (this.setProperties()) {
            this.isCancelled = false;
            return true;
        }
        return false;
    }

    @Override
    protected boolean actionCancel() {
        this.isCancelled = true;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.labelError.setText(" ");
        super.actionPerformed(e);
        if (e.getSource().equals(this.textNodeName)) {
            this.textNodeName.transferFocus();
        } else if (e.getSource().equals(this.textHeuristics)) {
            this.textHeuristics.transferFocus();
        }
    }
}

