/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.relations;

import AIspace.cspTools.Counter;
import AIspace.cspTools.Domain;
import AIspace.cspTools.VE.FactorUpdatable;
import AIspace.cspTools.VE.VE_Variable;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.relations.RelationFactor;
import AIspace.cspTools.relations.RelationPanel;
import java.util.ArrayList;
import java.util.Enumeration;

public abstract class RelationRegular
extends RelationFactor {
    protected boolean complement = false;

    public void setComplement(boolean cmp) {
        this.complement = cmp;
    }

    protected abstract boolean testFunction(int[] var1, DomainDiscrete[] var2);

    private boolean testF(int[] args, DomainDiscrete[] domains) {
        if (this.complement) {
            return !this.testFunction(args, domains);
        }
        return this.testFunction(args, domains);
    }

    @Override
    public void reset() {
        VE_Variable[] variables = this.getDomains(this.cns.getVariables());
        this.factor = new FactorUpdatable(variables, 1.0);
        this.setOffsets((DomainDiscrete[])variables);
        int[] sizes = new int[variables.length];
        int i = 0;
        while (i < sizes.length) {
            sizes[i] = ((DomainDiscrete)variables[i]).getSize();
            ++i;
        }
        Counter c = new Counter(sizes);
        while (c.hasMoreElements()) {
            if (this.testF(c.next(), (DomainDiscrete[])variables)) {
                this.factor.update(c.getCurrentIndex(), 1.0);
                continue;
            }
            this.factor.update(c.getCurrentIndex(), 0.0);
        }
    }

    @Override
    public void init(Constraint cns) {
        this.cns = cns;
        this.reset();
    }

    @Override
    public abstract boolean testDomains(Domain[] var1);

    @Override
    public abstract boolean testVar(CSPVariable var1);

    @Override
    public boolean openRD() {
        return false;
    }

    @Override
    public boolean addDomain(Domain domain) {
        this.reset();
        return true;
    }

    @Override
    public boolean removeDomain(Domain domain) {
        int n = this.offsets.length;
        this.reset();
        return n != this.offsets.length;
    }

    @Override
    public AffirmPanel getEditPanel(boolean edit) {
        RelationPanel panel = new RelationPanel(this, this.complement, this.cns.getVariables(), edit);
        return panel;
    }

    @Override
    public abstract String getTypeString();

    @Override
    public abstract String getType();

    @Override
    public String getLabel() {
        if (!this.complement) {
            return this.getDescription(this.cns.getVariables());
        }
        return "not(" + this.getDescription(this.cns.getVariables()) + ")";
    }

    @Override
    public String additionalXML(String indent) {
        String rep = "";
        String arg = "";
        if (this.complement) {
            arg = "complement";
        }
        rep = String.valueOf(rep) + indent + "<" + "ARGS" + ">" + arg + "</" + "ARGS" + ">\n";
        return rep;
    }

    @Override
    public boolean setArgs(Enumeration arg) {
        String s;
        if (!arg.hasMoreElements()) {
            return true;
        }
        Object a = arg.nextElement();
        if (a instanceof String && (s = (String)a).toUpperCase().equals("COMPLEMENT")) {
            this.complement = true;
        }
        return true;
    }

    public abstract String getDescription(ArrayList<CSPVariable> var1);
}

