/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.elements;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.Relation;
import AIspace.cspTools.dialogs.AffirmPanel;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.cspTools.elements.VariableEdge;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class Constraint
extends Node {
    public static final int DCONNECT = 0;
    public static final int DSTANDARD = 1;
    public static final Color COLOR_NEUTRAL = Color.black;
    public static final Color COLOR_TRUE = Color.green;
    public static final Color COLOR_FALSE = Color.red;
    public static final Color COLOR_SUFFIC = Color.black;
    public static final Color COLOR_UNSUFF = Color.orange;
    private int displayMode;
    protected ArrayList<CSPVariable> variables;
    protected Relation relation;
    protected static int arity;
    protected boolean solve;
    protected ArrayList<VariableEdge> connectEdges;
    protected ArrayList<ConstraintEdge> standEdges;
    protected AffirmPanel cnsEdit;
    protected CSP csp;

    public Constraint(CSPgraph graph, Point point, ArrayList<CSPVariable> variables, int displayMode, CSP csp) {
        super(graph, "Constraint", point, COLOR_NEUTRAL, 1111);
        if (variables == null) {
            variables = new ArrayList();
        }
        this.variables = new ArrayList();
        this.connectEdges = new ArrayList();
        this.standEdges = new ArrayList();
        this.setDisplayMode(displayMode);
        this.csp = csp;
        int i = variables.size() - 1;
        while (i >= 0) {
            this.add(variables.get(i));
            --i;
        }
    }

    public void setRelation(Relation r) {
        this.relation = r;
        this.setLabel();
    }

    public Relation getRelation() {
        return this.relation;
    }

    public ArrayList<CSPVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(ArrayList<CSPVariable> vars) {
        this.variables = vars;
    }

    public final boolean containsVariable(CSPVariable var) {
        return this.variables.contains(var);
    }

    public final boolean containsEdge(Edge edge) {
        return this.standEdges.contains(edge) || this.connectEdges.contains(edge);
    }

    public final int variableIndex(CSPVariable var) {
        return this.variables.indexOf(var);
    }

    public boolean test() {
        return this.relation.test();
    }

    public boolean getAllowed(int[] v) {
        return this.relation.getAllowed(v);
    }

    public boolean viable(int var, int val) {
        return this.relation.viable(var, val);
    }

    protected boolean testVar(CSPVariable var) {
        return this.relation.testVar(var);
    }

    protected boolean complete() {
        return this.relation.complete();
    }

    public ArrayList<ConstraintEdge> getConstraintEdges() {
        return this.standEdges;
    }

    public final boolean addVariable(CSPVariable var) {
        if (!this.testVar(var)) {
            return false;
        }
        if (this.variables.contains(var)) {
            return false;
        }
        if (this.add(var)) {
            this.relation.addDomain(var.getDomain());
            return true;
        }
        return false;
    }

    private final boolean add(CSPVariable var) {
        ConstraintEdge constedge = this.csp.newConstraintEdge(this, this.graph, var);
        this.standEdges.add(constedge);
        constedge.setDraw(true);
        this.graph.addEdge(constedge);
        for (CSPVariable v : this.variables) {
            VariableEdge varedge = this.csp.newVariableEdge(this, this.graph, var, v);
            varedge.setDraw(false);
            this.connectEdges.add(varedge);
        }
        this.variables.add(0, var);
        var.setEdit(false);
        return true;
    }

    public final void removeVariable(CSPVariable var) {
        this.variables.remove(var);
        ArrayList<VariableEdge> removeConnect = new ArrayList<VariableEdge>(this.connectEdges.size());
        for (VariableEdge e : this.connectEdges) {
            if (!e.end.equals(var) && !e.start.equals(var)) continue;
            removeConnect.add(e);
        }
        for (VariableEdge e : removeConnect) {
            this.connectEdges.remove(e);
        }
        ArrayList<ConstraintEdge> removeStand = new ArrayList<ConstraintEdge>(this.standEdges.size());
        for (ConstraintEdge e : this.standEdges) {
            if (!e.end.equals(var) && !e.start.equals(var)) continue;
            removeStand.add(e);
        }
        for (ConstraintEdge e : removeStand) {
            this.standEdges.remove(e);
        }
        this.relation.removeDomain(var.getDomain());
        this.setLabel();
    }

    public void setLabel() {
        if (this.relation == null) {
            this.setLabel("Constraint");
        } else {
            this.setLabel(CSP.trim(this.relation.getLabel()));
        }
        this.updateSize();
    }

    public final void setDisplayMode(int mode) {
        block7: {
            block6: {
                if (mode != 1) break block6;
                if (this.displayMode == 1) {
                    return;
                }
                this.displayMode = 1;
                for (Entity entity : this.connectEdges) {
                    ((CSPgraph)this.graph).remove(entity);
                }
                this.graph.addNode(this);
                for (Edge edge : this.standEdges) {
                    this.graph.addEdge(edge);
                }
                break block7;
            }
            if (mode != 0) break block7;
            if (this.displayMode == 0) {
                return;
            }
            this.displayMode = 0;
            ((CSPgraph)this.graph).remove(this);
            for (Entity entity : this.standEdges) {
                ((CSPgraph)this.graph).remove(entity);
            }
            for (Edge edge : this.connectEdges) {
                this.graph.addEdge(edge);
            }
        }
    }

    public final void changeDisplayMode() {
        if (this.displayMode == 1) {
            this.setDisplayMode(0);
        } else if (this.displayMode == 0) {
            this.setDisplayMode(1);
        }
    }

    public final void delete() {
        Edge edge;
        while (!this.standEdges.isEmpty()) {
            edge = this.standEdges.get(0);
            this.standEdges.remove(edge);
            this.removeEdge(edge);
            ((CSPgraph)this.graph).remove(edge);
        }
        while (!this.connectEdges.isEmpty()) {
            edge = this.connectEdges.get(0);
            this.connectEdges.remove(edge);
            this.removeEdge(edge);
            ((CSPgraph)this.graph).remove(edge);
        }
        ((CSPgraph)this.graph).remove(this);
    }

    private final void removeEdge(Edge e) {
        e.end.removeEdgesIn(e);
        e.start.removeEdgesOut(e);
    }

    public boolean openRD() {
        return this.relation.openRD();
    }

    protected final void setColorAll(Color color) {
        this.setColor(color);
        for (Edge edge : this.standEdges) {
            edge.color = color;
        }
        for (Edge edge : this.connectEdges) {
            edge.color = color;
        }
    }

    public final int index(CSPVariable var) {
        return this.variables.indexOf(var);
    }

    @Override
    public final void draw(Graphics offscreen, boolean moving) {
        if (this.displayMode == 1) {
            super.draw(offscreen, moving);
        }
    }

    public final void setPosition() {
        float bottom = Float.MAX_VALUE;
        float left = Float.MAX_VALUE;
        float top = Float.MIN_VALUE;
        float right = Float.MIN_VALUE;
        for (Node node : this.variables) {
            if (node.pos.x < left) {
                left = node.pos.x;
            }
            if (node.pos.x > right) {
                right = node.pos.x;
            }
            if (node.pos.y < bottom) {
                bottom = node.pos.y;
            }
            if (!(node.pos.y > top)) continue;
            top = node.pos.y;
        }
        Point p = this.variables.size() > 1 ? new Point((left + right) / 2.0f, (top + bottom) / 2.0f) : new Point(left, top + 100.0f);
        this.graph.moveEntities(p, this);
    }

    public void setMode(boolean solve) {
        this.solve = solve;
        if (this.complete()) {
            this.setColorAll(COLOR_SUFFIC);
        } else {
            this.setColorAll(COLOR_UNSUFF);
        }
    }

    public String toXML(String indent) {
        StringBuffer rep = new StringBuffer(indent);
        rep.append("<").append("CONSTRAINT").append(" ").append("TYPE");
        rep.append("=\"").append(this.relation.getType()).append("\">\n");
        if (this.relation.getType().equals("Custom")) {
            rep.append(indent).append("\t<").append("CUSTOMNAME").append(">");
            rep.append(this.relation.getLabel()).append("</").append("CUSTOMNAME").append(">\n");
        }
        int i = 0;
        while (i < this.variables.size()) {
            rep.append(indent).append("\t<").append("GIVEN").append(">");
            rep.append(this.variables.get(i).getName());
            rep.append("</").append("GIVEN").append(">\n");
            ++i;
        }
        rep.append(this.relation.additionalXML(String.valueOf(indent) + "\t"));
        rep.append(indent).append("\t<").append("PROPERTY").append(">");
        rep.append("position = (").append(this.pos.x).append(", ").append(this.pos.y).append(")");
        rep.append("</").append("PROPERTY").append(">\n");
        rep.append(indent).append("</").append("CONSTRAINT").append(">\n");
        return rep.toString();
    }
}

