/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools.VE;

import AIspace.cspTools.VE.EltsIterator;
import AIspace.cspTools.VE.Factor;
import AIspace.cspTools.VE.VE_Variable;

public abstract class FactorStored
extends Factor {
    protected double[] factorValues;

    public FactorStored(VE_Variable[] vars) {
        super(vars);
        this.factorValues = new double[this.size()];
    }

    public FactorStored(VE_Variable[] variables, boolean copyVariables, double[] values, boolean copyValues) {
        super(variables, copyVariables);
        if (values.length != this.size()) {
            throw new IllegalArgumentException("Number of provided values is incorrect!");
        }
        if (copyValues) {
            this.factorValues = new double[values.length];
            System.arraycopy(values, 0, this.factorValues, 0, values.length);
        } else {
            this.factorValues = values;
        }
    }

    @Override
    public EltsIterator iterator() {
        return new Itr();
    }

    private class Itr
    implements EltsIterator {
        int curpos = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.curpos < FactorStored.this.factorValues.length;
        }

        @Override
        public double next() {
            return FactorStored.this.factorValues[this.curpos++];
        }

        @Override
        public int currPos() {
            return this.curpos;
        }

        @Override
        public void backTo(int pos) {
            this.curpos = pos;
        }
    }
}

