/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools;

import AIspace.XMLReader.Pair;
import AIspace.XMLReader.XMLBlock;
import AIspace.XMLReader.XMLParseException;
import AIspace.XMLReader.XMLTree;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.Relation;
import AIspace.cspTools.domains.DomainChooser;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.relations.RelationChooser;
import AIspace.graphToolKit.elements.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class IO {
    public static final String xmltag = "CSPIF";
    public static final String xmlvatt = "VERSION";
    public static final String xmlversion = "0.01";
    public static final String csptag = "CSP";
    public static final String nametag = "NAME";
    public static final String vartag = "VARIABLE";
    public static final String atttype = "TYPE";
    public static final String customnametag = "CUSTOMNAME";
    public static final String proptag = "PROPERTY";
    public static final String valtag = "VALUE";
    public static final String cnstag = "CONSTRAINT";
    public static final String inptag = "GIVEN";
    public static final String tabletag = "TABLE";
    public static final String argtag = "ARGS";
    public static final String desctag = "DESCRIPTION";
    public static final String shorttag = "SHORT";
    public static final String detailtag = "DETAILED";
    private static Hashtable<Integer, String> ht;
    private static Hashtable<Integer, Integer> ht2;

    public static String createXML(CSP csp, boolean current) {
        StringBuffer xml = new StringBuffer(IO.header());
        xml.append(csp.toXML("", current));
        xml.append(IO.footer());
        return xml.toString();
    }

    public static String editDescription(CSP csp) {
        String sd = "Overview Description: \n" + csp.getShortDesc() + "\n";
        String ld = "Detail Description: \n" + csp.getDetailedDesc() + "\n";
        String d = "\n" + sd + "\n" + ld;
        return d;
    }

    private static String header() {
        StringBuffer header = new StringBuffer("<");
        header.append(xmltag).append(" ").append(xmlvatt).append("=\"").append(xmlversion).append("\">\n");
        return header.toString();
    }

    private static String footer() {
        return "</CSPIF>\n";
    }

    public static boolean parseXML(String xml, CSP csp) {
        ArrayList<XMLBlock> csps;
        boolean value = false;
        XMLTree tree = new XMLTree();
        try {
            tree.readString(xml);
        }
        catch (XMLParseException e) {
            IO.parseError(e.getLocalizedMessage());
            return false;
        }
        XMLBlock head = tree.getHead();
        if (head.getTag().equals(csptag)) {
            value = IO.parseCSP(head, csp);
        } else if (head.getTag().equals(xmltag) && (csps = head.searchChildTag(csptag)) != null) {
            value = IO.parseCSP(csps.get(0), csp);
        }
        if (!value) {
            IO.parseError("No CSP Tags found");
        } else {
            csp.resetLabels();
        }
        return value;
    }

    public static boolean parseCSP(XMLBlock block, CSP csp) {
        ArrayList<XMLBlock> variables = block.searchChildTag(vartag);
        ArrayList<XMLBlock> constraints = block.searchChildTag(cnstag);
        ArrayList<XMLBlock> names = block.searchChildTag(nametag);
        if (names == null || names.size() == 0) {
            csp.setName("Untitled");
        } else {
            csp.setName(names.get(0).getText());
        }
        ArrayList<XMLBlock> descs = block.searchChildTag(desctag);
        ArrayList<Object> sdescs = new ArrayList();
        ArrayList<Object> ldescs = new ArrayList();
        if (descs == null || descs.size() == 0) {
            csp.setShortDesc("");
            csp.setDetailedDesc("");
        } else {
            sdescs = descs.get(0).searchChildTag(shorttag);
            ldescs = descs.get(0).searchChildTag(detailtag);
            if (sdescs == null || sdescs.size() == 0) {
                csp.setShortDesc("");
            } else {
                csp.setShortDesc(((XMLBlock)sdescs.get(0)).getText());
            }
            if (ldescs == null || ldescs.size() == 0) {
                csp.setDetailedDesc("");
            } else {
                csp.setDetailedDesc(((XMLBlock)ldescs.get(0)).getText());
            }
        }
        if (variables != null) {
            for (XMLBlock b : variables) {
                if (IO.parseVariable(b, csp)) continue;
                return false;
            }
        }
        if (constraints != null) {
            for (XMLBlock b : constraints) {
                if (IO.parseConstraint(b, csp)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean parseVariable(XMLBlock block, CSP csp) {
        DomainDiscrete domain;
        String name = null;
        Point p = null;
        String type = null;
        ArrayList<XMLBlock> values = null;
        ArrayList<String> stringValues = new ArrayList<String>();
        ArrayList<Pair> properties = block.getProperties();
        if (properties.size() != 1) {
            IO.parseError("Incorrect Properties Length\n" + block.toString());
            return false;
        }
        Pair property = properties.get(0);
        if (!property.name.equals(atttype)) {
            IO.parseError("Incorrect Property " + property.name + " " + property.value);
            return false;
        }
        type = IO.strip(property.value).nextToken();
        values = block.searchChildTag(valtag);
        ArrayList<XMLBlock> names = block.searchChildTag(nametag);
        ArrayList<XMLBlock> props = block.searchChildTag(proptag);
        if (names != null && names.size() != 0) {
            name = names.get(0).getText();
        }
        if (props != null && props.size() != 0) {
            StringTokenizer tkn = IO.strip(props.get(0).getText());
            if (!tkn.nextToken().equals("position")) {
                IO.parseError("Unknown Property");
            } else {
                try {
                    p = new Point();
                    p.x = Float.parseFloat(tkn.nextToken());
                    p.y = Float.parseFloat(tkn.nextToken());
                }
                catch (Exception e) {
                    p = null;
                    IO.parseError("Incorrect Position Syntax");
                }
            }
        }
        if (values != null) {
            for (XMLBlock b : values) {
                stringValues.add(b.getText());
            }
        }
        if ((domain = DomainChooser.newObject(type)) == null) {
            IO.parseError("Variable TYPE " + type + " Not Found");
            return false;
        }
        domain.clear();
        for (String s : stringValues) {
            domain.addElement(s);
        }
        if (p == null) {
            p = csp.getPos();
        }
        CSPVariable var = csp.newVariable(domain, (CSPgraph)csp.getCanvas().graph, p);
        if (name == null) {
            name = csp.getName();
        }
        var.setName(name);
        csp.addVariable(var);
        return true;
    }

    public static boolean parseConstraint(XMLBlock block, CSP csp) {
        Point p = null;
        ArrayList<XMLBlock> variables = block.searchChildTag(inptag);
        ArrayList<XMLBlock> props = block.searchChildTag(proptag);
        ArrayList<XMLBlock> args = block.searchChildTag(argtag);
        ArrayList<XMLBlock> table = block.searchChildTag(tabletag);
        ArrayList<XMLBlock> customnames = block.searchChildTag(customnametag);
        ArrayList<String> stringVarNames = new ArrayList<String>();
        ArrayList<Pair> properties = block.getProperties();
        if (properties.size() != 1) {
            IO.parseError("Incorrect Properties Length\n" + block.toString());
            return false;
        }
        Pair property = properties.get(0);
        if (!property.name.equals(atttype)) {
            IO.parseError("Incorrect Property " + property.name + " " + property.value);
            return false;
        }
        String type = IO.strip(property.value).nextToken();
        if (props != null && props.size() != 0) {
            StringTokenizer tkn = IO.strip(props.get(0).getText());
            if (!tkn.nextToken().equals("position")) {
                IO.parseError("Unknown Property");
            } else {
                try {
                    p = new Point(Float.parseFloat(tkn.nextToken()), Float.parseFloat(tkn.nextToken()));
                }
                catch (Exception e) {
                    IO.parseError("Incorrect Position Syntax");
                }
            }
        }
        if (variables != null) {
            for (XMLBlock b : variables) {
                stringVarNames.add(b.getText());
            }
        }
        ArrayList<CSPVariable> vars = new ArrayList<CSPVariable>();
        for (String s : stringVarNames) {
            CSPVariable v = csp.getVariable(s);
            if (v != null) {
                vars.add(v);
                continue;
            }
            IO.parseError("GIVEN " + s + " does not have corresponding variable");
        }
        if (p == null) {
            p = csp.getPos();
        }
        Constraint cns = csp.newConstraint((CSPgraph)csp.getCanvas().graph, p, vars, 1, csp);
        Relation relation = RelationChooser.newObject(type, cns);
        cns.setRelation(relation);
        if (customnames != null && customnames.size() != 0) {
            relation.setLabel(customnames.get(0).getText());
        }
        if (args != null && args.size() != 0) {
            relation.setArgs(IO.strip(args.get(0).getText()));
        }
        relation.reset();
        if (table != null && table.size() != 0) {
            relation.setArgs(IO.strip(table.get(0).getText()));
        }
        csp.addConstraint(cns);
        return true;
    }

    private static StringTokenizer strip(String s) {
        StringTokenizer tkn = new StringTokenizer(s, " \"=(,)\t\n");
        return tkn;
    }

    public static void parseError(String error) {
        JOptionPane.showMessageDialog(null, "XML Parsing Error: " + error, "Error", 0);
    }

    public static String parseOld2XML(ArrayList<String> oldGraph) {
        ht = new Hashtable();
        ht2 = new Hashtable();
        StringBuffer xml = new StringBuffer("<!--Translated From Original AIspace CSP Format-->\n");
        xml.append(IO.header()).append("<").append(csptag).append(">\n");
        for (String s : oldGraph) {
            xml.append(IO.parseOldLine(s));
        }
        xml.append("</").append(csptag).append(">\n").append(IO.footer());
        ht = null;
        ht2 = null;
        return xml.toString();
    }

    private static String parseOldLine(String line) {
        StringBuffer val = new StringBuffer();
        StringTokenizer ln = new StringTokenizer(line, ":,/;*");
        if (!ln.hasMoreTokens()) {
            return val.toString();
        }
        String lntype = ln.nextToken();
        if (lntype.charAt(0) == '%') {
            return "";
        }
        if (lntype.charAt(0) == 'n') {
            int numvals = 0;
            Integer index = new Integer(ln.nextToken());
            String name = ln.nextToken();
            Float xcoord = new Float(ln.nextToken());
            Float ycoord = new Float(ln.nextToken());
            String type = ln.nextToken();
            ArrayList<String> domain = new ArrayList<String>();
            while (ln.hasMoreTokens()) {
                ++numvals;
                domain.add(ln.nextToken());
            }
            if (type.toUpperCase().equals("BOOLEAN")) {
                domain.add("true");
                domain.add("false");
            }
            ht.put(index, name);
            ht2.put(index, new Integer(numvals));
            val.append("<").append(vartag).append(" ").append(atttype).append("=").append(type).append(">\n");
            val.append("\t<").append(nametag).append(">").append(name).append("</").append(nametag).append(">\n");
            val.append("\t<").append(proptag).append(">position =").append(xcoord).append(",").append(ycoord).append("</").append(proptag).append(">\n");
            for (String s : domain) {
                val.append("\t<").append(valtag).append(">").append(s).append("</").append(valtag).append(">\n");
            }
            val.append("</").append(vartag).append(">\n");
        } else if (lntype.charAt(0) == 'e' && !lntype.equals("endConstraintGraph")) {
            Integer index0 = new Integer(ln.nextToken());
            Integer index1 = new Integer(ln.nextToken());
            String type = ln.nextToken();
            ArrayList<String> args = new ArrayList<String>();
            while (ln.hasMoreTokens()) {
                args.add(ln.nextToken());
            }
            String newtype = "Custom";
            boolean complement = false;
            boolean invert = false;
            if (type.equals("<")) {
                newtype = "LessThan";
            } else if (type.equals(">")) {
                newtype = "GreaterThan";
            } else if (type.equals("=")) {
                newtype = "Equals";
            } else if (type.equals("!=")) {
                newtype = "Equals";
                complement = true;
            } else if (type.equals("CROSSWORD")) {
                newtype = "Crossword";
            } else if (type.equals("QUEENS")) {
                newtype = "Queens";
            } else if (type.equals("XOR")) {
                newtype = "LessThan";
            } else if (type.equals("NAND")) {
                newtype = "And";
                complement = true;
            } else if (type.equals("NOR")) {
                newtype = "Or";
                complement = true;
            } else if (type.equals("<-")) {
                newtype = "Implies";
                invert = true;
            } else if (type.equals("->")) {
                newtype = "Implies";
            } else if (type.equals("TRUE")) {
                newtype = "Trivial";
            } else if (type.equals("<=")) {
                newtype = "GreaterThan";
                complement = true;
            } else if (type.equals(">=")) {
                newtype = "LessThan";
                complement = true;
            } else if (type.equals("AND")) {
                newtype = "And";
            } else if (type.equals("OR")) {
                newtype = "Or";
            }
            if (invert) {
                Integer temp = index0;
                index0 = index1;
                index1 = temp;
            }
            StringBuffer arguments = new StringBuffer();
            StringBuffer table = new StringBuffer();
            if (newtype.equals("Custom")) {
                table.append("<").append(tabletag).append(">\n\t");
                int s0 = ht2.get(index0);
                int s1 = ht2.get(index1);
                int[] trueEls = new int[args.size() / 2];
                int i = 0;
                Iterator itr = args.iterator();
                while (itr.hasNext()) {
                    trueEls[i++] = Integer.parseInt((String)itr.next()) + s1 * Integer.parseInt((String)itr.next());
                }
                String[] b = new String[s1 * s0];
                int j = 0;
                while (j < b.length) {
                    b[j] = "F";
                    ++j;
                }
                j = 0;
                while (j < trueEls.length) {
                    b[trueEls[j]] = "T";
                    ++j;
                }
                j = 0;
                while (j < b.length) {
                    table.append(b[j]).append(" ");
                    ++j;
                }
                table.append("\n</").append(tabletag).append(">\n");
            } else {
                if (complement) {
                    arguments.append("complement ");
                }
                for (String s : args) {
                    arguments.append(s).append(" ");
                }
            }
            val.append("<").append(cnstag).append(" ").append(atttype).append("=").append(newtype).append(">\n");
            val.append("<").append(inptag).append(">").append(ht.get(index0)).append("</").append(inptag).append(">\n");
            val.append("<").append(inptag).append(">").append(ht.get(index1)).append("</").append(inptag).append(">\n");
            val.append("\t<").append(argtag).append(">").append(arguments).append("</").append(argtag).append(">\n");
            val.append(table).append("</").append(cnstag).append(">\n");
        }
        return val.toString();
    }
}

