/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint;

import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.InlineCanvas;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.IO;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.InlineApplet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class InlineConstraintApplet
extends InlineApplet {
    private static final long serialVersionUID = 1L;
    private ConstraintCSP csp;
    public JTextArea ta;
    private boolean isSplitHalf = true;
    private int splitBy = 1431;
    private ArrayList<CSPVariable> autoSolveVariableOrder;
    public int domainHistoryIndent = 0;
    public int numSplitsOnStack = 0;
    public boolean domainSplit = false;
    public JToggleButton fakeButton;
    public JToggleButton backtrackButton;
    public JToggleButton stepBackButton;
    public JToggleButton resetButton;
    public JToggleButton stopButton;
    public JToggleButton autoSolveButton;
    public JToggleButton autoACButton;
    public JToggleButton stepButton;
    public JToggleButton fineStepButton;
    private boolean fsButtonOn = false;
    private boolean resetButtonOn = false;
    private boolean btckButtonOn = false;
    private boolean stpBackButtonOn = false;
    private boolean stopButtonOn = false;
    private boolean autoslvButtonOn = false;
    private boolean autoacButtonOn = false;
    private boolean stepButtonOn = false;
    public boolean fsPopupOn = false;
    public boolean resetPopupOn = false;
    public boolean btckPopupOn = false;
    public boolean stpBackPopupOn = false;
    public boolean stopPopupOn = false;
    public boolean autoslvPopupOn = false;
    public boolean autoacPopupOn = false;
    public boolean stepPopupOn = false;
    private boolean showSplitPanel = false;
    public boolean domainSplitClick = true;
    public boolean constraintPropertyClick = true;

    @Override
    public void init() {
        super.init();
        this.makeCanvas();
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.csp.setMode(true);
        this.csp.resetNodes();
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.canvas.setMinimumSize(new Dimension(10, 100));
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
            this.setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
        }
        this.ta = new JTextArea();
        this.ta.setEditable(false);
        this.ta.setBackground(Color.white);
        this.ta.setForeground(GraphConsts.fg);
        this.ta.setRows(2);
        this.ta.setText("DOMAIN-SPLITTING HISTORY:\n");
        JScrollPane taPanel = new JScrollPane(this.ta, 20, 31);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.canvasPanel);
        this.canvasPanel.addComponentListener(this);
        splitPane.setBottomComponent(taPanel);
        splitPane.setResizeWeight(0.85);
        if (!this.showSplitPanel) {
            splitPane.setDividerSize(0);
            taPanel.setVisible(false);
        } else {
            splitPane.setOneTouchExpandable(true);
        }
        if (this.showButtons) {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
        } else {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.toolBarPanel.setVisible(false);
        }
        taPanel.setBorder(null);
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            splitPane.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
            splitPane.setBorder(null);
        }
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    protected void makeCanvas() {
        this.csp = new ConstraintCSP(this, true);
        this.canvas = new InlineCanvas((Container)this, this.csp);
        this.csp.init((CSPcanvas)this.canvas);
        this.canvas.WIDTH = this.getSize().width;
        this.canvas.HEIGHT = this.getSize().height;
        this.canvas.setPreferredSize(new Dimension(this.canvas.WIDTH, this.canvas.HEIGHT));
        this.canvas.setMode(2221);
    }

    protected ConstraintCSP returnCSP() {
        return this.csp;
    }

    @Override
    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("fineStepButton");
        if (param != null) {
            if (param.equals("on")) {
                this.fsButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepButton", param);
            }
        }
        if ((param = this.getParameter("stepButton")) != null) {
            if (param.equals("on")) {
                this.stepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepButton", param);
            }
        }
        if ((param = this.getParameter("autoACButton")) != null) {
            if (param.equals("on")) {
                this.autoacButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoACButton", param);
            }
        }
        if ((param = this.getParameter("autoSolveButton")) != null) {
            if (param.equals("on")) {
                this.autoslvButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSolveButton", param);
            }
        }
        if ((param = this.getParameter("stopButton")) != null) {
            if (param.equals("on")) {
                this.stopButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopButton", param);
            }
        }
        if ((param = this.getParameter("resetButton")) != null) {
            if (param.equals("on")) {
                this.resetButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetButton", param);
            }
        }
        if ((param = this.getParameter("stepBackButton")) != null) {
            if (param.equals("on")) {
                this.stpBackButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepBackButton", param);
            }
        }
        if ((param = this.getParameter("backtrackButton")) != null) {
            if (param.equals("on")) {
                this.btckButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("backtrackButton", param);
            }
        }
        if ((param = this.getParameter("splittingHistory")) != null) {
            if (param.equals("on")) {
                this.showSplitPanel = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("splittingHistory", param);
            }
        }
        if ((param = this.getParameter("fineStepPopup")) != null) {
            if (param.equals("on")) {
                this.fsPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepPopup", param);
            }
        }
        if ((param = this.getParameter("stepPopup")) != null) {
            if (param.equals("on")) {
                this.stepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepPopup", param);
            }
        }
        if ((param = this.getParameter("stepBackPopup")) != null) {
            if (param.equals("on")) {
                this.stpBackPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepBackPopup", param);
            }
        }
        if ((param = this.getParameter("autoACPopup")) != null) {
            if (param.equals("on")) {
                this.autoacPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoACPopup", param);
            }
        }
        if ((param = this.getParameter("autoSolvePopup")) != null) {
            if (param.equals("on")) {
                this.autoslvPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSolvePopup", param);
            }
        }
        if ((param = this.getParameter("stopPopup")) != null) {
            if (param.equals("on")) {
                this.stopPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopPopup", param);
            }
        }
        if ((param = this.getParameter("resetPopup")) != null) {
            if (param.equals("on")) {
                this.resetPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("resetPopup", param);
            }
        }
        if ((param = this.getParameter("backtrackPopup")) != null) {
            if (param.equals("on")) {
                this.btckPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("backtrackPopup", param);
            }
        }
        if ((param = this.getParameter("domainSplitClick")) != null) {
            if (param.equals("off")) {
                this.domainSplitClick = false;
            } else if (!param.equals("on")) {
                this.incorrectParameter("domainSplitClick", param);
            }
        }
        if ((param = this.getParameter("constraintPropertyClick")) != null) {
            if (param.equals("off")) {
                this.constraintPropertyClick = false;
            } else if (!param.equals("on")) {
                this.incorrectParameter("constraintPropertyClick", param);
            }
        }
        if ((param = this.getParameter("speed")) != null) {
            if (param.equals("veryFast")) {
                ((InlineCanvas)this.canvas).setSpeed(0);
            } else if (param.equals("fast")) {
                ((InlineCanvas)this.canvas).setSpeed(100);
            } else if (param.equals("medium")) {
                ((InlineCanvas)this.canvas).setSpeed(500);
            } else if (param.equals("slow")) {
                ((InlineCanvas)this.canvas).setSpeed(1000);
            } else {
                this.incorrectParameter("speed", param);
            }
        } else {
            ((InlineCanvas)this.canvas).setSpeed(100);
        }
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[9];
        int index = 0;
        this.setSolveButtonsWithText(index, " Fine Step ", InlineConstraintApplet.createImageIcon("images/common/finestep.png"), "Fine Step");
        this.fineStepButton = this.buttons[index++];
        if (!this.fsButtonOn) {
            this.fineStepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Step    ", InlineConstraintApplet.createImageIcon("images/constraint/step.png"), "Step");
        this.stepButton = this.buttons[index++];
        if (!this.stepButtonOn) {
            this.stepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Auto Arc-Consistency", InlineConstraintApplet.createImageIcon("images/constraint/autoarc.png"), "Auto Arc-Consistency");
        this.autoACButton = this.buttons[index++];
        if (!this.autoacButtonOn) {
            this.autoACButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "AutoSolve", InlineConstraintApplet.createImageIcon("images/constraint/gear.png"), "AutoSolve");
        this.autoSolveButton = this.buttons[index++];
        if (!this.autoslvButtonOn) {
            this.autoSolveButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Stop    ", InlineConstraintApplet.createImageIcon("images/constraint/stop.gif"), "Stop");
        this.stopButton = this.buttons[index++];
        this.stopButton.setEnabled(false);
        if (!this.stopButtonOn) {
            this.stopButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, " Step Back ", InlineConstraintApplet.createImageIcon("images/constraint/stepback.png"), "Step Back");
        this.stepBackButton = this.buttons[index++];
        this.stepBackButton.setEnabled(false);
        if (!this.stpBackButtonOn) {
            this.stepBackButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, " Backtrack ", InlineConstraintApplet.createImageIcon("images/constraint/StepBack24.gif"), "Backtrack");
        this.backtrackButton = this.buttons[index++];
        this.backtrackButton.setEnabled(false);
        if (!this.btckButtonOn) {
            this.backtrackButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "   Reset    ", InlineConstraintApplet.createImageIcon("images/constraint/Reset.gif"), "Reset");
        this.resetButton = this.buttons[index++];
        if (!this.resetButtonOn) {
            this.resetButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineConstraintApplet.createImageIcon("images/common/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            buttonGroup.add(this.buttons[i]);
            toolBar.add(this.buttons[i]);
            this.buttons[i].setFont(toolFont);
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    public void resetWindow() {
        this.fakeButton.setEnabled(true);
        this.backtrackButton.setEnabled(false);
        this.stepBackButton.setEnabled(false);
        this.resetButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.autoSolveButton.setEnabled(true);
        this.autoACButton.setEnabled(true);
        this.stepButton.setEnabled(true);
        this.fineStepButton.setEnabled(true);
        ((InlineCanvas)this.canvas).resetCSP();
        ((InlineCanvas)this.canvas).setNextSolve(InlineCanvas.FIRST_SOLVE);
    }

    public boolean updateCSPFromText(String text) {
        if (IO.parseXML(text, this.csp)) {
            this.csp.setPosition();
            this.canvas.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void load(String filename) {
        try {
            boolean xml;
            URL url = new URL(filename);
            InputStream iStream = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(iStream));
            ArrayList<String> lines = new ArrayList<String>();
            String all = "";
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                lines.add(line);
                line = in.readLine();
            }
            in.close();
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            boolean bl = xml = !ext.equals("txt");
            if (!xml) {
                all = IO.parseOld2XML(lines);
            }
            this.updateCSPFromText(all);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected CSP getCSP() {
        return new ConstraintCSP(this, false);
    }

    public int getIndent() {
        return this.domainHistoryIndent;
    }

    public void setIndent(int n) {
        this.domainHistoryIndent = n;
    }

    public int getSplitsOnStack() {
        return this.numSplitsOnStack;
    }

    public void setSplitsOnStack(int n) {
        this.numSplitsOnStack = n;
    }

    public ArrayList<CSPVariable> getVariableOrder() {
        return this.autoSolveVariableOrder;
    }

    public void setVariableOrder(ArrayList<CSPVariable> vars, int d) {
        this.splitBy = d;
        this.autoSolveVariableOrder = vars;
    }

    public boolean getSplitInHalf() {
        return this.isSplitHalf;
    }

    public void setSplitInHalf(boolean b) {
        this.isSplitHalf = b;
    }

    public void setSplitBy(int d) {
        this.splitBy = d;
    }

    public int getSplitBy() {
        return this.splitBy;
    }

    public void domainSplittingOccurred(ConstraintVariable splittingNode) {
        splittingNode.pushIndent(this.domainHistoryIndent);
        this.ta.append("\n");
        int i = 0;
        while (i < this.domainHistoryIndent) {
            this.ta.append("    ");
            ++i;
        }
        this.ta.append(splittingNode.getSplittingString());
        ++this.domainHistoryIndent;
        this.backtrackButton.setEnabled(true);
        ++this.numSplitsOnStack;
        this.domainSplit = true;
        ((InlineCanvas)this.canvas).enableBacktrack(true);
    }

    public void backtrackingOccurred(ConstraintVariable backtrackNode, boolean displayInfo) {
        if (((InlineCanvas)this.canvas).getNextSolve() == InlineCanvas.FIRST_SOLVE) {
            this.setPromptLabel("No more solutions.");
            return;
        }
        if (backtrackNode == null) {
            this.numSplitsOnStack = 0;
            return;
        }
        if (displayInfo) {
            this.domainHistoryIndent = backtrackNode.popIndent();
            this.ta.append("\n");
            int i = 0;
            while (i < this.domainHistoryIndent) {
                this.ta.append("    ");
                ++i;
            }
            this.ta.append(backtrackNode.getSplittingString());
            ++this.domainHistoryIndent;
        }
        --this.numSplitsOnStack;
        if (this.numSplitsOnStack <= 0) {
            this.backtrackButton.setEnabled(false);
            ((InlineCanvas)this.canvas).backTrackItem.setEnabled(false);
        }
        this.fineStepButton.setEnabled(true);
        this.stepButton.setEnabled(true);
        this.autoACButton.setEnabled(true);
        this.fakeButton.setSelected(true);
        this.setPromptLabel("Backtracked - Variable " + backtrackNode.getName() + " in {" + backtrackNode.getSplitRep() + "}\nNow try to solve the CSP.");
    }

    protected boolean hasMoreSplits() {
        return this.numSplitsOnStack > 0;
    }

    protected void autoArcStart() {
        if (((InlineCanvas)this.canvas).graph.numNodes() == 0) {
            this.setPromptLabel("There is no CSP.  Create one first!");
        } else {
            this.fineStepButton.setEnabled(false);
            this.stepButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.autoSolveButton.setEnabled(false);
            ((InlineCanvas)this.canvas).autoSolveItem.setEnabled(false);
            ((InlineCanvas)this.canvas).stopItem.setEnabled(true);
            ((InlineCanvas)this.canvas).autoAC();
        }
        this.canvas.repaint();
    }

    protected void autoSolveStart() {
        if (((InlineCanvas)this.canvas).graph.numNodes() == 0) {
            this.setPromptLabel("There is no CSP.  Create one first!");
        } else {
            this.fineStepButton.setEnabled(false);
            this.stepButton.setEnabled(false);
            this.autoACButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.autoSolveButton.setEnabled(false);
            ((InlineCanvas)this.canvas).autoSolveItem.setEnabled(true);
            ((InlineCanvas)this.canvas).stopItem.setEnabled(true);
            ((InlineCanvas)this.canvas).autoSolve();
        }
        this.canvas.repaint();
    }

    public void setACButtons(boolean isEnabled) {
        this.fineStepButton.setEnabled(isEnabled);
        ((InlineCanvas)this.canvas).fineStepItem.setEnabled(isEnabled);
        this.stepButton.setEnabled(isEnabled);
        ((InlineCanvas)this.canvas).stepItem.setEnabled(isEnabled);
        this.autoACButton.setEnabled(isEnabled);
        ((InlineCanvas)this.canvas).autoACItem.setEnabled(isEnabled);
    }

    public void fineStep() {
        if (this.fineStepButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.resetButton, 0, "Fine Step"));
        }
    }

    public void step() {
        if (this.stepButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.stepButton, 0, "Step"));
        }
    }

    public void autoArcConsistency() {
        if (this.autoACButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.autoACButton, 0, "Auto Arc-Consistency"));
        }
    }

    public void autoSolve() {
        if (this.autoSolveButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.autoSolveButton, 0, "AutoSolve"));
        }
    }

    @Override
    public void stop() {
        if (this.stopButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.stopButton, 0, "Stop"));
        }
    }

    public void stepBack() {
        if (this.stepBackButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.stepBackButton, 0, "Step Back"));
        }
    }

    public void backtrack() {
        if (this.backtrackButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.backtrackButton, 0, "Backtrack"));
        }
    }

    public void reset() {
        if (this.resetButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.resetButton, 0, "Reset"));
        }
    }

    public void autoscale() {
        ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }

    public void arrangeConstraints() {
        ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.fakeButton, 0, "Arrange Constraints"));
    }
}

