/*
 * Decompiled with CFR 0.152.
 */
package AIspace.Constraint;

import AIspace.Constraint.AutoAC;
import AIspace.Constraint.ConstraintCSP;
import AIspace.Constraint.ConstraintCanvas;
import AIspace.Constraint.ConstraintWindow;
import AIspace.Constraint.InlineConstraintApplet;
import AIspace.Constraint.dialogs.SplitNodeDialog;
import AIspace.Constraint.elements.CnsConstraintEdge;
import AIspace.Constraint.elements.ConstraintVariable;
import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.IO;
import AIspace.cspTools.dialogs.CSPTextFrame;
import AIspace.cspTools.elements.CSPVariable;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;

public class InlineCanvas
extends ConstraintCanvas {
    private static final long serialVersionUID = 1L;
    public static int NO_MORE_SOLUTIONS = 7;
    public static int FAIL_NO_MORE_SOLUTIONS = 8;
    public static int MORE_SOLUTION_SPLIT = 9;

    public InlineCanvas(Container parent, CSP csp) {
        super(parent, true, csp);
        this.setSize(parent.getSize());
        this.WIDTH = this.getSize().width;
        this.HEIGHT = this.getSize().height;
        this.mode = 2221;
        this.submode = 351;
        this.graph = new CSPgraph(csp, this);
    }

    public void initializePopup() {
        this.fineStepItem = new JMenuItem("Fine Step");
        this.fineStepItem.setActionCommand(this.fineStepItem.getText());
        this.fineStepItem.addActionListener(this);
        this.stepItem = new JMenuItem("Step");
        this.stepItem.setActionCommand(this.stepItem.getText());
        this.stepItem.addActionListener(this);
        this.autoACItem = new JMenuItem("Auto Arc-Consistency");
        this.autoACItem.setActionCommand(this.autoACItem.getText());
        this.autoACItem.addActionListener(this);
        this.backTrackItem = new JMenuItem("Backtrack");
        this.backTrackItem.setActionCommand(this.backTrackItem.getText());
        this.backTrackItem.addActionListener(this);
        this.backTrackItem.setEnabled(false);
        this.stopItem = new JMenuItem("Stop");
        this.stopItem.setActionCommand(this.stopItem.getText());
        this.stopItem.addActionListener(this);
        this.stopItem.setEnabled(false);
        this.autoSolveItem = new JMenuItem("AutoSolve");
        this.autoSolveItem.setActionCommand(this.autoSolveItem.getText());
        this.autoSolveItem.addActionListener(this);
        this.stepBackItem = new JMenuItem("Step Back");
        this.stepBackItem.setActionCommand(this.stepBackItem.getText());
        this.stepBackItem.addActionListener(this);
        this.stepBackItem.setEnabled(false);
        this.resetItem = new JMenuItem("Reset");
        this.resetItem.setActionCommand(this.resetItem.getText());
        this.resetItem.addActionListener(this);
        if (!((InlineConstraintApplet)this.parent).isPopupMenuOn()) {
            this.pop.setPopupSize(0, 0);
        }
    }

    @Override
    protected void popupSCanv() {
        super.popupSCanv();
        if (!((InlineConstraintApplet)this.parent).isPopupMenuOn()) {
            this.pop.setPopupSize(0, 0);
        }
        if (!((InlineConstraintApplet)this.parent).fsPopupOn) {
            this.fineStepItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).resetPopupOn) {
            this.resetItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).btckPopupOn) {
            this.backTrackItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).stpBackPopupOn) {
            this.stepBackItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).stopPopupOn) {
            this.stopItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).autoslvPopupOn) {
            this.autoSolveItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).autoacPopupOn) {
            this.autoACItem.setVisible(false);
        }
        if (!((InlineConstraintApplet)this.parent).stepPopupOn) {
            this.stepItem.setVisible(false);
        }
        if (((InlineConstraintApplet)this.parent).textRepresentationPopupOn) {
            this.pop.addSeparator();
            JMenuItem mItem = new JMenuItem("View Text Representation");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("View Current State Text Representation");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return true;
    }

    @Override
    public void autoAC() {
        this.auto = new AutoAC(this, this.dt, (ConstraintCSP)this.csp);
        ((InlineConstraintApplet)this.parent).setPromptLabel("Running auto arc-consistency...");
        this.auto.start();
    }

    @Override
    public void stopAC() {
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
        ((InlineConstraintApplet)this.parent).setPromptLabel("Stopped auto arc-consistency");
    }

    @Override
    public void doneAC() {
        ((InlineConstraintApplet)this.parent).setACButtons(false);
        ((InlineConstraintApplet)this.parent).autoSolveButton.setEnabled(true);
        this.autoSolveItem.setEnabled(true);
        ((InlineConstraintApplet)this.parent).stopButton.setEnabled(false);
        this.stopItem.setEnabled(false);
        ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
        if (this.checkSolutions() == MORE_SOLUTION_SPLIT) {
            ((InlineConstraintApplet)this.parent).setPromptLabel("Auto arc-consistency finished.\nClick on a variable to split its domain and try again.");
        } else if (this.checkSolutions() == NO_MORE_SOLUTIONS) {
            this.ACSolve();
        }
        this.fineStepEdge = null;
        this.repaint();
    }

    @Override
    public boolean fineStep(CnsConstraintEdge edge) {
        this.lastStepWasStep = false;
        if (this.fineStepCount == 0) {
            ((InlineConstraintApplet)this.parent).stepBackButton.setEnabled(false);
            this.stepBackItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).setPromptLabel("Selected arc: " + edge.printString());
            edge.xw = this.graph.getLineWidth() + 1;
            ++this.fineStepCount;
        } else if (this.fineStepCount == 1) {
            edge.removeFromQueue();
            boolean inconsistent = this.stepOne(edge);
            edge.setConsistent(!inconsistent);
            if (!inconsistent) {
                ((InlineConstraintApplet)this.parent).setPromptLabel("Arc " + edge.printString() + " is consistent");
                this.fineStepCount = 0;
                edge.xw = 0;
                ((ConstraintCSP)this.csp).saveStepInfo();
                ((InlineConstraintApplet)this.parent).stepBackButton.setEnabled(true);
                this.stepBackItem.setEnabled(true);
                edge.setStepArc();
                return false;
            }
            ((InlineConstraintApplet)this.parent).stepBackButton.setEnabled(false);
            this.stepBackItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).setPromptLabel("Arc " + edge.printString() + " is inconsistent");
            ++this.fineStepCount;
            this.stepTwo(edge);
            ++this.fineStepCount;
        } else if (this.fineStepCount == 2) {
            ((InlineConstraintApplet)this.parent).stepBackButton.setEnabled(false);
            this.stepBackItem.setEnabled(false);
            this.stepTwo(edge);
            ++this.fineStepCount;
        } else if (this.fineStepCount == 3) {
            edge.xw = 0;
            this.stepThree(edge);
            ((InlineConstraintApplet)this.parent).stepBackButton.setEnabled(true);
            this.stepBackItem.setEnabled(true);
            ((ConstraintCSP)this.csp).saveStepInfo();
            edge.setStepArc();
            this.fineStepCount = 0;
            return false;
        }
        return true;
    }

    @Override
    public void doneAutoSolve() {
        ((InlineConstraintApplet)this.parent).setACButtons(false);
        ((InlineConstraintApplet)this.parent).autoSolveButton.setEnabled(true);
        this.autoSolveItem.setEnabled(true);
        ((InlineConstraintApplet)this.parent).stopButton.setEnabled(false);
        this.stopItem.setEnabled(false);
        ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
        if (!this.lastSolution && this.nextSolve == ConstraintCanvas.NO_MORE_SOLUTIONS) {
            ((InlineConstraintApplet)this.parent).setPromptLabel("No more solutions.");
        } else if (this.nextSolve == ConstraintCanvas.FAIL_NO_MORE_SOLUTIONS) {
            this.lastSolution = false;
            ((InlineConstraintApplet)this.parent).setPromptLabel("No solution found. No more solutions.");
            this.setNextSolve(ConstraintCanvas.NO_MORE_SOLUTIONS);
        } else {
            this.lastSolution = false;
            ((InlineConstraintApplet)this.parent).setPromptLabel("Solution found.\nClick AutoSolve again to find more solutions.");
        }
        this.repaint();
    }

    @Override
    public void stepback() {
        if (((ConstraintCSP)this.csp).stepBack()) {
            this.stepBackItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).backtrackButton.setEnabled(false);
        }
    }

    @Override
    public int checkSolutions() {
        StringBuffer solution = new StringBuffer();
        ArrayList<CSPVariable> variables = ((InlineConstraintApplet)this.parent).returnCSP().getVariables();
        boolean case3 = false;
        for (CSPVariable currVar : variables) {
            solution.append(" ").append(currVar.getName()).append(" = ").append(currVar.getDomain().getSplitRep()).append(",");
            if (currVar.getDomain().getVisibleDomainSize() == 0) {
                if (((InlineConstraintApplet)this.parent).hasMoreSplits()) {
                    ((InlineConstraintApplet)this.parent).setPromptLabel("No solution, backtrack and try solving again");
                } else {
                    ((InlineConstraintApplet)this.parent).setPromptLabel("No solution");
                }
                if (((InlineConstraintApplet)this.parent).domainSplit) {
                    ((InlineConstraintApplet)this.parent).ta.append("\n");
                    int i = 0;
                    while (i < ((InlineConstraintApplet)this.parent).getIndent()) {
                        ((InlineConstraintApplet)this.parent).ta.append("    ");
                        ++i;
                    }
                    ((InlineConstraintApplet)this.parent).ta.append("Failure");
                }
                return FAIL_NO_MORE_SOLUTIONS;
            }
            if (currVar.getDomain().getVisibleDomainSize() <= 1) continue;
            case3 = true;
        }
        if (case3) {
            ((InlineConstraintApplet)this.parent).setPromptLabel("Click on a variable to split its domain and try again.");
            return MORE_SOLUTION_SPLIT;
        }
        solution.deleteCharAt(solution.lastIndexOf(","));
        ((InlineConstraintApplet)this.parent).setPromptLabel("Solution found: " + solution);
        if (((InlineConstraintApplet)this.parent).domainSplit) {
            ((InlineConstraintApplet)this.parent).ta.append("\n");
            int i = 0;
            while (i < ((InlineConstraintApplet)this.parent).getIndent()) {
                ((InlineConstraintApplet)this.parent).ta.append("    ");
                ++i;
            }
            ((InlineConstraintApplet)this.parent).ta.append("Solution found: " + solution);
        }
        return NO_MORE_SOLUTIONS;
    }

    @Override
    public int checkSolutionsforAutoSolve() {
        ArrayList<CSPVariable> variables = ((InlineConstraintApplet)this.parent).returnCSP().getVariables();
        boolean isCase3 = false;
        for (CSPVariable currVar : variables) {
            if (currVar.getDomain().getVisibleDomainSize() == 0) {
                ((InlineConstraintApplet)this.parent).ta.append("\n");
                int i = 0;
                while (i < ((ConstraintWindow)this.parent).getIndent()) {
                    ((InlineConstraintApplet)this.parent).ta.append("    ");
                    ++i;
                }
                ((InlineConstraintApplet)this.parent).ta.append("Failure");
                if (((InlineConstraintApplet)this.parent).hasMoreSplits()) {
                    return FAIL_BACKTRACK;
                }
                return FAIL_NO_MORE_SOLUTIONS;
            }
            if (currVar.getDomain().getVisibleDomainSize() <= 1) continue;
            isCase3 = true;
        }
        if (isCase3) {
            return SPLIT;
        }
        if (((InlineConstraintApplet)this.parent).hasMoreSplits()) {
            return SOLUTION_BACKTRACK;
        }
        return NO_MORE_SOLUTIONS;
    }

    @Override
    protected void splitDomain(ConstraintVariable node) {
        this.backtrackDialog = new SplitNodeDialog(this);
        this.backtrackDialog.open(node, (ConstraintCSP)this.csp);
        if (!this.backtrackDialog.isCancelled()) {
            ((InlineConstraintApplet)this.parent).setACButtons(true);
            ((InlineConstraintApplet)this.parent).domainSplittingOccurred(node);
        }
        this.repaint();
    }

    @Override
    public void ACSolve() {
        if (!((InlineConstraintApplet)this.parent).domainSplit) {
            this.printSolutions();
            this.setNextSolve(ConstraintCanvas.NO_MORE_SOLUTIONS);
            this.lastSolution = false;
        } else {
            this.setNextSolve(ConstraintCanvas.SOLUTION_BACKTRACK);
        }
    }

    @Override
    protected void aSolvePerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Fine Step")) {
            if (!this.fineStep()) {
                ((InlineConstraintApplet)this.parent).fineStepButton.setSelected(true);
                this.repaint();
                ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
            } else {
                this.checkSolutions();
                ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
            }
        } else if (arg.equals("Step")) {
            if (!this.step()) {
                ((InlineConstraintApplet)this.parent).stepButton.setSelected(true);
                this.repaint();
                ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
            } else {
                this.checkSolutions();
                ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
            }
        } else if (arg.equals("Auto Arc-Consistency")) {
            ((InlineConstraintApplet)this.parent).autoSolveButton.setEnabled(false);
            this.autoSolveItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).autoACButton.setSelected(true);
            ((InlineConstraintApplet)this.parent).stopButton.setEnabled(true);
            this.stopItem.setEnabled(true);
            ((InlineConstraintApplet)this.parent).autoArcStart();
        } else if (arg.equals("AutoSolve")) {
            this.stopItem.setEnabled(true);
            ((InlineConstraintApplet)this.parent).autoSolveButton.setSelected(true);
            ((InlineConstraintApplet)this.parent).stopButton.setEnabled(true);
            ((InlineConstraintApplet)this.parent).autoSolveStart();
        } else if (arg.equals("Step Back")) {
            this.stepback();
            this.repaint();
            ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
        } else if (arg.equals("Stop")) {
            this.stopItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).stopButton.setEnabled(false);
            this.fineStepItem.setEnabled(true);
            ((InlineConstraintApplet)this.parent).fineStepButton.setEnabled(true);
            this.stepItem.setEnabled(true);
            ((InlineConstraintApplet)this.parent).stepButton.setEnabled(true);
            this.autoACItem.setEnabled(true);
            ((InlineConstraintApplet)this.parent).autoACButton.setEnabled(true);
            this.autoSolveItem.setEnabled(true);
            ((InlineConstraintApplet)this.parent).autoSolveButton.setEnabled(true);
            if (this.autosolve != null) {
                this.stopSolving();
                ((InlineConstraintApplet)this.parent).autoSolveButton.setEnabled(false);
                this.autoSolveItem.setEnabled(false);
            }
            if (this.auto != null) {
                this.stopAC();
            }
            this.repaint();
        } else if (arg.equals("Backtrack")) {
            ((InlineConstraintApplet)this.parent).backtrackingOccurred(this.backtrack(), true);
        } else if (arg.equals("Reset")) {
            this.stopSolving();
            this.stopAC();
            ((InlineConstraintApplet)this.parent).stopButton.setEnabled(false);
            this.stopItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).autoSolveButton.setEnabled(false);
            this.autoSolveItem.setEnabled(false);
            ((InlineConstraintApplet)this.parent).fakeButton.setSelected(true);
            while (this.auto != null && this.auto.isAlive() || this.autosolve != null && this.autosolve.isAlive()) {
            }
            ((InlineConstraintApplet)this.parent).resetWindow();
            this.backTrackItem.setEnabled(false);
            this.stepBackItem.setEnabled(false);
            this.resetItem.setEnabled(true);
            this.stopItem.setEnabled(false);
            this.autoSolveItem.setEnabled(true);
            this.autoACItem.setEnabled(true);
            this.stepItem.setEnabled(true);
            this.fineStepItem.setEnabled(true);
            this.repaint();
        } else if (arg.equals("View Text Representation")) {
            new CSPTextFrame(this, IO.createXML(this.csp, false), "Text Representaion of the Graph", false);
        } else if (arg.equals("View Current State Text Representation")) {
            new CSPTextFrame(this, IO.createXML(this.csp, true), "Current State Text Representaion", false);
        } else {
            super.aSolvePerformed(e);
        }
    }
}

